/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Log;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ILogEntryListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSResourceVariantFileRevision;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSURI;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderMemberFetcher;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class RemoteFile
extends RemoteResource
implements ICVSRemoteFile {
    private byte[] syncBytes;
    private ILogEntry entry;
    private boolean fetching = false;
    private boolean executable = false;

    public static RemoteFile getBase(RemoteFolder parent, ICVSFile managed) throws CVSException {
        Assert.isNotNull((Object)parent, (String)("A parent folder must be provided for file " + managed.getName()));
        byte[] syncBytes = managed.getSyncBytes();
        if (syncBytes == null || ResourceSyncInfo.isAddition(syncBytes)) {
            return null;
        }
        if (ResourceSyncInfo.isDeletion(syncBytes)) {
            syncBytes = ResourceSyncInfo.convertFromDeletion(syncBytes);
        }
        RemoteFile file = new RemoteFile(parent, syncBytes);
        parent.setChildren(new ICVSRemoteResource[]{file});
        return file;
    }

    public static RemoteFile fromBytes(IResource local, byte[] bytes, byte[] parentBytes) throws CVSException {
        Assert.isNotNull((Object)bytes);
        Assert.isTrue((local.getType() == 1 ? 1 : 0) != 0);
        RemoteFolder parent = RemoteFolder.fromBytes((IResource)local.getParent(), parentBytes);
        RemoteFile file = new RemoteFile(parent, bytes);
        parent.setChildren(new ICVSRemoteResource[]{file});
        return file;
    }

    public static RemoteFile create(String filePath, ICVSRepositoryLocation location) {
        return RemoteFile.create(filePath, location, null, null);
    }

    public static RemoteFile create(String filePath, ICVSRepositoryLocation location, CVSTag tag, String revision) {
        Assert.isNotNull((Object)filePath);
        Assert.isNotNull((Object)location);
        Path path = new Path(null, filePath);
        if (tag != null && revision != null && tag.getName().equals(revision)) {
            tag = null;
        }
        RemoteFolder parent = new RemoteFolder(null, location, path.removeLastSegments(1).toString(), tag);
        RemoteFile file = new RemoteFile(parent, 0, path.lastSegment(), revision, null, tag);
        parent.setChildren(new ICVSRemoteResource[]{file});
        return file;
    }

    public RemoteFile(RemoteFolder parent, int workspaceSyncState, String name, String revision, Command.KSubstOption keywordMode, CVSTag tag) {
        this(parent, name, workspaceSyncState, RemoteFile.getSyncBytes(name, revision, keywordMode, tag));
    }

    private static byte[] getSyncBytes(String name, String revision, Command.KSubstOption keywordMode, CVSTag tag) {
        if (revision == null) {
            revision = "0";
        }
        if (keywordMode == null) {
            keywordMode = Command.KSubstOption.fromMode("");
        }
        MutableResourceSyncInfo newInfo = new MutableResourceSyncInfo(name, revision);
        newInfo.setKeywordMode(keywordMode);
        newInfo.setTag(tag);
        return newInfo.getBytes();
    }

    public RemoteFile(RemoteFolder parent, byte[] syncBytes) throws CVSException {
        this(parent, 0, syncBytes);
    }

    RemoteFile(RemoteFolder parent, int workspaceSyncState, byte[] syncBytes) throws CVSException {
        this(parent, ResourceSyncInfo.getName(syncBytes), workspaceSyncState, syncBytes);
    }

    private RemoteFile(RemoteFolder parent, String name, int workspaceSyncState, byte[] syncBytes) {
        super(parent, name);
        this.syncBytes = syncBytes;
        this.setWorkspaceSyncState(workspaceSyncState);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFile(this);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFile(this);
    }

    @Override
    public InputStream getContents(IProgressMonitor monitor) throws CVSException {
        try {
            return this.getStorage(monitor).getContents();
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        try {
            this.aboutToReceiveContents(this.getSyncBytes());
            this.internalFetchContents(monitor);
            if (!this.isContentsCached()) {
                this.setContents(new ByteArrayInputStream(new byte[0]), monitor);
            }
        }
        finally {
            this.doneReceivingContents();
        }
    }

    private void internalFetchContents(IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(CVSMessages.RemoteFile_getContents, 100);
        monitor.subTask(CVSMessages.RemoteFile_getContents);
        if (this.getRevision().equals("0")) {
            CVSTag tag = this.getSyncInfo().getTag();
            if (tag == null) {
                tag = CVSTag.DEFAULT;
            }
            RemoteFolderMemberFetcher fetcher = new RemoteFolderMemberFetcher((RemoteFolder)this.getParent(), tag);
            fetcher.updateFileRevisions(new ICVSFile[]{this}, Policy.subMonitorFor(monitor, 10));
        }
        Session session = new Session(this.getRepository(), this.parent, false);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            IStatus status = Command.UPDATE.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Update.makeTagOption(new CVSTag(this.getRevision(), 2)), Update.IGNORE_LOCAL_CHANGES}, new ICVSResource[]{this}, null, Policy.subMonitorFor(monitor, 80));
            if (status.getCode() == -10) {
                throw new CVSServerException(status);
            }
        }
        finally {
            session.close();
            monitor.done();
        }
    }

    @Override
    public ILogEntry getLogEntry(IProgressMonitor monitor) throws CVSException {
        if (this.entry == null) {
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(CVSMessages.RemoteFile_getLogEntries, 100);
            session.open(Policy.subMonitorFor(monitor, 10), false);
            try (Session session = new Session(this.getRepository(), this.parent, false);){
                try {
                    LogEntryListener listener = new LogEntryListener();
                    IStatus status = Command.LOG.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Log.makeRevisionOption(this.getRevision())}, new ICVSResource[]{this}, (ICommandOutputListener)new LogListener(this, listener), Policy.subMonitorFor(monitor, 90));
                    ILogEntry[] entries = listener.getEntries();
                    if (entries.length == 1) {
                        this.entry = entries[0];
                    }
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        return this.entry;
    }

    @Override
    public ILogEntry[] getLogEntries(IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(CVSMessages.RemoteFile_getLogEntries, 100);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try (Session session = new Session(this.getRepository(), this.parent, false);){
            ILogEntry[] iLogEntryArray;
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                LogEntryListener listener = new LogEntryListener();
                IStatus status = Command.LOG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, new ICVSResource[]{this}, (ICommandOutputListener)new LogListener(this, listener), Policy.subMonitorFor(monitor, 90));
                if (status.getCode() == -10) {
                    throw new CVSServerException(status);
                }
                iLogEntryArray = listener.getEntries();
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
            }
            catch (Throwable throwable) {
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return iLogEntryArray;
        }
    }

    @Override
    public String getRevision() {
        try {
            return ResourceSyncInfo.getRevision(this.syncBytes);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return "0";
        }
    }

    private Command.KSubstOption getKeywordMode() {
        try {
            return ResourceSyncInfo.getKeywordMode(this.syncBytes);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return Command.KSubstOption.getDefaultTextMode();
        }
    }

    public RemoteFile toRevision(String revision) {
        RemoteFolder newParent = new RemoteFolder(null, this.parent.getRepository(), this.parent.getRepositoryRelativePath(), this.parent.getTag());
        RemoteFile file = new RemoteFile(newParent, this.getWorkspaceSyncState(), this.getName(), revision, this.getKeywordMode(), CVSTag.DEFAULT);
        newParent.setChildren(new ICVSRemoteResource[]{file});
        return file;
    }

    @Override
    public ResourceSyncInfo getSyncInfo() {
        try {
            return new ResourceSyncInfo(this.syncBytes);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    @Override
    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        return String.valueOf(this.parent.getRemoteLocation(stopSearching)) + "/" + this.getName();
    }

    @Override
    public String getRepositoryRelativePath() {
        String parentPath = this.parent.getRepositoryRelativePath();
        return String.valueOf(parentPath) + "/" + this.getName();
    }

    @Override
    public ICVSRepositoryLocation getRepository() {
        return this.parent.getRepository();
    }

    @Override
    public void setSyncInfo(ResourceSyncInfo fileInfo, int modificationState) {
        this.setSyncBytes(fileInfo.getBytes(), modificationState);
    }

    public void setRevision(String revision) throws CVSException {
        this.syncBytes = ResourceSyncInfo.setRevision(this.syncBytes, revision);
    }

    @Override
    public InputStream getContents() throws CVSException {
        if (!this.fetching && this.isContentsCached()) {
            try {
                InputStream cached = this.getCachedContents();
                if (cached != null) {
                    return cached;
                }
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    protected InputStream getCachedContents() throws TeamException {
        byte[] newSyncBytes;
        RemoteFile file;
        if (this.isHandleCached() && (file = (RemoteFile)this.getCachedHandle()) != null && (newSyncBytes = file.getSyncBytes()) != null) {
            this.syncBytes = newSyncBytes;
        }
        return super.getCachedContents();
    }

    @Override
    public void setContents(InputStream stream, int responseType, boolean keepLocalHistory, IProgressMonitor monitor) throws CVSException {
        try {
            this.setContents(stream, monitor);
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Date getTimeStamp() {
        return this.getSyncInfo().getTimeStamp();
    }

    @Override
    public void setTimeStamp(Date date) {
    }

    @Override
    public void copyTo(String mFile) {
    }

    @Override
    public ICVSRemoteResource[] members(IProgressMonitor progress) {
        return new ICVSRemoteResource[0];
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public IStatus tag(CVSTag tag, Command.LocalOption[] localOptions, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        session.open(Policy.subMonitorFor(monitor, 10), true);
        try (Session session = new Session(this.getRepository(), this.getParent(), true);){
            IStatus iStatus = Command.RTAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, new CVSTag(this.getRevision(), 2), tag, new ICVSRemoteResource[]{this}, Policy.subMonitorFor(monitor, 90));
            return iStatus;
        }
    }

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remote = (RemoteFile)target;
        return super.equals(target) && remote.getRevision().equals(this.getRevision());
    }

    @Override
    public void edit(int notifications, boolean notifyForWritable, IProgressMonitor monitor) {
    }

    @Override
    public void unedit(IProgressMonitor monitor) {
    }

    @Override
    public void notificationCompleted() {
    }

    @Override
    public NotifyInfo getPendingNotification() {
        return null;
    }

    @Override
    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tag) {
        return new RemoteFile((RemoteFolder)parent, this.getWorkspaceSyncState(), this.getName(), this.getRevision(), this.getKeywordMode(), tag);
    }

    @Override
    public ICVSRemoteResource forTag(CVSTag tag) {
        RemoteFolderTree remoteFolder = new RemoteFolderTree(null, this.getRepository(), ((ICVSRemoteFolder)this.getParent()).getRepositoryRelativePath(), tag);
        RemoteFile remoteFile = (RemoteFile)this.forTag(remoteFolder, tag);
        remoteFolder.setChildren(new ICVSRemoteResource[]{remoteFile});
        return remoteFile;
    }

    @Override
    public void checkedIn(String info, boolean commit) {
    }

    @Override
    public boolean isEdited() {
        return false;
    }

    @Override
    public byte[] getSyncBytes() {
        return this.syncBytes;
    }

    @Override
    public void setSyncBytes(byte[] syncBytes, int modificationState) {
        if (this.fetching) {
            RemoteFile file = (RemoteFile)this.getCachedHandle();
            if (file == null) {
                this.cacheHandle();
            } else if (file != this) {
                file.setSyncBytes(syncBytes, modificationState);
            }
        }
        this.syncBytes = syncBytes;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getRevision();
    }

    public String getContentIdentifier() {
        return this.getRevision();
    }

    public void aboutToReceiveContents(byte[] entryLine) {
        try {
            entryLine = ResourceSyncInfo.setSlot(this.syncBytes, 3, new byte[0]);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        this.setSyncBytes(entryLine, 1);
        this.fetching = true;
    }

    public void doneReceivingContents() {
        this.fetching = false;
    }

    public boolean isContentsCached() {
        return super.isContentsCached();
    }

    public void setContents(IFile file, IProgressMonitor monitor) throws TeamException, CoreException {
        this.setContents(file.getContents(), monitor);
    }

    @Override
    public void setExecutable(boolean executable) throws CVSException {
        RemoteFile file;
        this.executable = executable;
        if (!this.isHandleCached()) {
            this.cacheHandle();
        }
        if ((file = (RemoteFile)this.getCachedHandle()) != this) {
            file.setExecutable(executable);
        }
    }

    @Override
    public boolean isExecutable() throws CVSException {
        return this.executable;
    }

    public CachedResourceVariant getCachedHandle() {
        return super.getCachedHandle();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFileRevision.class) {
            return new CVSResourceVariantFileRevision((IResourceVariant)this);
        }
        return super.getAdapter(adapter);
    }

    public CVSURI toCVSURI() {
        ResourceSyncInfo info = this.getSyncInfo();
        return new CVSURI(this.getRepository(), (IPath)new Path(this.getRepositoryRelativePath()), info.getTag(), info.getRevision());
    }

    private final class LogEntryListener
    implements ILogEntryListener {
        private final List entries = new ArrayList();

        private LogEntryListener() {
        }

        @Override
        public void handleLogEntryReceived(ILogEntry entry) {
            if (entry.getRemoteFile().getRepositoryRelativePath().equals(RemoteFile.this.getRepositoryRelativePath())) {
                this.entries.add(entry);
            }
        }

        public ILogEntry[] getEntries() {
            return this.entries.toArray(new ILogEntry[this.entries.size()]);
        }
    }
}

