/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.wizards;

import java.util.List;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.discovery.core.DiscoveryCore;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.ui.wizards.ConnectorDiscoveryWizard;
import org.eclipse.mylyn.internal.discovery.ui.wizards.DiscoveryViewer;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ConnectorDiscoveryWizardMainPage
extends WizardPage
implements IShellProvider {
    private static final int MINIMUM_HEIGHT = 480;
    private DiscoveryViewer viewer;

    public ConnectorDiscoveryWizardMainPage() {
        super(ConnectorDiscoveryWizardMainPage.class.getSimpleName());
        this.setTitle(Messages.ConnectorDiscoveryWizardMainPage_connectorDiscovery);
        this.setDescription(Messages.ConnectorDiscoveryWizardMainPage_pageDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.viewer = new DiscoveryViewer(this, (IRunnableContext)this.getContainer());
        this.viewer.setShowConnectorDescriptorKindFilter(this.getWizard().isShowConnectorDescriptorKindFilter());
        this.viewer.setShowConnectorDescriptorTextFilter(this.getWizard().isShowConnectorDescriptorTextFilter());
        this.viewer.setVerifyUpdateSiteAvailability(true);
        this.viewer.setShowInstalledFilterEnabled(true);
        this.viewer.setMinimumHeight(480);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectorDiscoveryWizardMainPage.this.setPageComplete(!ConnectorDiscoveryWizardMainPage.this.viewer.getInstallableConnectors().isEmpty());
            }
        });
        this.viewer.createControl(parent);
        String url = DiscoveryCore.getDiscoveryUrl();
        if (url.length() > 0) {
            this.viewer.setDirectoryUrl(url);
        }
        this.viewer.setEnvironment(this.getWizard().getEnvironment());
        this.setControl(this.viewer.getControl());
    }

    public ConnectorDiscoveryWizard getWizard() {
        return (ConnectorDiscoveryWizard)super.getWizard();
    }

    public List<ConnectorDescriptor> getInstallableConnectors() {
        return this.viewer.getInstallableConnectors();
    }

    private void maybeUpdateDiscovery() {
        if (!this.getControl().isDisposed() && this.isCurrentPage() && this.viewer.getDiscovery() == null) {
            this.viewer.updateDiscovery();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.viewer.getDiscovery() == null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectorDiscoveryWizardMainPage.this.maybeUpdateDiscovery();
                }
            });
        }
    }
}

