/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.DisconnectOperation;
import org.eclipse.ui.PlatformUI;

public class UnmanageAction
extends WorkspaceAction {
    private boolean deleteContent = false;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (this.confirmDeleteProjects()) {
            new DisconnectOperation(this.getTargetPart(), this.getSelectedProjects(), this.deleteContent).run();
        }
    }

    boolean confirmDeleteProjects() {
        final int[] result = new int[1];
        IProject[] projects = this.getSelectedProjects();
        final DeleteProjectDialog dialog = new DeleteProjectDialog(this.getShell(), projects);
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = dialog.open();
            }
        });
        this.deleteContent = dialog.getDeleteContent();
        return result[0] == 0;
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.Unmanage_unmanagingError;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        IResource resource = cvsResource.getIResource();
        return resource != null && resource.getType() == 4;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        boolean deleteContent = false;
        Button radio1;
        Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    deleteContent = button == radio1;
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IProject[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        static String getTitle(IProject[] projects) {
            if (projects.length == 1) {
                return CVSUIMessages.Unmanage_title;
            }
            return CVSUIMessages.Unmanage_titleN;
        }

        static String getMessage(IProject[] projects) {
            if (projects.length == 1) {
                IProject project = projects[0];
                return NLS.bind((String)CVSUIMessages.Unmanage_message, (Object[])new String[]{project.getName()});
            }
            return NLS.bind((String)CVSUIMessages.Unmanage_messageN, (Object[])new String[]{new Integer(projects.length).toString()});
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            this.radio1.setText(CVSUIMessages.Unmanage_option2);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            this.radio2.setText(CVSUIMessages.Unmanage_option1);
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.disconnect_action_context");
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }
    }
}

