/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.util.StringMatcher;
import org.eclipse.team.internal.ccvs.ui.tags.TagElement;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FilteredTagList
implements IWorkbenchAdapter,
IAdaptable {
    private final TagSource tagSource;
    private final int[] types;
    private StringMatcher matcher;

    public FilteredTagList(TagSource tagSource, int[] types) {
        this.tagSource = tagSource;
        this.types = types;
    }

    public Object[] getChildren(Object o) {
        CVSTag[] tags = this.getTags();
        ArrayList<TagElement> filtered = new ArrayList<TagElement>();
        int i = 0;
        while (i < tags.length) {
            CVSTag tag = tags[i];
            if (this.select(tag)) {
                filtered.add(new TagElement(this, tag));
            }
            ++i;
        }
        return filtered.toArray(new Object[filtered.size()]);
    }

    private boolean select(CVSTag tag) {
        if (this.matcher == null) {
            return true;
        }
        return this.matcher.match(tag.getName());
    }

    private CVSTag[] getTags() {
        return this.tagSource.getTags(this.types);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public void setPattern(String pattern) {
        if (!pattern.endsWith("*")) {
            pattern = String.valueOf(pattern) + "*";
        }
        this.matcher = new StringMatcher(pattern, true, false);
    }

    public CVSTag[] getMatchingTags() {
        CVSTag[] tags = this.getTags();
        ArrayList<CVSTag> filtered = new ArrayList<CVSTag>();
        int i = 0;
        while (i < tags.length) {
            CVSTag tag = tags[i];
            if (this.select(tag)) {
                filtered.add(tag);
            }
            ++i;
        }
        return filtered.toArray(new CVSTag[filtered.size()]);
    }
}

