/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.memcheck;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.linuxtools.internal.valgrind.memcheck.MemcheckLaunchConstants;
import org.eclipse.linuxtools.internal.valgrind.memcheck.MemcheckPlugin;
import org.eclipse.linuxtools.internal.valgrind.memcheck.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Version;

public class MemcheckToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    private static final Version VER_3_4_0 = new Version(3, 4, 0);
    private static final Version VER_3_6_0 = new Version(3, 6, 0);
    private Button leakCheckButton;
    private Combo leakResCombo;
    private Button showReachableButton;
    private Spinner freelistSpinner;
    private Button partialLoadsButton;
    private Button undefValueButton;
    private Button gccWorkaroundButton;
    private Button alignmentButton;
    private Spinner alignmentSpinner;
    private Button mallocFillButton;
    private Text mallocFillText;
    private Button freeFillButton;
    private Text freeFillText;
    private org.eclipse.swt.widgets.List ignoreRangesList;
    private Button trackOriginsButton;
    private Button showPossiblyLostButton;
    private boolean isInitializing = false;
    private Version valgrindVersion;
    private CoreException ex = null;
    private SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MemcheckToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener modifyListener = e -> this.updateLaunchConfigurationDialog();

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout memcheckLayout = new GridLayout(2, true);
        top.setLayout((Layout)memcheckLayout);
        top.setLayoutData((Object)new GridData(768));
        this.leakCheckButton = new Button(top, 32);
        this.leakCheckButton.setLayoutData((Object)new GridData(768));
        this.leakCheckButton.setText(Messages.getString("MemcheckToolPage.leak_check"));
        this.leakCheckButton.addSelectionListener(this.selectListener);
        Composite leakResTop = new Composite(top, 0);
        leakResTop.setLayout((Layout)new GridLayout(2, false));
        leakResTop.setLayoutData((Object)new GridData(768));
        Label leakResLabel = new Label(leakResTop, 0);
        leakResLabel.setText(Messages.getString("MemcheckToolPage.leak_resolution"));
        this.leakResCombo = new Combo(leakResTop, 8);
        String[] leakResOpts = new String[]{"low", "med", "high"};
        this.leakResCombo.setItems(leakResOpts);
        this.leakResCombo.addSelectionListener(this.selectListener);
        Composite freelistTop = new Composite(top, 0);
        freelistTop.setLayout((Layout)new GridLayout(2, false));
        freelistTop.setLayoutData((Object)new GridData(768));
        Label freelistLabel = new Label(freelistTop, 0);
        freelistLabel.setText(Messages.getString("MemcheckToolPage.freelist_size"));
        this.freelistSpinner = new Spinner(freelistTop, 2048);
        this.freelistSpinner.setMaximum(Integer.MAX_VALUE);
        this.freelistSpinner.addModifyListener(this.modifyListener);
        this.showReachableButton = new Button(top, 32);
        this.showReachableButton.setLayoutData((Object)new GridData(768));
        this.showReachableButton.setText(Messages.getString("MemcheckToolPage.show_reachable"));
        this.showReachableButton.addSelectionListener(this.selectListener);
        this.partialLoadsButton = new Button(top, 32);
        this.partialLoadsButton.setLayoutData((Object)new GridData(768));
        this.partialLoadsButton.setText(Messages.getString("MemcheckToolPage.allow_partial"));
        this.partialLoadsButton.addSelectionListener(this.selectListener);
        this.undefValueButton = new Button(top, 32);
        this.undefValueButton.setLayoutData((Object)new GridData(768));
        this.undefValueButton.setText(Messages.getString("MemcheckToolPage.undef_value_errors"));
        this.undefValueButton.addSelectionListener(this.selectListener);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_4_0) >= 0) {
            this.trackOriginsButton = new Button(top, 32);
            this.trackOriginsButton.setLayoutData((Object)new GridData(768));
            this.trackOriginsButton.setText(Messages.getString("MemcheckToolPage.Track_origins"));
            this.trackOriginsButton.addSelectionListener(this.selectListener);
        }
        this.gccWorkaroundButton = new Button(top, 32);
        this.gccWorkaroundButton.setLayoutData((Object)new GridData(768));
        this.gccWorkaroundButton.setText(Messages.getString("MemcheckToolPage.gcc_296_workarounds"));
        this.gccWorkaroundButton.addSelectionListener(this.selectListener);
        Composite alignmentTop = new Composite(top, 0);
        GridLayout alignmentLayout = new GridLayout(2, false);
        alignmentLayout.marginHeight = 0;
        alignmentLayout.marginWidth = 0;
        alignmentTop.setLayout((Layout)alignmentLayout);
        alignmentTop.setLayoutData((Object)new GridData(768));
        this.alignmentButton = new Button(alignmentTop, 32);
        this.alignmentButton.setText(Messages.getString("MemcheckToolPage.minimum_heap_block"));
        this.alignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.checkAlignmentEnablement();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.alignmentSpinner = new Spinner(alignmentTop, 2048);
        this.alignmentSpinner.setMinimum(0);
        this.alignmentSpinner.setMaximum(4096);
        this.alignmentSpinner.addModifyListener(this.modifyListener);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            this.showPossiblyLostButton = new Button(top, 32);
            this.showPossiblyLostButton.setLayoutData((Object)new GridData(768));
            this.showPossiblyLostButton.setText(Messages.getString("MemcheckToolPage.Show_Possibly_Lost"));
            this.showPossiblyLostButton.addSelectionListener(this.selectListener);
        }
        Composite mallocFillTop = new Composite(top, 0);
        GridLayout mallocFillLayout = new GridLayout(2, false);
        mallocFillLayout.marginHeight = 0;
        mallocFillLayout.marginWidth = 0;
        mallocFillTop.setLayout((Layout)mallocFillLayout);
        mallocFillTop.setLayoutData((Object)new GridData(768));
        this.mallocFillButton = new Button(mallocFillTop, 32);
        this.mallocFillButton.setText(Messages.getString("MemcheckToolPage.Malloc_Fill"));
        this.mallocFillButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.checkMallocFillEnablement();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.mallocFillText = new Text(mallocFillTop, 2048);
        this.mallocFillText.setTextLimit(8);
        this.mallocFillText.addModifyListener(this.modifyListener);
        Composite freeFillTop = new Composite(top, 0);
        GridLayout freeFillLayout = new GridLayout(2, false);
        freeFillLayout.marginHeight = 0;
        freeFillLayout.marginWidth = 0;
        freeFillTop.setLayout((Layout)freeFillLayout);
        freeFillTop.setLayoutData((Object)new GridData(768));
        this.freeFillButton = new Button(freeFillTop, 32);
        this.freeFillButton.setText(Messages.getString("MemcheckToolPage.Free_Fill"));
        this.freeFillButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.checkFreeFillEnablement();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        this.freeFillText = new Text(freeFillTop, 2048);
        this.mallocFillText.setTextLimit(8);
        this.freeFillText.addModifyListener(this.modifyListener);
        Composite ignoreRangesTop = new Composite(top, 0);
        ignoreRangesTop.setLayout((Layout)new GridLayout(3, false));
        ignoreRangesTop.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label ignoreRangesLabel = new Label(ignoreRangesTop, 0);
        ignoreRangesLabel.setText(Messages.getString("MemcheckToolPage.Ignore_Ranges"));
        ignoreRangesLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.createIgnoreRangesControls(ignoreRangesTop);
    }

    private void createIgnoreRangesControls(Composite top) {
        this.ignoreRangesList = new org.eclipse.swt.widgets.List(top, 2818);
        FontMetrics fm = MemcheckPlugin.getFontMetrics((Control)this.ignoreRangesList);
        this.ignoreRangesList.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)50), Dialog.convertHeightInCharsToPixels((FontMetrics)fm, (int)5)));
        Composite ignoreButtons = new Composite(top, 0);
        GridLayout ignoreButtonsLayout = new GridLayout();
        ignoreButtonsLayout.marginHeight = 0;
        ignoreButtonsLayout.marginWidth = 0;
        ignoreButtons.setLayout((Layout)ignoreButtonsLayout);
        ignoreButtons.setLayoutData((Object)new GridData(1, 1, false, false));
        Button newButton = new Button(ignoreButtons, 8);
        newButton.setText(Messages.getString("MemcheckToolPage.New"));
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.handleIgnoreNewButtonPressed();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
        Button removeButton = new Button(ignoreButtons, 8);
        removeButton.setText(Messages.getString("MemcheckToolPage.Remove"));
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemcheckToolPage.this.handleIgnoreRemoveButtonPressed();
                MemcheckToolPage.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void handleIgnoreNewButtonPressed() {
        String function;
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("MemcheckToolPage.Ignore_Ranges"), Messages.getString("MemcheckToolPage.Range"), "", null);
        if (dialog.open() == 0 && !(function = dialog.getValue()).equals("")) {
            this.ignoreRangesList.add(function);
        }
    }

    private void handleIgnoreRemoveButtonPressed() {
        int[] selections = this.ignoreRangesList.getSelectionIndices();
        this.ignoreRangesList.remove(selections);
    }

    private void checkAlignmentEnablement() {
        this.alignmentSpinner.setEnabled(this.alignmentButton.getSelection());
    }

    private void checkMallocFillEnablement() {
        this.mallocFillText.setEnabled(this.mallocFillButton.getSelection());
    }

    private void checkFreeFillEnablement() {
        this.freeFillText.setEnabled(this.freeFillButton.getSelection());
    }

    public String getName() {
        return Messages.getString("MemcheckToolPage.Memcheck_Options");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            this.leakCheckButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", true));
            this.leakResCombo.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "high"));
            this.showReachableButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false));
            this.freelistSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000));
            this.partialLoadsButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false));
            this.undefValueButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true));
            this.gccWorkaroundButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false));
            this.alignmentButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", false));
            this.checkAlignmentEnablement();
            this.alignmentSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0));
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_4_0) >= 0) {
                this.trackOriginsButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false));
            }
            if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
                this.showPossiblyLostButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_POSSIBLY_LOST", false));
            }
            this.mallocFillButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_BOOL", false));
            this.checkMallocFillEnablement();
            this.mallocFillText.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_VAL", ""));
            this.freeFillButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_BOOL", false));
            this.checkFreeFillEnablement();
            this.freeFillText.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_VAL", ""));
            List ignoreFns = configuration.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_IGNORE_RANGES", MemcheckLaunchConstants.DEFAULT_MEMCHECK_IGNORE_RANGES);
            this.ignoreRangesList.setItems(ignoreFns.toArray(new String[ignoreFns.size()]));
        }
        catch (CoreException e) {
            this.ex = e;
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", this.leakCheckButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", this.leakResCombo.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", this.showReachableButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", this.freelistSpinner.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", this.partialLoadsButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", this.undefValueButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", this.gccWorkaroundButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", this.alignmentButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", this.alignmentSpinner.getSelection());
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", this.trackOriginsButton.getSelection());
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_POSSIBLY_LOST", this.showPossiblyLostButton.getSelection());
        }
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_BOOL", this.mallocFillButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_MALLOCFILL_VAL", this.mallocFillText.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_BOOL", this.freeFillButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREEFILL_VAL", this.freeFillText.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_IGNORE_RANGES", Arrays.asList(this.ignoreRangesList.getItems()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = false;
        try {
            boolean trackOrigins;
            int alignment = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0);
            boolean bl = result = (alignment & alignment - 1) == 0;
            if (!result) {
                this.setErrorMessage(Messages.getString("MemcheckToolPage.Alignment_must_be_power_2"));
            } else if ((this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_4_0) >= 0) && (trackOrigins = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false)) && !(result = launchConfig.getAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true))) {
                this.setErrorMessage(NLS.bind((String)Messages.getString("MemcheckToolPage.Track_origins_needs_undef"), (Object)Messages.getString("MemcheckToolPage.Track_origins"), (Object)Messages.getString("MemcheckToolPage.undef_value_errors")));
            }
        }
        catch (CoreException e) {
            this.ex = e;
        }
        if (this.ex != null) {
            this.setErrorMessage(this.ex.getLocalizedMessage());
        }
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.memcheck");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKCHECK", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_LEAKRES", "high");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_SHOWREACH", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_FREELIST", 10000000);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_PARTIAL", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_UNDEF", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_GCCWORK", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_BOOL", false);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_ALIGNMENT_VAL", 0);
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_4_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_TRACKORIGINS", false);
        }
        if (this.valgrindVersion == null || this.valgrindVersion.compareTo(VER_3_6_0) >= 0) {
            configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_POSSIBLY_LOST", false);
        }
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.memcheck.MEMCHECK_IGNORE_RANGES", MemcheckLaunchConstants.DEFAULT_MEMCHECK_IGNORE_RANGES);
    }

    public void setValgrindVersion(Version ver) {
        this.valgrindVersion = ver;
    }

    public void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public Button getLeakCheckButton() {
        return this.leakCheckButton;
    }

    public Combo getLeakResCombo() {
        return this.leakResCombo;
    }

    public Button getShowReachableButton() {
        return this.showReachableButton;
    }

    public Spinner getFreelistSpinner() {
        return this.freelistSpinner;
    }

    public Button getPartialLoadsButton() {
        return this.partialLoadsButton;
    }

    public Button getUndefValueButton() {
        return this.undefValueButton;
    }

    public Button getGccWorkaroundButton() {
        return this.gccWorkaroundButton;
    }

    public Button getAlignmentButton() {
        return this.alignmentButton;
    }

    public Spinner getAlignmentSpinner() {
        return this.alignmentSpinner;
    }

    public Button getTrackOriginsButton() {
        return this.trackOriginsButton;
    }
}

