/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.refactoring.ChangeParametersControl;
import org.eclipse.cdt.internal.ui.refactoring.IParameterListChangeListener;
import org.eclipse.cdt.internal.ui.refactoring.NameInformation;
import org.eclipse.cdt.internal.ui.refactoring.StubTypeContext;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.cdt.internal.ui.util.RowLayouter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.CSourceViewerConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExtractFunctionInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "ExtractFunctionInputPage";
    static final String DIALOG_SETTING_SECTION = "ExtractFunctionWizard";
    private ExtractFunctionRefactoring refactoring;
    private ExtractFunctionInformation info;
    private Text textField;
    private boolean firstTime;
    private CSourceViewer signaturePreview;
    private final Document signaturePreviewDocument;
    private IDialogSettings settings;
    private static final String DESCRIPTION = Messages.ExtractFunctionInputPage_description;
    private static final String ACCESS_MODIFIER = "AccessModifier";

    public ExtractFunctionInputPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_REFACTOR_TU);
        this.setDescription(DESCRIPTION);
        this.firstTime = true;
        this.signaturePreviewDocument = new Document();
    }

    public void createControl(Composite parent) {
        this.refactoring = (ExtractFunctionRefactoring)this.getRefactoring();
        this.info = ((ExtractFunctionRefactoring)this.getRefactoring()).getRefactoringInfo();
        this.loadSettings();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        GridData gd = null;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(this.getLabelText());
        this.textField = this.createTextInputField(result, 2048);
        this.textField.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label, (Control)this.textField, 1);
        label = new Label(result, 0);
        label.setText(Messages.ExtractFunctionInputPage_access_modifier);
        Composite group = new Composite(result, 0);
        group.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 0;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{Messages.ExtractFunctionInputPage_public, Messages.ExtractFunctionInputPage_protected, Messages.ExtractFunctionInputPage_private};
        VisibilityEnum[] visibilityValues = new VisibilityEnum[]{VisibilityEnum.v_public, VisibilityEnum.v_protected, VisibilityEnum.v_private};
        VisibilityEnum visibility = this.info.getVisibility();
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button(group, 16);
            radio.setText(labels[i]);
            radio.setData((Object)visibilityValues[i]);
            if (visibilityValues[i].equals((Object)visibility)) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    VisibilityEnum selectedModifier = (VisibilityEnum)((Object)event.widget.getData());
                    ExtractFunctionInputPage.this.settings.put(ExtractFunctionInputPage.ACCESS_MODIFIER, selectedModifier.toString());
                    ExtractFunctionInputPage.this.setVisibility(selectedModifier);
                }
            });
            ++i;
        }
        layouter.perform((Control)label, (Control)group, 1);
        if (!this.info.getParameters().isEmpty()) {
            ChangeParametersControl.Mode mode = this.info.getMandatoryReturnVariable() != null ? ChangeParametersControl.Mode.EXTRACT_METHOD_FIXED_RETURN : ChangeParametersControl.Mode.EXTRACT_METHOD;
            ChangeParametersControl paramControl = new ChangeParametersControl(result, 0, Messages.ExtractFunctionInputPage_parameters, new IParameterListChangeListener(){

                @Override
                public void parameterChanged(NameInformation parameter) {
                    ExtractFunctionInputPage.this.parameterModified();
                }

                @Override
                public void parameterListChanged() {
                    ExtractFunctionInputPage.this.parameterModified();
                }

                @Override
                public void parameterAdded(NameInformation parameter) {
                    ExtractFunctionInputPage.this.updatePreview(ExtractFunctionInputPage.this.getText());
                }
            }, mode, new StubTypeContext(this.refactoring.getTranslationUnit()));
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            paramControl.setLayoutData(gd);
            paramControl.setInput(this.info.getParameters());
        }
        int duplicates = this.refactoring.getNumberOfDuplicates();
        Button checkBox = new Button(result, 32);
        if (duplicates == 0) {
            checkBox.setText(Messages.ExtractFunctionInputPage_duplicates_none);
        } else if (duplicates == 1) {
            checkBox.setText(Messages.ExtractFunctionInputPage_duplicates_single);
        } else {
            checkBox.setText(NLS.bind((String)Messages.ExtractFunctionInputPage_duplicates_multi, (Object)duplicates));
        }
        checkBox.setSelection(this.info.isReplaceDuplicates());
        checkBox.setEnabled(duplicates > 0);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtractFunctionInputPage.this.info.setReplaceDuplicates(((Button)e.widget).getSelection());
            }
        });
        layouter.perform((Control)checkBox);
        label = new Label(result, 258);
        label.setLayoutData((Object)new GridData(768));
        layouter.perform((Control)label);
        this.createSignaturePreview(result, layouter);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.extract_function_wizard_page_context");
    }

    private Text createTextInputField(Composite parent, int style) {
        Text result = new Text(parent, style);
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExtractFunctionInputPage.this.textModified(ExtractFunctionInputPage.this.getText());
            }
        });
        TextFieldNavigationHandler.install(result);
        return result;
    }

    private String getText() {
        if (this.textField == null) {
            return null;
        }
        return this.textField.getText();
    }

    private String getLabelText() {
        return Messages.ExtractFunctionInputPage_label_text;
    }

    private void setVisibility(VisibilityEnum visibility) {
        this.info.setVisibility(visibility);
        this.updatePreview(this.getText());
    }

    private void createSignaturePreview(Composite composite, RowLayouter layouter) {
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(Messages.ExtractFunctionInputPage_signature_preview);
        layouter.perform((Control)previewLabel);
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        this.signaturePreview = new CSourceViewer(composite, null, null, false, 584, store);
        this.signaturePreview.configure((SourceViewerConfiguration)new CSourceViewerConfiguration(CUIPlugin.getDefault().getTextTools().getColorManager(), store, null, null));
        this.signaturePreview.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont"));
        this.signaturePreview.adaptBackgroundColor((Control)composite);
        this.signaturePreview.setDocument((IDocument)this.signaturePreviewDocument);
        this.signaturePreview.setEditable(false);
        Control signaturePreviewControl = this.signaturePreview.getControl();
        PixelConverter pixelConverter = new PixelConverter(signaturePreviewControl);
        GridData gdata = new GridData(1808);
        gdata.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        gdata.heightHint = pixelConverter.convertHeightInCharsToPixels(3);
        signaturePreviewControl.setLayoutData((Object)gdata);
        layouter.perform(signaturePreviewControl);
    }

    private void updatePreview(String methodName) {
        if (this.signaturePreview == null) {
            return;
        }
        if (methodName.isEmpty()) {
            methodName = StubUtility.suggestMethodName("extracted", null, this.refactoring.getTranslationUnit());
        }
        int top = this.signaturePreview.getTextWidget().getTopPixel();
        String signature = this.refactoring.getSignature(methodName);
        this.signaturePreviewDocument.set(signature);
        this.signaturePreview.getTextWidget().setTopPixel(top);
    }

    private void loadSettings() {
        String accessModifier;
        this.settings = this.getDialogSettings().getSection(DIALOG_SETTING_SECTION);
        if (this.settings == null) {
            this.settings = this.getDialogSettings().addNewSection(DIALOG_SETTING_SECTION);
            this.settings.put(ACCESS_MODIFIER, VisibilityEnum.v_private.toString());
        }
        if ((accessModifier = this.settings.get(ACCESS_MODIFIER)) != null) {
            this.info.setVisibility(VisibilityEnum.getEnumForStringRepresentation(accessModifier));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.firstTime) {
                this.firstTime = false;
                this.setPageComplete(false);
                this.updatePreview(this.getText());
                this.textField.setFocus();
            } else {
                this.setPageComplete(this.validatePage(true));
            }
        }
        super.setVisible(visible);
    }

    private void textModified(String methodName) {
        this.info.setMethodName(methodName);
        RefactoringStatus status = this.validatePage(true);
        if (!status.hasFatalError()) {
            this.updatePreview(methodName);
        } else {
            this.signaturePreviewDocument.set("");
        }
        this.setPageComplete(status);
    }

    private void parameterModified() {
        this.updatePreview(this.getText());
        this.setPageComplete(this.validatePage(false));
    }

    private RefactoringStatus validatePage(boolean text) {
        RefactoringStatus result = new RefactoringStatus();
        if (text) {
            result.merge(this.validateMethodName());
            result.merge(this.validateParameters());
        } else {
            result.merge(this.validateParameters());
            result.merge(this.validateMethodName());
        }
        return result;
    }

    private RefactoringStatus validateMethodName() {
        RefactoringStatus result = new RefactoringStatus();
        String methodName = this.getText();
        if (methodName.isEmpty()) {
            result.addFatalError(Messages.ExtractFunctionInputPage_validation_empty_function_name);
            return result;
        }
        result.merge(this.refactoring.checkMethodName());
        return result;
    }

    private RefactoringStatus validateParameters() {
        RefactoringStatus result = new RefactoringStatus();
        for (NameInformation paramInfo : this.info.getParameters()) {
            if (!paramInfo.getNewName().isEmpty()) continue;
            result.addFatalError(Messages.ExtractFunctionInputPage_validation_empty_parameter_name);
            return result;
        }
        result.merge(this.refactoring.checkParameterNames());
        return result;
    }
}

