/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties.tabbed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.views.properties.tabbed.TabbedPropertyViewPlugin;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;

public abstract class AbstractTabDescriptor
implements ITabDescriptor,
Cloneable {
    private List sectionDescriptors = new ArrayList(5);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            Status status = new Status(4, TabbedPropertyViewPlugin.getPlugin().getBundle().getSymbolicName(), 666, exception.getMessage(), (Throwable)exception);
            TabbedPropertyViewPlugin.getPlugin().getLog().log((IStatus)status);
            return null;
        }
    }

    @Override
    public TabContents createTab() {
        ArrayList<ISection> sections = new ArrayList<ISection>(this.getSectionDescriptors().size());
        for (ISectionDescriptor descriptor : this.getSectionDescriptors()) {
            ISection section = descriptor.getSectionClass();
            sections.add(section);
        }
        TabContents tab = new TabContents();
        tab.setSections(sections.toArray(new ISection[sections.size()]));
        return tab;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() == object.getClass()) {
            AbstractTabDescriptor descriptor = (AbstractTabDescriptor)object;
            if (this.getCategory().equals(descriptor.getCategory()) && this.getId().equals(descriptor.getId()) && this.getSectionDescriptors().size() == descriptor.getSectionDescriptors().size()) {
                Iterator i = this.getSectionDescriptors().iterator();
                Iterator j = descriptor.getSectionDescriptors().iterator();
                while (i.hasNext()) {
                    ISectionDescriptor source = (ISectionDescriptor)i.next();
                    ISectionDescriptor target = (ISectionDescriptor)j.next();
                    if (source.getId().equals(target.getId())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAfterTab() {
        return "top";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public List getSectionDescriptors() {
        return this.sectionDescriptors;
    }

    @Override
    public String getText() {
        return this.getLabel();
    }

    public int hashCode() {
        int hashCode = this.getCategory().hashCode();
        hashCode ^= this.getId().hashCode();
        for (ISectionDescriptor section : this.getSectionDescriptors()) {
            hashCode ^= section.getId().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean isIndented() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    public void setSectionDescriptors(List sectionDescriptors) {
        this.sectionDescriptors = sectionDescriptors;
    }
}

