/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.IRemoteScriptExecution;
import org.eclipse.ptp.remotetools.core.RemoteProcess;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProcess;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProgressListener;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.remotetools.environment.launcher.core.NullLaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionResult;
import org.eclipse.ptp.remotetools.environment.launcher.data.ISynchronizationRule;
import org.eclipse.ptp.remotetools.environment.launcher.internal.ILaunchProcessCallback;
import org.eclipse.ptp.remotetools.environment.launcher.internal.IRuleAction;
import org.eclipse.ptp.remotetools.environment.launcher.internal.Messages;
import org.eclipse.ptp.remotetools.environment.launcher.internal.RuleActionFactory;
import org.eclipse.ptp.remotetools.environment.launcher.internal.integration.NullLaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.internal.process.TargetProcess;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;

public class RemoteLaunchProcess
implements ILaunchProcess,
ILaunchProcessCallback {
    int currentProgress = 0;
    public ILaunchObserver observer = new NullLaunchObserver();
    public ILaunchIntegration launchIntegration = new NullLaunchIntegration();
    public ListenerList progressListeners = new ListenerList();
    OutputStream launchProcessOutputStream = null;
    OutputStream launchProcessErrorStream = null;
    PrintWriter launchProcessOutputWriter = null;
    PrintWriter launchProcessErrorWriter = null;
    ExecutionConfiguration configuration = null;
    ExecutionResult executionResult = null;
    List<ISynchronizationRule> extraSynchronizationRules = new ArrayList<ISynchronizationRule>();
    IProcess applicationProgress;
    TargetProcess targetProcess;
    ILaunch launch;
    IRemoteExecutionManager manager;
    String[] launchScript;

    public RemoteLaunchProcess(ILaunch launch, ExecutionConfiguration configuration, ILaunchIntegration launchIntegration) {
        this.launch = launch;
        this.configuration = configuration;
        this.currentProgress = 1;
        this.executionResult = null;
        this.launchIntegration = launchIntegration == null ? new NullLaunchIntegration() : launchIntegration;
    }

    public synchronized void markAsCanceled() {
        this.launchProcessErrorWriter.println(Messages.RemoteLaunchProcess_RequestToCancelLaunch);
        this.manager.cancel();
    }

    public synchronized ILaunchObserver getObserver() {
        return this.observer;
    }

    public synchronized ILaunchIntegration getLaunchIntegration() {
        return this.launchIntegration;
    }

    protected synchronized void setCurrentProgress(int newProgress) {
        this.currentProgress = newProgress;
        Object[] objectArray = this.progressListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILaunchProgressListener)listener).notifyProgress(newProgress);
            ++n2;
        }
    }

    protected synchronized void notifyInterrupt() {
        Object[] objectArray = this.progressListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILaunchProgressListener)listener).notifyInterrupt();
            ++n2;
        }
    }

    public synchronized int getCurrentProgress() {
        return this.currentProgress;
    }

    public synchronized ExecutionResult getFinalResult() {
        return this.executionResult;
    }

    public synchronized ExecutionConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void prepareWorkingDir() throws CoreException, CancelException {
        IRemoteFileTools fileTools;
        boolean doCreate = false;
        if (this.configuration.getDoSynchronizeAfter() || this.configuration.getDoSynchronizeBefore() || this.configuration.getDoCleanup() || this.launchIntegration.getDoLaunchApplication()) {
            doCreate = true;
        }
        if (!doCreate) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_PrepareWorkingDir_NotRequired);
            return;
        }
        IPath remotePath = this.configuration.getRemoteDirectoryPath();
        String remoteDirectoryAsPath = LinuxPath.toString(remotePath);
        this.launchProcessOutputWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_PrepareWorkingDir_Title, (Object)remoteDirectoryAsPath));
        try {
            fileTools = this.manager.getRemoteFileTools();
            fileTools.createDirectory(remoteDirectoryAsPath);
        }
        catch (RemoteOperationException e) {
            this.launchProcessErrorWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_PrepareWorkingDir_FailedCreate, (Object)e.getMessage()));
            this.launchProcessErrorWriter.println(Messages.RemoteLaunchProcess_PrepareWorkingDir_FailedCreateHint);
            this.abortWithError(Messages.RemoteLaunchProcess_PrepareWorkingDir_Failed, (Exception)((Object)e));
        }
        catch (RemoteConnectionException e) {
            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
        }
        try {
            fileTools = this.manager.getRemoteFileTools();
            IRemoteItem remoteExecutable = fileTools.getDirectory(remoteDirectoryAsPath);
            remoteExecutable.setExecutable(true);
            remoteExecutable.setReadable(true);
            remoteExecutable.setWriteable(true);
            remoteExecutable.commitAttributes();
        }
        catch (RemoteOperationException e) {
            this.launchProcessErrorWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_PrepareWorkingDir_FailedPermissions, (Object)e.getMessage()));
            this.abortWithError(Messages.RemoteLaunchProcess_PrepareWorkingDir_Failed, (Exception)((Object)e));
        }
        catch (RemoteConnectionException e) {
            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
        }
    }

    protected void uploadWorkingDirectory() throws CoreException, CancelException {
        if (!this.configuration.getDoSynchronizeBefore()) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadWorkingDirectory_TitleUploadDisabled);
            return;
        }
        this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadWorkingDirectory_Title);
        if (this.configuration.countUploadRules() <= 0) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadWorkingDirectory_NoRules);
            return;
        }
        ISynchronizationRule[] rules = this.configuration.getSynchronizationRulesArray();
        RuleActionFactory factory = new RuleActionFactory(this);
        int i = 0;
        while (i < rules.length) {
            block11: {
                ISynchronizationRule rule = rules[i];
                if (rule.isUploadRule()) {
                    if (!rule.isActive()) {
                        String message = NLS.bind((String)Messages.RemoteLaunchProcess_UploadWorkingDirectory_IgnoreInactive, (Object)Integer.toString(i));
                        this.launchProcessOutputWriter.println(message);
                    } else {
                        try {
                            rule.validate();
                        }
                        catch (CoreException e) {
                            String message = NLS.bind((String)Messages.RemoteLaunchProcess_UploadWorkingDirectory_IgnoreInvalid, (Object[])new Object[]{Integer.toString(i), e.getMessage()});
                            this.launchProcessErrorWriter.println(message);
                            break block11;
                        }
                        IRuleAction action = factory.getAction(rule);
                        try {
                            action.run();
                        }
                        catch (CoreException e) {
                            String message = NLS.bind((String)Messages.RemoteLaunchProcess_UploadWorkingDirectory_FailedRule, (Object[])new Object[]{Integer.toString(i), e.getMessage()});
                            this.launchProcessOutputWriter.println(message);
                        }
                        catch (RemoteConnectionException e) {
                            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void uploadApplication() throws CoreException, CancelException {
        if (!this.launchIntegration.getDoLaunchApplication()) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadApplication_TitleNoUpload);
            return;
        }
        this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadApplication_Title);
        IPath remoteDirectoryPath = this.configuration.getRemoteDirectoryPath();
        IPath remoteExecutablePath = this.configuration.getRemoteExecutablePath();
        String remoteDirectory = LinuxPath.toString(remoteDirectoryPath);
        String remoteExecutable = LinuxPath.toString(remoteExecutablePath);
        File executableFile = this.configuration.getExecutableFile();
        try {
            this.launchProcessOutputWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_UploadApplication_UploadMessage, (Object[])new Object[]{executableFile.getCanonicalPath(), remoteExecutable}));
        }
        catch (IOException iOException) {}
        try {
            this.manager.getRemoteCopyTools().uploadFileToDir(executableFile, remoteDirectory);
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadApplication_CompletedUpload);
        }
        catch (RemoteOperationException e) {
            this.launchProcessErrorWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_UploadApplication_FailedUpload, (Object)e.getMessage()));
            this.abortWithError(Messages.RemoteLaunchProcess_Failed, (Exception)((Object)e));
        }
        catch (RemoteConnectionException e) {
            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
        }
        try {
            IRemoteFileTools fileTools = this.manager.getRemoteFileTools();
            IRemoteItem remoteFile = fileTools.getFile(remoteExecutable);
            remoteFile.setReadable(true);
            remoteFile.setExecutable(true);
            remoteFile.commitAttributes();
        }
        catch (RemoteOperationException e) {
            this.launchProcessErrorWriter.println(NLS.bind((String)Messages.RemoteLaunchProcess_FailedPermissions, (Object)e.getMessage()));
            this.abortWithError(Messages.RemoteLaunchProcess_Failed, (Exception)((Object)e));
        }
        catch (RemoteConnectionException e) {
            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
        }
    }

    protected void downloadWorkingDirectory() throws CoreException, CancelException {
        if (!this.configuration.getDoSynchronizeAfter() && this.extraSynchronizationRules.size() == 0) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_DownloadWorkingDirectory_TitleDownloadDisabled);
            return;
        }
        this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_DownloadWorkingDirectory_Title);
        if (this.configuration.countDownloadRules() <= 0 && this.extraSynchronizationRules.size() == 0) {
            this.launchProcessOutputWriter.println(Messages.RemoteLaunchProcess_UploadWorkingDirectory_NoRules);
            return;
        }
        ArrayList<ISynchronizationRule> rules_tmp = new ArrayList<ISynchronizationRule>(Arrays.asList(this.configuration.getSynchronizationRulesArray()));
        rules_tmp.addAll(this.extraSynchronizationRules);
        ISynchronizationRule[] rules = rules_tmp.toArray(new ISynchronizationRule[rules_tmp.size()]);
        RuleActionFactory factory = new RuleActionFactory(this);
        int i = 0;
        while (i < rules.length) {
            block11: {
                ISynchronizationRule rule = rules[i];
                if (rule.isDownloadRule()) {
                    if (!rule.isActive()) {
                        String message = NLS.bind((String)Messages.RemoteLaunchProcess_UploadWorkingDirectory_IgnoreInactive, (Object)Integer.toString(i));
                        this.launchProcessOutputWriter.println(message);
                    } else {
                        try {
                            rule.validate();
                        }
                        catch (CoreException e) {
                            String message = NLS.bind((String)Messages.RemoteLaunchProcess_DownloadWorkingDirectory_IgnoreInvalid, (Object[])new Object[]{Integer.toString(i), e.getMessage()});
                            this.launchProcessErrorWriter.println(message);
                            break block11;
                        }
                        IRuleAction action = factory.getAction(rule);
                        try {
                            action.run();
                        }
                        catch (CoreException e) {
                            String message = NLS.bind((String)Messages.RemoteLaunchProcess_DownloadWorkingDirectory_FailedRule, (Object[])new Object[]{Integer.toString(i), e.getMessage()});
                            this.launchProcessOutputWriter.println(message);
                        }
                        catch (RemoteConnectionException e) {
                            this.abortWithError(Messages.RemoteLaunchProcess_All_FailedConnection, (Exception)((Object)e));
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void prepareApplication() throws CoreException, CancelException {
        if (!this.launchIntegration.getDoLaunchApplication()) {
            return;
        }
        try {
            String command = this.configuration.getBeforeCommand();
            if (command == null) {
                this.launchProcessOutputWriter.println("* Launch configuration does not require running a bash script before launch.");
                return;
            }
            if ((command = command.trim()).length() == 0) {
                this.launchProcessOutputWriter.println("* Launch configuration does not require running a bash script before launch.");
                return;
            }
            this.launchProcessOutputWriter.println("* Prepare launch by executing:");
            this.launchProcessOutputWriter.println("   " + command);
            IRemoteExecutionTools ret = this.manager.getExecutionTools();
            IRemoteScript script = ret.createScript();
            String[] environmentVariables = this.configuration.getEnvironmentVariablesArray();
            int i = 0;
            while (i < environmentVariables.length) {
                script.addEnvironment(environmentVariables[i]);
                ++i;
            }
            command = "cd " + this.configuration.getRemoteDirectoryPath() + "\n" + command + "\n";
            script.setScript(command.split("\n"));
            IRemoteScriptExecution execution = ret.executeScript(script);
            execution.waitForEndOfExecution();
            if (execution.getReturnCode() == 0) {
                this.launchProcessOutputWriter.println("   Script executed successfully.");
            } else {
                this.launchProcessErrorWriter.println("   Script returned " + Integer.toString(execution.getReturnCode()));
            }
            execution.close();
        }
        catch (RemoteExecutionException e) {
            this.launchProcessOutputWriter.println("   Script failed: " + e.getErrorMessage());
        }
        catch (RemoteConnectionException e) {
            this.abortWithError("Connection to host failed.", (Exception)((Object)e));
        }
    }

    protected void finalizeApplication() throws CoreException, CancelException {
        if (!this.launchIntegration.getDoLaunchApplication()) {
            return;
        }
        try {
            String command = this.configuration.getAfterCommand();
            if (command == null) {
                this.launchProcessOutputWriter.println("* Launch configuration does not require running a bash script after launch.");
                return;
            }
            if ((command = command.trim()).length() == 0) {
                this.launchProcessOutputWriter.println("* Launch configuration does not require running a bash script after launch.");
                return;
            }
            this.launchProcessOutputWriter.println("* Finalize launch by executing:");
            this.launchProcessOutputWriter.println("   " + command);
            IRemoteExecutionTools ret = this.manager.getExecutionTools();
            IRemoteScript script = ret.createScript();
            String[] environmentVariables = this.configuration.getEnvironmentVariablesArray();
            int i = 0;
            while (i < environmentVariables.length) {
                script.addEnvironment(environmentVariables[i]);
                ++i;
            }
            command = "cd " + this.configuration.getRemoteDirectoryPath() + "\n" + command + "\n";
            script.setScript(command.split("\n"));
            IRemoteScriptExecution execution = ret.executeScript(script);
            execution.waitForEndOfExecution();
            if (execution.getReturnCode() == 0) {
                this.launchProcessOutputWriter.println("   Script executed successfully.");
            } else {
                this.launchProcessErrorWriter.println("   Script returned " + Integer.toString(execution.getReturnCode()));
            }
            execution.close();
        }
        catch (RemoteExecutionException e) {
            this.launchProcessOutputWriter.println("   Script failed: " + e.getErrorMessage());
        }
        catch (RemoteConnectionException e) {
            this.abortWithError("Connection to host failed.", (Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     */
    protected void runApplication() throws CoreException, CancelException {
        if (!this.launchIntegration.getDoLaunchApplication()) {
            this.launchProcessOutputWriter.println("* Launch configuration does not require running the executable.");
            return;
        }
        IRemoteExecutionTools iret = null;
        IRemoteScript script = null;
        try {
            iret = this.manager.getExecutionTools();
            script = iret.createScript();
        }
        catch (RemoteConnectionException e) {
            this.abortWithError("Connection to host failed.", (Exception)((Object)e));
        }
        String[] environmentVariables = this.configuration.getEnvironmentVariablesArray();
        int i = 0;
        while (i < environmentVariables.length) {
            script.addEnvironment(environmentVariables[i]);
            ++i;
        }
        script.setForwardX11(this.configuration.getDoForwardX11());
        ArrayList<String> commandsList = new ArrayList<String>(Arrays.asList(this.launchScript));
        String remoteWorkingDirectory = LinuxPath.toString(this.configuration.getRemoteDirectoryPath());
        IRemotePathTools pathTools = this.manager.getRemotePathTools();
        commandsList.add(0, "cd " + pathTools.quote(remoteWorkingDirectory, true));
        if (this.configuration.getDoAllocateTerminal()) {
            commandsList.add(0, "stty -echo");
        }
        String[] commands = new String[commandsList.size()];
        commands = commandsList.toArray(commands);
        script.setScript(commands);
        script.setFetchProcessErrorStream(true);
        script.setFetchProcessInputStream(true);
        script.setFetchProcessOutputStream(true);
        script.setAllocateTerminal(this.configuration.getDoAllocateTerminal());
        RemoteProcess remoteProcess = null;
        this.executionResult = new ExecutionResult();
        try {
            try {
                this.launchProcessOutputWriter.println("* Started application on target.");
                this.launchIntegration.prepareLaunch();
                remoteProcess = this.manager.getExecutionTools().executeProcess(script);
                this.applicationProgress = DebugPlugin.newProcess((ILaunch)this.launch, (Process)remoteProcess, (String)"Remote process");
                IStreamsProxy proxy = this.applicationProgress.getStreamsProxy();
                if (proxy != null) {
                    IStreamListener listener = new IStreamListener(){

                        public void streamAppended(String text, IStreamMonitor monitor) {
                            RemoteLaunchProcess.this.observer.receiveOutput(text);
                        }
                    };
                    this.applicationProgress.getStreamsProxy().getOutputStreamMonitor().addListener(listener);
                }
                this.launchIntegration.finalizeLaunch();
                this.showProcessConsole();
                remoteProcess.waitFor();
                IRemoteScriptExecution execution = remoteProcess.getRemoteExecution();
                this.executionResult = new ExecutionResult();
                this.executionResult.setExitValue(execution.getReturnCode());
                if (execution.wasCanceled()) {
                    this.launchProcessErrorWriter.println("   Execution was canceled");
                    this.executionResult.setStatus(3);
                } else if (execution.wasOK()) {
                    if (execution.getReturnCode() > 0) {
                        this.launchProcessOutputWriter.println("   Finished with exit code: " + Integer.toString(this.executionResult.getExitValue()));
                        this.executionResult.setStatus(2);
                    } else {
                        this.launchProcessOutputWriter.println("   Finished successfully");
                        this.executionResult.setStatus(1);
                    }
                } else if (execution.wasException()) {
                    this.launchProcessErrorWriter.println("   Finished with exception: " + execution.getFinishStatusText(execution.getFinishStatus()));
                    this.executionResult.setStatus(4);
                } else if (execution.wasCommandError()) {
                    this.launchProcessErrorWriter.println("   Could not run application: " + execution.getFinishStatusText(execution.getFinishStatus()));
                    this.executionResult.setStatus(5);
                } else {
                    this.launchProcessErrorWriter.println("   Failed.");
                    this.executionResult.setStatus(6);
                }
            }
            catch (CoreException e) {
                this.launchProcessErrorWriter.println("   Failed: " + e.getMessage());
                IStatus status = e.getStatus();
                if (status.isMultiStatus()) {
                    this.launchProcessErrorWriter.println("     " + status.getException().getMessage());
                }
                this.executionResult.setStatus(7);
                throw e;
            }
            catch (RemoteConnectionException e) {
                this.executionResult.setStatus(7);
                this.abortWithError("Connection to host failed.", (Exception)((Object)e));
                remoteProcess.destroy();
            }
            catch (RemoteExecutionException e) {
                this.executionResult.setStatus(7);
                this.launchProcessErrorWriter.println("   Failed to execute: " + e.getErrorMessage());
                remoteProcess.destroy();
            }
            catch (InterruptedException interruptedException) {
                this.executionResult.setStatus(7);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                remoteProcess.destroy();
            }
        }
        finally {
            remoteProcess.destroy();
        }
    }

    protected void cleanUp() throws CoreException, CancelException {
        if (!this.configuration.getDoCleanup()) {
            this.launchProcessOutputWriter.println("* Launch configuration does not require cleaning up remote working directory.");
            return;
        }
        IPath remotePath = this.configuration.getRemoteDirectoryPath();
        String remoteDirectory = LinuxPath.toString(remotePath);
        try {
            this.launchProcessOutputWriter.println("* Cleaning up remote working directory: " + remoteDirectory);
            IRemoteFileTools irft = this.manager.getRemoteFileTools();
            irft.removeFile(remoteDirectory);
            this.launchProcessOutputWriter.println("   Clean up complete");
        }
        catch (RemoteOperationException e) {
            this.launchProcessErrorWriter.println("   Clean up failed: " + e.getMessage());
            this.abortWithError("Could not clean up target.", (Exception)((Object)e));
        }
        catch (RemoteConnectionException e) {
            this.abortWithError("Connection to host failed.", (Exception)((Object)e));
        }
    }

    public static String createCommandLine(String remoteExecutableName, String[] argumentsArray) {
        ArgumentParser parser = new ArgumentParser(remoteExecutableName, argumentsArray);
        return parser.getCommandLine(true);
    }

    public void run(IRemoteExecutionManager manager) {
        this.manager = manager;
        this.setCurrentProgress(1);
        this.targetProcess = new TargetProcess(this.launch, this);
        this.addProgressListener(this.targetProcess);
        this.launchProcessOutputWriter = new PrintWriter(this.targetProcess.getOutputStream(), true);
        this.launchProcessErrorWriter = new PrintWriter(this.targetProcess.getErrorStream(), true);
        this.targetProcess.start();
        this.observer.setExecutionManager(manager);
        this.launchIntegration.setExecutionManager(manager);
        try {
            try {
                this.observer.start();
                this.launchIntegration.start();
                String remexecpath = LinuxPath.toString(this.configuration.getRemoteExecutablePath());
                this.launchScript = this.launchIntegration.createLaunchScript(remexecpath, this.configuration.getArgumentsArray());
                this.setCurrentProgress(2);
                this.prepareWorkingDir();
                this.launchIntegration.prepareUploadWorkingDir();
                this.setCurrentProgress(3);
                this.uploadWorkingDirectory();
                this.setCurrentProgress(4);
                this.launchIntegration.finalizeWorkingDir();
                this.setCurrentProgress(5);
                this.uploadApplication();
                this.setCurrentProgress(6);
                this.prepareApplication();
                this.launchIntegration.prepareApplication();
                this.observer.prepareApplication();
                this.setCurrentProgress(7);
                this.runApplication();
                this.setCurrentProgress(8);
                this.observer.finalizeApplication();
                this.launchIntegration.finalizeApplication();
                this.finalizeApplication();
                this.setCurrentProgress(9);
                this.downloadWorkingDirectory();
                this.setCurrentProgress(10);
                this.launchIntegration.finalizeWorkingDir();
                this.setCurrentProgress(11);
                this.cleanUp();
                this.setCurrentProgress(12);
                this.launchIntegration.finalizeCleanup();
                this.setCurrentProgress(13);
                this.observer.finish();
                this.launchIntegration.finish();
                if (this.executionResult.getStatus() == 1) {
                    this.showProcessConsole();
                } else {
                    this.showLaunchConsole();
                }
            }
            catch (CancelException cancelException) {
                if (this.executionResult == null) {
                    this.executionResult = new ExecutionResult();
                    this.executionResult.setStatus(3);
                }
                this.forcedCleanUp(manager);
                this.setCurrentProgress(13);
                this.observer.cleanup();
                this.launchIntegration.cleanup();
            }
            catch (CoreException e) {
                if (this.executionResult == null) {
                    this.executionResult = new ExecutionResult();
                    this.executionResult.setStatus(7);
                }
                this.forcedCleanUp(manager);
                this.launchProcessErrorWriter.println();
                this.launchProcessErrorWriter.println("*** The launch did not work correctly ***");
                this.launchProcessErrorWriter.println("    An exception was thrown during the launch: " + e.getMessage());
                this.launchProcessErrorWriter.println();
                this.notifyInterrupt();
                this.setCurrentProgress(13);
                this.observer.cleanup();
                this.launchIntegration.cleanup();
            }
        }
        finally {
            this.setCurrentProgress(13);
            this.observer.cleanup();
            this.launchIntegration.cleanup();
        }
    }

    private void forcedCleanUp(IRemoteExecutionManager manager) {
        if (this.getCurrentProgress() > 6) {
            this.setCurrentProgress(8);
            try {
                this.launchIntegration.finalizeApplication();
            }
            catch (CancelException cancelException) {
            }
            catch (CoreException coreException) {}
        }
        this.setCurrentProgress(10);
        try {
            this.launchIntegration.finalizeCleanup();
        }
        catch (CoreException coreException) {
        }
        catch (CancelException cancelException) {}
        this.setCurrentProgress(11);
        try {
            this.cleanUp();
        }
        catch (CancelException cancelException) {
        }
        catch (CoreException coreException) {}
        this.setCurrentProgress(12);
        try {
            this.launchIntegration.finalizeCleanup();
        }
        catch (CoreException coreException) {
        }
        catch (CancelException cancelException) {}
    }

    protected void abortWithError(String message, Exception e) throws CoreException {
        Status status = new Status(4, RemoteLauncherPlugin.getUniqueIdentifier(), 0, message, (Throwable)e);
        throw new CoreException((IStatus)status);
    }

    public synchronized void addProgressListener(ILaunchProgressListener progressListener) {
        this.progressListeners.add((Object)progressListener);
    }

    public synchronized void removeProgressListener(ILaunchProgressListener progressListener) {
        this.progressListeners.remove((Object)progressListener);
    }

    public void setLaunchObserver(ILaunchObserver launchObserver) {
        this.observer = launchObserver == null ? new NullLaunchObserver() : launchObserver;
    }

    public IRemoteExecutionManager getExecutionManager() {
        return this.manager;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launch.getLaunchConfiguration();
    }

    public void showProcessConsole() {
        if (this.applicationProgress == null) {
            return;
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole processConsole;
            IProcess process;
            org.eclipse.ui.console.IConsole console = consoles[i];
            if (console instanceof IConsole && (process = (processConsole = (IConsole)console).getProcess()) == this.applicationProgress) {
                consoleManager.showConsoleView(console);
            }
            ++i;
        }
    }

    public void showLaunchConsole() {
        if (this.applicationProgress == null) {
            return;
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = consoleManager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole processConsole;
            IProcess process;
            org.eclipse.ui.console.IConsole console = consoles[i];
            if (console instanceof IConsole && (process = (processConsole = (IConsole)console).getProcess()) == this.targetProcess) {
                consoleManager.showConsoleView(console);
            }
            ++i;
        }
    }

    public PrintWriter getErrorWriter() {
        return this.launchProcessErrorWriter;
    }

    public PrintWriter getOutputWriter() {
        return this.launchProcessOutputWriter;
    }

    public void addSynchronizationRule(ISynchronizationRule rule) {
        this.extraSynchronizationRules.add(rule);
    }
}

