/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core.pdi;

import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIAddressBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIExceptionpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDIFunctionBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDILineBreakpoint;
import org.eclipse.ptp.debug.core.pdi.model.IPDISignal;
import org.eclipse.ptp.debug.core.pdi.model.IPDIWatchpoint;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEvent;
import org.eclipse.ptp.proxy.event.IProxyExtendedEvent;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDIDebugger
extends ProxyDebugClient
implements IPDIDebugger {
    private int bpid = 0;
    private ProxyNotifier proxyNotifier = new ProxyNotifier();

    public void commandRequest(BitList tasks, String command) throws PDIException {
        try {
            this.debugCLIHandle(tasks, command);
        }
        catch (IOException e) {
            throw new PDIException(null, "Error on sending generic command: " + e.getMessage());
        }
    }

    public void createDataReadMemory(BitList tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) throws PDIException {
        try {
            this.setDataReadMemoryCommand(tasks, offset, address, this.getFormat(wordFormat), wordSize, rows, cols, asChar);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting data read memory: " + e.getMessage());
        }
    }

    public void createDataWriteMemory(BitList tasks, long offset, String address, int wordFormat, int wordSize, String value) throws PDIException {
        try {
            this.setDataWriteMemoryCommand(tasks, offset, address, this.getFormat(wordFormat), wordSize, value);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting data write memory: " + e.getMessage());
        }
    }

    public void deleteBreakpoint(BitList tasks, int bpid) throws PDIException {
        try {
            this.debugDeleteBreakpoint(tasks, bpid);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on deleting breakpoint: " + e.getMessage());
        }
    }

    public void deletePartialExpression(BitList tasks, String var) throws PDIException {
        try {
            this.debugDeletePartialExpression(tasks, var);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on deleting variable: " + e.getMessage());
        }
    }

    public void disconnect(Observer observer) throws PDIException {
        this.stopDebugger();
    }

    public void evaluateExpression(BitList tasks, String expr) throws PDIException {
        try {
            this.debugEvaluateExpression(tasks, expr);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on evaluating expression: " + e.getMessage());
        }
    }

    public void evaluatePartialExpression(BitList tasks, String expr, String exprId, boolean listChildren, boolean express) throws PDIException {
        try {
            this.debugEvaluatePartialExpression(tasks, expr, exprId, listChildren, express);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on getting partial aif: " + e.getMessage());
        }
    }

    public int getErrorAction(int errorCode) {
        switch (errorCode) {
            case 4: 
            case 5: 
            case 26: 
            case 33: {
                return 2;
            }
            case 12: 
            case 13: 
            case 38: {
                return 0;
            }
            case 39: {
                return 3;
            }
        }
        return 1;
    }

    public void handleEvent(IProxyExtendedEvent e) {
        if (e instanceof IProxyDebugEvent) {
            this.proxyNotifier.notify((IProxyDebugEvent)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(ILaunchConfiguration configuration, List<String> args, IProgressMonitor monitor) throws PDIException {
        int level;
        IRemoteResourceManagerConfiguration remConf;
        int port = 0;
        for (String arg : args) {
            if (!arg.startsWith("--port=")) continue;
            try {
                port = Integer.parseInt(arg.substring(7, arg.length()));
            }
            catch (NumberFormatException numberFormatException) {}
            break;
        }
        try {
            this.doInitialize(port);
        }
        catch (IOException e) {
            throw new PDIException(null, "Error on getting proxy port number: " + e.getMessage());
        }
        IResourceManagerControl rm = this.getResourceManager(configuration);
        if (rm == null) throw new PDIException(null, "Error getting resource manager");
        port = this.getSessionPort();
        IResourceManagerConfiguration conf = rm.getConfiguration();
        if (conf instanceof IRemoteResourceManagerConfiguration && (remConf = (IRemoteResourceManagerConfiguration)conf).testOption(2)) {
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(remConf.getRemoteServicesId());
            if (remoteServices == null) throw new PDIException(null, "Error getting remote services for connection");
            IRemoteConnectionManager connMgr = remoteServices.getConnectionManager();
            if (connMgr == null) throw new PDIException(null, "Error getting connection manager");
            IRemoteConnection conn = connMgr.getConnection(remConf.getConnectionName());
            if (conn == null) throw new PDIException(null, "Error getting connection");
            try {
                port = conn.forwardRemotePort("", this.getSessionPort(), monitor);
            }
            catch (RemoteConnectionException e) {
                throw new PDIException(null, e.getMessage());
            }
            if (monitor.isCanceled()) {
                return;
            }
        }
        args.add("--port=" + port);
        Preferences store = SDMDebugCorePlugin.getDefault().getPluginPreferences();
        if (!store.getBoolean(SDMPreferenceConstants.SDM_DEBUG_ENABLED) || ((level = store.getInt(SDMPreferenceConstants.SDM_DEBUG_LEVEL)) & 0x20) != 32) return;
        this.getDebugOptions().PROTOCOL_TRACING = true;
    }

    public boolean isConnected(IProgressMonitor monitor) throws PDIException {
        block3: {
            try {
                if (!this.waitConnect(monitor)) break block3;
                this.sessionHandleEvents();
                return true;
            }
            catch (IOException e) {
                this.disconnect(null);
                throw new PDIException(null, "Error on connecting proxy: " + e.getMessage());
            }
        }
        this.disconnect(null);
        return false;
    }

    public void listArguments(BitList tasks, int low, int high) throws PDIException {
        try {
            this.debugListArguments(tasks, low, high);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing arguments: " + e.getMessage());
        }
    }

    public void listGlobalVariables(BitList tasks) throws PDIException {
        try {
            this.debugListGlobalVariables(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing global variables: " + e.getMessage());
        }
    }

    public void listInfoThreads(BitList tasks) throws PDIException {
        try {
            this.debugListInfoThreads(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing thread info: " + e.getMessage());
        }
    }

    public void listLocalVariables(BitList tasks) throws PDIException {
        try {
            this.debugListLocalVariables(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing local variables: " + e.getMessage());
        }
    }

    public void listSignals(BitList tasks, String name) throws PDIException {
        try {
            this.debugListSignals(tasks, name);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing signal: " + e.getMessage());
        }
    }

    public void listStackFrames(BitList tasks, int low, int depth) throws PDIException {
        try {
            this.debugListStackframes(tasks, low, depth);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on listing stack frames: " + e.getMessage());
        }
    }

    public void register(Observer observer) {
        this.proxyNotifier.addObserver(observer);
    }

    public void restart(BitList tasks) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - restart() yet");
    }

    public void resume(BitList tasks, boolean passSignal) throws PDIException {
        try {
            this.debugGo(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on resuming tasks: " + e.getMessage());
        }
    }

    public void resume(BitList tasks, IPDILocation location) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - resume(IPDILocation) yet");
    }

    public void resume(BitList tasks, IPDISignal signal) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - resume(IPDISignal) yet");
    }

    public void retrieveSignalInfo(BitList tasks, String arg) throws PDIException {
        try {
            this.debugSignalInfo(tasks, arg);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on getting signal info: " + e.getMessage());
        }
    }

    public void retrieveStackInfoDepth(BitList tasks) throws PDIException {
        try {
            this.debugStackInfoDepth(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on getting stack info depth: " + e.getMessage());
        }
    }

    public void retrieveVariableType(BitList tasks, String var) throws PDIException {
        try {
            this.debugGetType(tasks, var);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on getting variable type: " + e.getMessage());
        }
    }

    public void selectThread(BitList tasks, int tid) throws PDIException {
        try {
            this.debugSetThreadSelect(tasks, tid);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting thread id: " + e.getMessage());
        }
    }

    public void setAddressBreakpoint(BitList tasks, IPDIAddressBreakpoint bpt) throws PDIException {
        throw new PDIException(tasks, "Not implement PDIDebugger - setAddressBreakpoint() yet");
    }

    public void setConditionBreakpoint(BitList tasks, int bpid, String condition) throws PDIException {
        try {
            this.debugConditionBreakpoint(tasks, bpid, condition);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting condition breakpoint: " + e.getMessage());
        }
    }

    public void setCurrentStackFrame(BitList tasks, int level) throws PDIException {
        try {
            this.debugSetCurrentStackframe(tasks, level);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting current stack frame level: " + e.getMessage());
        }
    }

    public void setEnabledBreakpoint(BitList tasks, int bpid, boolean enabled) throws PDIException {
        try {
            if (enabled) {
                this.debugEnableBreakpoint(tasks, bpid);
            } else {
                this.debugDisableBreakpoint(tasks, bpid);
            }
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting enabling breakpoint: " + e.getMessage());
        }
    }

    public void setExceptionpoint(BitList tasks, IPDIExceptionpoint bpt) throws PDIException {
        throw new PDIException(tasks, "Not implement PDIDebugger - setExceptionpoint() yet");
    }

    public void setFunctionBreakpoint(BitList tasks, IPDIFunctionBreakpoint bpt) throws PDIException {
        try {
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetFuncBreakpoint(tasks, id, bpt.isTemporary(), bpt.isHardware(), this.getFilename(bpt.getLocator().getFile()), bpt.getLocator().getFunction(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting function breakpoint: " + e.getMessage());
        }
    }

    public void setLineBreakpoint(BitList tasks, IPDILineBreakpoint bpt) throws PDIException {
        try {
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetLineBreakpoint(tasks, id, bpt.isTemporary(), bpt.isHardware(), this.getFilename(bpt.getLocator().getFile()), bpt.getLocator().getLineNumber(), condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting line breakpoint: " + e.getMessage());
        }
    }

    public void setWatchpoint(BitList tasks, IPDIWatchpoint bpt) throws PDIException {
        try {
            String expression = bpt.getWatchExpression();
            boolean access = bpt.isReadType() && bpt.isWriteType();
            boolean read = !bpt.isWriteType() && bpt.isReadType();
            IPDICondition condition = bpt.getCondition();
            int id = bpt.getBreakpointID();
            if (id == -1) {
                id = this.newBreakpointId();
                bpt.setBreakpointID(id);
            }
            this.debugSetWatchpoint(tasks, id, expression, access, read, condition != null ? condition.getExpression() : "", condition != null ? condition.getIgnoreCount() : 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on setting wacthpoint: " + e.getMessage());
        }
    }

    public void start(BitList tasks) throws PDIException {
        this.resume(tasks, false);
    }

    public void startDebugger(String app, String path, String dir, String[] args) throws PDIException {
        try {
            this.debugStartSession(app, path, dir, args);
        }
        catch (IOException e) {
            throw new PDIException(null, "Error on starting debugger: " + e.getMessage());
        }
    }

    public void stepInto(BitList tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 0);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on stepping into: " + e.getMessage());
        }
    }

    public void stepIntoInstruction(BitList tasks, int count) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - stepIntoInstruction() yet");
    }

    public void stepOver(BitList tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 1);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on stepping over: " + e.getMessage());
        }
    }

    public void stepOverInstruction(BitList tasks, int count) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - stepOverInstruction() yet");
    }

    public void stepReturn(BitList tasks, IAIF aif) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - stepReturn(IAIF) yet");
    }

    public void stepReturn(BitList tasks, int count) throws PDIException {
        try {
            this.debugStep(tasks, count, 2);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on stepping return: " + e.getMessage());
        }
    }

    public void stepUntil(BitList tasks, IPDILocation location) throws PDIException {
        throw new PDIException(null, "Not implement PDIDebugger - stepUntil(IPDILocation) yet");
    }

    public void stopDebugger() throws PDIException {
        try {
            try {
                this.doShutdown();
            }
            catch (IOException e) {
                throw new PDIException(null, "Error on stopping debugger: " + e.getMessage());
            }
        }
        finally {
            this.proxyNotifier.deleteObservers();
        }
    }

    public void suspend(BitList tasks) throws PDIException {
        try {
            this.debugInterrupt(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on suspending tasks: " + e.getMessage());
        }
    }

    public void terminate(BitList tasks) throws PDIException {
        try {
            this.debugTerminate(tasks);
        }
        catch (IOException e) {
            throw new PDIException(tasks, "Error on terminating tasks: " + e.getMessage());
        }
    }

    private String getFilename(String fullPath) {
        Path path = new Path(fullPath);
        if (path.isEmpty()) {
            return "";
        }
        return path.lastSegment();
    }

    private String getFormat(int wordFormat) {
        switch (wordFormat) {
            case 15: {
                return "u";
            }
            case 10: {
                return "f";
            }
            case 11: {
                return "a";
            }
            case 12: {
                return "i";
            }
            case 13: {
                return "c";
            }
            case 14: {
                return "s";
            }
            case 3: {
                return "d";
            }
            case 2: {
                return "t";
            }
            case 1: {
                return "o";
            }
        }
        return "x";
    }

    private IResourceManagerControl getResourceManager(ILaunchConfiguration configuration) throws PDIException {
        String rmUniqueName;
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        try {
            rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        }
        catch (CoreException e) {
            throw new PDIException(null, e.getMessage());
        }
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return (IResourceManagerControl)rm;
            }
            ++n2;
        }
        return null;
    }

    private int newBreakpointId() {
        return this.bpid++;
    }

    private class ProxyNotifier
    extends Observable {
        private ProxyNotifier() {
        }

        public void notify(IProxyDebugEvent event) {
            this.setChanged();
            this.notifyObservers(event);
        }
    }
}

