/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.IServiceProviderConfiguration;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceModelWidget {
    protected static final String PROVIDER_KEY = "provider-id";
    protected static final String SERVICE_KEY = "service-id";
    protected Map<String, String> fServiceIDToSelectedProviderID = new HashMap<String, String>();
    protected Map<String, IServiceProvider> fProviderIDToProviderMap = new HashMap<String, IServiceProvider>();
    protected Table fTable;
    protected Button fConfigureButton;
    protected Listener fConfigChangeListener = null;

    public Control createContents(Composite parent) {
        Composite canvas = new Composite(parent, 0);
        GridLayout canvasLayout = new GridLayout(2, false);
        canvas.setLayout((Layout)canvasLayout);
        Composite tableParent = new Composite(canvas, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new Table(tableParent, 67842);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        String[] titles = new String[]{Messages.getString("ServiceModelWidget.0"), Messages.getString("ServiceModelWidget.1"), Messages.getString("ServiceModelWidget.3")};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.fTable, 0);
            column.setText(titles[i]);
            int width = 20;
            switch (i) {
                case 0: {
                    width = 100;
                    break;
                }
                case 1: 
                case 2: {
                    width = 250;
                }
            }
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, width, true));
            ++i;
        }
        tableParent.setLayout((Layout)layout);
        this.fTable.setLayout((Layout)new FillLayout());
        this.createTableContent(null);
        this.fTable.setVisible(true);
        final TableEditor editor = new TableEditor(this.fTable);
        editor.horizontalAlignment = 1;
        editor.grabHorizontal = true;
        this.fTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int selectionIndex = ServiceModelWidget.this.fTable.getSelectionIndex();
                if (selectionIndex == -1) {
                    ServiceModelWidget.this.fConfigureButton.setEnabled(false);
                    return;
                }
                final TableItem item = ServiceModelWidget.this.fTable.getItem(selectionIndex);
                IService service = (IService)item.getData(ServiceModelWidget.SERVICE_KEY);
                IServiceProviderDescriptor provider = (IServiceProviderDescriptor)item.getData(ServiceModelWidget.PROVIDER_KEY);
                ServiceModelWidget.this.updateConfigureButton(provider);
                final CCombo combo = new CCombo((Composite)ServiceModelWidget.this.fTable, 8);
                Set providers = service.getProviders();
                Iterator providerIterator = providers.iterator();
                int index = 0;
                final LinkedList<IServiceProviderDescriptor> providerIds = new LinkedList<IServiceProviderDescriptor>();
                while (providerIterator.hasNext()) {
                    IServiceProviderDescriptor descriptor = (IServiceProviderDescriptor)providerIterator.next();
                    combo.add(descriptor.getName(), index);
                    providerIds.add(descriptor);
                    if (descriptor.equals(provider)) {
                        combo.select(index);
                    }
                    ++index;
                }
                combo.setFocus();
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.type) {
                            case 16: {
                                combo.dispose();
                                break;
                            }
                            case 13: {
                                int selection = combo.getSelectionIndex();
                                if (selection == -1) {
                                    return;
                                }
                                IServiceProviderDescriptor descriptor = (IServiceProviderDescriptor)providerIds.get(selection);
                                item.setText(1, descriptor.getName());
                                IService service = (IService)item.getData(ServiceModelWidget.SERVICE_KEY);
                                item.setData(ServiceModelWidget.PROVIDER_KEY, (Object)descriptor);
                                ServiceModelWidget.this.updateConfigureButton(descriptor);
                                IServiceProvider provider = (this).ServiceModelWidget.this.fProviderIDToProviderMap.get(descriptor.getId());
                                String configString = Messages.getString("ServiceModelWidget.4");
                                if (provider != null) {
                                    configString = provider.getConfigurationString();
                                }
                                item.setText(2, configString);
                                if (descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullBuildServiceProvider") == 0 || descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullCIndexServiceProvider") == 0) {
                                    ServiceModelManager manager = ServiceModelManager.getInstance();
                                    IServiceProvider serviceProvider = manager.getServiceProvider(descriptor);
                                    configString = serviceProvider.getConfigurationString();
                                    if (configString == null) {
                                        configString = Messages.getString("ServiceModelWidget.4");
                                    }
                                    item.setText(2, configString);
                                    (this).ServiceModelWidget.this.fProviderIDToProviderMap.put(descriptor.getId(), serviceProvider);
                                }
                                (this).ServiceModelWidget.this.fServiceIDToSelectedProviderID.put(service.getId(), descriptor.getId());
                                if ((this).ServiceModelWidget.this.fConfigChangeListener != null) {
                                    (this).ServiceModelWidget.this.fConfigChangeListener.handleEvent(null);
                                }
                                combo.dispose();
                            }
                        }
                    }
                };
                combo.addListener(16, listener);
                combo.addListener(13, listener);
                editor.setEditor((Control)combo, item, 1);
            }
        });
        this.fConfigureButton = new Button(canvas, 8);
        this.fConfigureButton.setEnabled(false);
        this.fConfigureButton.setText(Messages.getString("ServiceModelWidget.2"));
        this.fConfigureButton.setLayoutData((Object)new GridData(1, 1, false, false));
        Listener configureListener = this.getConfigureListener();
        this.fConfigureButton.addListener(13, configureListener);
        return canvas;
    }

    protected Listener getConfigureListener() {
        return new ConfigureListener();
    }

    protected void createTableContent(IProject project) {
        this.fTable.removeAll();
        Set<IService> allApplicableServices = this.getContributedServices(project);
        for (IService service : allApplicableServices) {
            TableItem item = new TableItem(this.fTable, 0);
            item.setText(0, service.getName());
            item.setData(SERVICE_KEY, (Object)service);
            IServiceProviderDescriptor descriptor = (IServiceProviderDescriptor)service.getProviders().iterator().next();
            item.setText(1, descriptor.getName());
            item.setData(PROVIDER_KEY, (Object)descriptor);
            String configString = Messages.getString("ServiceModelWidget.4");
            if (descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullBuildServiceProvider") == 0 || descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullCIndexServiceProvider") == 0) {
                ServiceModelManager manager = ServiceModelManager.getInstance();
                IServiceProvider serviceProvider = manager.getServiceProvider(descriptor);
                configString = serviceProvider.getConfigurationString();
                if (configString == null) {
                    configString = Messages.getString("ServiceModelWidget.4");
                }
                this.fProviderIDToProviderMap.put(descriptor.getId(), serviceProvider);
            }
            item.setText(2, configString);
            this.fServiceIDToSelectedProviderID.put(service.getId(), descriptor.getId());
            if (this.fConfigChangeListener == null) continue;
            this.fConfigChangeListener.handleEvent(null);
        }
    }

    protected Set<IService> getContributedServices(IProject project) {
        ServiceModelManager modelManager = ServiceModelManager.getInstance();
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        if (project != null) {
            String[] natureIds = new String[]{};
            try {
                natureIds = project.getDescription().getNatureIds();
            }
            catch (CoreException e) {
                RDTLog.logError((Throwable)e);
            }
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                Set services = modelManager.getServices(natureId);
                if (services != null) {
                    allApplicableServices.addAll(services);
                }
                ++i;
            }
        } else {
            Set cppServices = modelManager.getServices("org.eclipse.cdt.core.ccnature");
            Set cServices = modelManager.getServices("org.eclipse.cdt.core.cnature");
            allApplicableServices.addAll(cppServices);
            allApplicableServices.addAll(cServices);
        }
        return allApplicableServices;
    }

    public Map<String, String> getServiceIDToSelectedProviderID() {
        return this.fServiceIDToSelectedProviderID;
    }

    public Table getTable() {
        return this.fTable;
    }

    public void setTable(Table table) {
        this.fTable = table;
    }

    public void setServiceIDToSelectedProviderID(Map<String, String> serviceIDToSelectedProviderID) {
        this.fServiceIDToSelectedProviderID = serviceIDToSelectedProviderID;
    }

    public Map<String, IServiceProvider> getProviderIDToProviderMap() {
        return this.fProviderIDToProviderMap;
    }

    public void setProviderIDToProviderMap(Map<String, IServiceProvider> providerIDToProviderMap) {
        this.fProviderIDToProviderMap = providerIDToProviderMap;
    }

    public boolean isConfigured() {
        return this.isConfigured(null, this.fServiceIDToSelectedProviderID, this.fProviderIDToProviderMap);
    }

    protected boolean isConfigured(IProject project, Map<String, String> serviceIDToSelectedProviderID, Map<String, IServiceProvider> providerIDToProviderMap) {
        Set<IService> allApplicableServices = this.getContributedServices(project);
        Iterator<IService> iterator = allApplicableServices.iterator();
        boolean configured = true;
        while (iterator.hasNext()) {
            String providerID = serviceIDToSelectedProviderID.get(iterator.next().getId());
            if (providerID == null) {
                return false;
            }
            IServiceProvider provider = providerIDToProviderMap.get(providerID);
            if (provider == null) {
                return false;
            }
            boolean bl = configured = configured && provider.isConfigured();
        }
        return configured;
    }

    public Listener getConfigChangeListener() {
        return this.fConfigChangeListener;
    }

    public void setConfigChangeListener(Listener configChangeListener) {
        this.fConfigChangeListener = configChangeListener;
    }

    protected void updateConfigureButton(IServiceProviderDescriptor descriptor) {
        if (descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullBuildServiceProvider") == 0 || descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullCIndexServiceProvider") == 0) {
            this.fConfigureButton.setEnabled(false);
        } else {
            this.fConfigureButton.setEnabled(true);
        }
    }

    public class ConfigureListener
    implements Listener {
        public void handleEvent(Event event) {
            TableItem[] selection = ServiceModelWidget.this.fTable.getSelection();
            if (selection.length == 0) {
                return;
            }
            TableItem item = selection[0];
            ServiceModelManager manager = ServiceModelManager.getInstance();
            IServiceProviderDescriptor descriptor = (IServiceProviderDescriptor)item.getData(ServiceModelWidget.PROVIDER_KEY);
            IServiceProvider serviceProvider = ServiceModelWidget.this.fProviderIDToProviderMap.get(descriptor.getId());
            if (serviceProvider == null) {
                serviceProvider = manager.getServiceProvider(descriptor);
                ServiceModelWidget.this.fProviderIDToProviderMap.put(descriptor.getId(), serviceProvider);
            }
            IServiceProviderConfiguration configUI = ServiceModelUIManager.getInstance().getServiceProviderConfigurationUI((IServiceProviderDescriptor)serviceProvider);
            configUI.configureServiceProvider(serviceProvider, ServiceModelWidget.this.fConfigureButton.getShell());
            String configString = serviceProvider.getConfigurationString();
            if (configString == null) {
                configString = Messages.getString("ServiceModelWidget.4");
            }
            item.setText(2, configString);
            if (ServiceModelWidget.this.fConfigChangeListener != null) {
                ServiceModelWidget.this.fConfigChangeListener.handleEvent(null);
            }
        }
    }
}

