/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rephraserengine.core.resources.DefaultResourceFilter;
import org.eclipse.rephraserengine.core.resources.IResourceFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbenchSelectionInfo {
    private IResourceFilter resourceFilter;
    private String errorMsg;
    private IEditorPart activeEditor;
    private IFile fileInEditor;
    private ISelection selection;
    private List<IResource> selectedResources;
    private List<IFile> allFilesInSelectedResources;
    private ITextSelection selectionInEditor;

    public WorkbenchSelectionInfo() {
        this((IResourceFilter)new DefaultResourceFilter());
    }

    public WorkbenchSelectionInfo(IResourceFilter resourceFilter) {
        IWorkbenchPage activePage;
        this.resourceFilter = resourceFilter;
        this.selection = null;
        this.selectedResources = Collections.emptyList();
        this.activeEditor = null;
        this.fileInEditor = null;
        this.selectionInEditor = null;
        IWorkbenchWindow activeWindow = Workbench.getInstance().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return;
        }
        this.selection = activeWindow.getSelectionService().getSelection();
        if (this.selection instanceof IStructuredSelection) {
            this.selectedResources = this.getResourcesSelectedIn((IStructuredSelection)this.selection);
            this.allFilesInSelectedResources = this.findAllFilesIn(this.selectedResources);
        }
        if ((activePage = activeWindow.getActivePage()) == null) {
            return;
        }
        this.activeEditor = activePage.getActiveEditor();
        if (this.activeEditor == null) {
            return;
        }
        IEditorInput input = this.activeEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fileInput = (IFileEditorInput)input;
        this.fileInEditor = fileInput.getFile();
        if (!resourceFilter.shouldProcess((IResource)this.fileInEditor)) {
            this.fileInEditor = null;
            this.errorMsg = resourceFilter.getError((IResource)this.fileInEditor);
        }
        if (this.selection instanceof ITextSelection) {
            this.selectionInEditor = (ITextSelection)this.selection;
            if (this.fileInEditor != null) {
                this.selectedResources = Collections.singletonList(this.fileInEditor);
                this.allFilesInSelectedResources = Collections.singletonList(this.fileInEditor);
            }
        }
    }

    private List<IResource> getResourcesSelectedIn(IStructuredSelection selection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (Object selectedItem : selection.toList()) {
            IAdaptable item;
            IResource res;
            if (!(selectedItem instanceof IAdaptable) || (res = (IResource)(item = (IAdaptable)selectedItem).getAdapter(IResource.class)) == null) continue;
            if (this.resourceFilter.shouldProcess(res)) {
                result.add(res);
                continue;
            }
            this.errorMsg = this.resourceFilter.getError(res);
        }
        if (!result.isEmpty()) {
            this.errorMsg = null;
        }
        return result;
    }

    private List<IFile> findAllFilesIn(Collection<IResource> resources) {
        return this.findAllFilesIn(resources.toArray(new IResource[resources.size()]));
    }

    private List<IFile> findAllFilesIn(IResource[] resources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (this.resourceFilter.shouldProcess(r)) {
                if (r instanceof IFile) {
                    files.add((IFile)r);
                } else if (r instanceof IFolder || r instanceof IProject) {
                    try {
                        files.addAll(this.findAllFilesIn(((IContainer)r).members()));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        return files;
    }

    public boolean someFilesAreSelected() {
        return this.allFilesInSelectedResources != null && !this.allFilesInSelectedResources.isEmpty();
    }

    public boolean editingAnIFile() {
        return this.fileInEditor != null;
    }

    public IFile getFileInEditor() {
        return this.fileInEditor;
    }

    public boolean isTextSelectedInEditor() {
        return this.selectionInEditor != null;
    }

    public ITextSelection getSelectionInEditor() {
        return this.selectionInEditor;
    }

    public List<IFile> getAllFilesInSelectedResources() {
        return this.allFilesInSelectedResources;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

