/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.ArrayList;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.util.IterableWrapper;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FortranCompletionProcessorASTTask
implements IFortranEditorASTTask {
    private final FortranCompletionProcessor fortranCompletionProcessor;

    FortranCompletionProcessorASTTask(FortranCompletionProcessor fortranCompletionProcessor) {
        this.fortranCompletionProcessor = fortranCompletionProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(ASTExecutableProgramNode ast, TokenList tokenList, DefinitionMap<Definition> defMap) {
        if (defMap == null) {
            return true;
        }
        FortranCompletionProcessor fortranCompletionProcessor = this.fortranCompletionProcessor;
        synchronized (fortranCompletionProcessor) {
            ArrayList<String> scopes = this.fortranCompletionProcessor.scopes;
            scopes.clear();
            try {
                int lastLine = 0;
                for (Token token : new IterableWrapper((Object)tokenList)) {
                    int line = token.getLine();
                    if (line <= lastLine) continue;
                    scopes.ensureCapacity(line);
                    String qualifier = DefinitionMap.getQualifier(token.getEnclosingScope());
                    while (scopes.size() < line) {
                        scopes.add(qualifier);
                    }
                    lastLine = line;
                }
            }
            catch (Throwable throwable) {}
            return true;
        }
    }
}

