/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.folding;

import java.util.ArrayList;
import org.eclipse.jface.text.Position;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FortranFoldingProvider
implements IFortranEditorASTTask {
    protected AbstractFortranEditor editor = null;

    public void setup(AbstractFortranEditor editor) {
        this.editor = editor;
        FortranEditorTasks.instance(editor).addASTTask(this);
    }

    @Override
    public boolean handle(ASTExecutableProgramNode ast, TokenList tokenList, DefinitionMap<Definition> defMap) {
        if (this.editor == null) {
            return false;
        }
        final FoldingVisitor visitor = new FoldingVisitor();
        ast.accept((Parser.IASTVisitor)visitor);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                FortranFoldingProvider.this.editor.updateFoldingStructure(visitor.positions);
            }
        });
        return true;
    }

    private static class FoldingVisitor
    extends Parser.GenericASTVisitor {
        final ArrayList<Position> positions = new ArrayList();

        private FoldingVisitor() {
        }

        public void visitASTNode(Parser.IASTNode node) {
            if (node instanceof ScopingNode && !(node instanceof ASTExecutableProgramNode)) {
                this.fold(node);
            }
            this.traverseChildren(node);
        }

        private void fold(Parser.IASTNode node) {
            Token firstToken = node.findFirstToken();
            Token lastToken = node.findLastToken();
            if (firstToken == null || lastToken == null) {
                return;
            }
            int offset = firstToken.getFileOffset();
            int length = lastToken.getFileOffset() + lastToken.getLength() - firstToken.getFileOffset();
            this.positions.add(new Position(offset, length));
        }
    }
}

