/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.photran.internal.ui.search.IReferencesSearchContentProvider;
import org.eclipse.photran.internal.ui.search.ReferenceSearchListContentProvider;
import org.eclipse.photran.internal.ui.search.ReferenceSearchListLabelProvider;
import org.eclipse.photran.internal.ui.search.ReferenceSearchTreeContentProvider;
import org.eclipse.photran.internal.ui.search.ReferenceSearchTreeLabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReferenceSearchViewPage
extends AbstractTextSearchViewPage {
    private IReferencesSearchContentProvider contentProvider;

    public ReferenceSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public ReferenceSearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new ReferenceSearchTreeContentProvider();
        viewer.setContentProvider((IContentProvider)((ReferenceSearchTreeContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new ReferenceSearchTreeLabelProvider(this));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new ReferenceSearchListContentProvider();
        viewer.setContentProvider((IContentProvider)((ReferenceSearchListContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new ReferenceSearchListLabelProvider(this));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        try {
            IFile element = (IFile)match.getElement();
            IPath path = element.getFullPath();
            IEditorPart editor = EditorUtility.openInEditor((IPath)path, null);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
    }
}

