/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ShowFullMessageAction
extends SelectionDispatchAction {
    public ShowFullMessageAction(IWorkbenchSite site) {
        super(site);
        this.setText("Event Details");
        this.setToolTipText("Show the entire message for selected event(s)");
    }

    public ShowFullMessageAction(IWorkbenchSite site, String text, String toolTipText) {
        super(site);
        this.setText(text);
        this.setToolTipText(toolTipText);
    }

    public ImageDescriptor getImageDescriptor() {
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        return ImageDescriptor.createFromImage((Image)img);
    }

    protected void run(IMarker marker) {
        Display disp = this.getSite().getShell().getDisplay();
        final Shell shell = new Shell(disp, 16);
        shell.setText("Event Details");
        shell.setSize(800, 600);
        GridLayout gridLayout = new GridLayout(1, false);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        shell.setLayout((Layout)gridLayout);
        shell.setLayoutData((Object)gridData);
        Text message = new Text((Composite)shell, 2882);
        message.setSize(700, 500);
        message.setLayoutData((Object)gridData);
        message.setText(MarkerUtilities.getMessage((IMarker)marker));
        Button close = new Button((Composite)shell, 8);
        close.setText("Close");
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        message.pack();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
        shell.dispose();
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof IMarker) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        for (Object element : selection) {
            if (!(element instanceof IMarker)) continue;
            IMarker marker = (IMarker)element;
            this.run(marker);
        }
    }
}

