/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.toolopts;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.toolopts.IAppInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolArgument
implements IAppInput {
    private String flag = null;
    private String value = null;
    private String separator = "";
    private String confVal = null;
    private boolean localFile = false;
    private boolean useConfValue = false;
    public static int ARG = 0;
    public static int VAR = 1;
    private int type = ARG;

    public void setType(int t) {
        this.type = t;
    }

    @Override
    public Map<String, String> getEnvVars(ILaunchConfiguration configuration) {
        if (this.type != VAR || this.flag == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String val = "";
        if (this.value != null) {
            if (this.localFile) {
                val = String.valueOf(val) + "%%REPLACE_WITH_BUILD_DIR%%" + File.separator;
            }
            val = String.valueOf(val) + this.value;
        }
        if (this.isUseConfValue()) {
            String cval = "";
            try {
                cval = configuration.getAttribute(this.getConfValue(), "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            val = val.replace("%%REPLACE_WITH_CONFIGURATION_VALUE%%", cval);
        }
        map.put(this.flag, val);
        return map;
    }

    @Override
    public String getArgument(ILaunchConfiguration configuration) {
        if (this.type != ARG) {
            return null;
        }
        if (this.isUseConfValue()) {
            String carg = this.getArg();
            String cval = "";
            try {
                cval = configuration.getAttribute(this.getConfValue(), "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            carg = carg.replace("%%REPLACE_WITH_CONFIGURATION_VALUE%%", cval);
            return carg;
        }
        return this.getArg();
    }

    public boolean isUseConfValue() {
        return this.useConfValue;
    }

    public void setUseConfValue(boolean useConfValue) {
        this.useConfValue = useConfValue;
    }

    public ToolArgument(String arg) {
        this.value = arg;
    }

    public ToolArgument(String flag, String value, String sep, boolean local) {
        this.flag = flag;
        this.value = value;
        if (sep != null) {
            this.separator = sep;
        }
        this.localFile = local;
    }

    private String getArg() {
        String arg = "";
        if (this.flag != null) {
            arg = String.valueOf(arg) + this.flag;
            arg = String.valueOf(arg) + this.separator;
        }
        if (this.useConfValue) {
            arg = String.valueOf(arg) + "%%REPLACE_WITH_CONFIGURATION_VALUE%%";
        } else if (this.value != null) {
            if (this.localFile) {
                arg = String.valueOf(arg) + "%%REPLACE_WITH_BUILD_DIR%%" + File.separator;
            }
            arg = String.valueOf(arg) + this.value;
        }
        return arg;
    }

    public void setConfValue(String cval) {
        this.confVal = cval;
    }

    public String getConfValue() {
        return this.confVal;
    }
}

