/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.IInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value
implements IValue {
    public static final int MAX_RECURSION_DEPTH = 25;
    public static final IValue UNKNOWN = new Value("<unknown>".toCharArray(), ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
    private static final String SCOPE_OP = "::";
    private static final char UNIQUE_CHAR = '_';
    private static final char TEMPLATE_PARAM_CHAR = '#';
    private static final char REFERENCE_CHAR = '&';
    private static final char UNARY_OP_CHAR = '$';
    private static final char BINARY_OP_CHAR = '@';
    private static final char CONDITIONAL_CHAR = '?';
    private static final char SEPARATOR = ',';
    private static final IValue[] TYPICAL = new IValue[]{new Value(new char[]{'0'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'1'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'2'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'3'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'4'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'5'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY), new Value(new char[]{'6'}, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY)};
    private static UnknownValueException UNKNOWN_EX = new UnknownValueException();
    private static int sUnique = 0;
    private final char[] fExpression;
    private final ICPPUnknownBinding[] fUnknownBindings;
    private char[] fSignature;

    private Value(char[] rep, ICPPUnknownBinding[] unknown) {
        assert (rep != null);
        this.fExpression = rep;
        this.fUnknownBindings = unknown;
    }

    @Override
    public char[] getInternalExpression() {
        return this.fExpression;
    }

    @Override
    public IBinding[] getUnknownBindings() {
        return this.fUnknownBindings;
    }

    @Override
    public char[] getSignature() {
        if (this.fSignature == null) {
            if (this.fUnknownBindings.length == 0) {
                this.fSignature = this.fExpression;
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append(this.fExpression);
                buf.append('[');
                int i = 0;
                while (i < this.fUnknownBindings.length) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(Value.getSignatureForUnknown(this.fUnknownBindings[i]));
                    ++i;
                }
                buf.append(']');
                int end = buf.length();
                this.fSignature = new char[end];
                buf.getChars(0, end, this.fSignature, 0);
            }
        }
        return this.fSignature;
    }

    @Override
    public Long numericalValue() {
        return Value.parseLong(this.fExpression);
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.fExpression);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IValue)) {
            return false;
        }
        IValue rhs = (IValue)obj;
        if (!CharArrayUtils.equals(this.fExpression, rhs.getInternalExpression())) {
            return false;
        }
        IBinding[] rhsUnknowns = rhs.getUnknownBindings();
        if (this.fUnknownBindings.length != rhsUnknowns.length) {
            return false;
        }
        int i = 0;
        while (i < rhsUnknowns.length) {
            IBinding rhsUnknown = rhsUnknowns[i];
            if (rhsUnknown instanceof ICPPUnknownBinding) {
                if (!Value.getSignatureForUnknown((ICPPUnknownBinding)rhsUnknown).equals(Value.getSignatureForUnknown(this.fUnknownBindings[i]))) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return new String(this.getSignature());
    }

    public static IValue create(long value) {
        if (value >= 0L && value < (long)TYPICAL.length) {
            return TYPICAL[(int)value];
        }
        return new Value(Value.toCharArray(value), ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
    }

    public static IValue create(ICPPTemplateNonTypeParameter tntp) {
        String expr = Value.createTemplateParamExpression(tntp.getParameterID());
        return new Value(expr.toCharArray(), ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
    }

    private static String createTemplateParamExpression(int id) {
        StringBuilder buf = new StringBuilder();
        buf.append('#');
        buf.append(Integer.toHexString(id));
        return buf.toString();
    }

    public static int isTemplateParameter(IValue tval) {
        char[] rep = tval.getInternalExpression();
        if (rep.length > 0 && rep[0] == '#') {
            int i = 1;
            while (i < rep.length) {
                if (rep[i] == ',') {
                    return -1;
                }
                ++i;
            }
            try {
                return Value.parseHex(rep, 1);
            }
            catch (UnknownValueException unknownValueException) {}
        }
        return -1;
    }

    public static boolean referencesTemplateParameter(IValue tval) {
        char[] rep = tval.getInternalExpression();
        int i = 0;
        while (i < rep.length) {
            if (rep[i] == '#') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDependentValue(IValue nonTypeValue) {
        char[] rep = nonTypeValue.getInternalExpression();
        int i = 0;
        while (i < rep.length) {
            char c = rep[i];
            if (c == '&' || c == '#') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IValue create(IASTExpression expr, int maxRecursionDepth) {
        try {
            HashMap<String, Integer> unknownSigs = new HashMap<String, Integer>();
            ArrayList<ICPPUnknownBinding> unknown = new ArrayList<ICPPUnknownBinding>();
            Object obj = Value.evaluate(expr, unknownSigs, unknown, maxRecursionDepth);
            if (obj instanceof Number) {
                return Value.create(((Number)obj).longValue());
            }
            ICPPUnknownBinding[] ua = unknown.isEmpty() ? ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY : unknown.toArray(new ICPPUnknownBinding[unknown.size()]);
            return new Value(((String)obj).toCharArray(), ua);
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    public static IValue fromInternalRepresentation(char[] rep, ICPPUnknownBinding[] unknown) {
        if (CharArrayUtils.equals(rep, UNKNOWN.getInternalExpression())) {
            return UNKNOWN;
        }
        Long l = Value.parseLong(rep);
        if (l != null) {
            return Value.create(l);
        }
        return new Value(rep, unknown);
    }

    public static IValue unique() {
        StringBuilder buf = new StringBuilder(10);
        buf.append('_');
        buf.append(++sUnique);
        return new Value(Value.extractChars(buf), ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
    }

    private static Object evaluate(IASTExpression e, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns, int maxdepth) throws UnknownValueException {
        if (maxdepth < 0 || e == null) {
            throw UNKNOWN_EX;
        }
        if (e instanceof IASTArraySubscriptExpression) {
            throw UNKNOWN_EX;
        }
        if (e instanceof IASTBinaryExpression) {
            return Value.evaluateBinaryExpression((IASTBinaryExpression)e, unknownSigs, unknowns, maxdepth);
        }
        if (e instanceof IASTCastExpression) {
            return Value.evaluate(((IASTCastExpression)e).getOperand(), unknownSigs, unknowns, maxdepth);
        }
        if (e instanceof IASTUnaryExpression) {
            return Value.evaluateUnaryExpression((IASTUnaryExpression)e, unknownSigs, unknowns, maxdepth);
        }
        if (e instanceof IASTConditionalExpression) {
            IASTConditionalExpression cexpr = (IASTConditionalExpression)e;
            Object o = Value.evaluate(cexpr.getLogicalConditionExpression(), unknownSigs, unknowns, maxdepth);
            if (o instanceof Long) {
                Long v = (Long)o;
                if (v == 0L) {
                    return Value.evaluate(cexpr.getNegativeResultExpression(), unknownSigs, unknowns, maxdepth);
                }
                IASTExpression pe = cexpr.getPositiveResultExpression();
                if (pe == null) {
                    return o;
                }
                return Value.evaluate(pe, unknownSigs, unknowns, maxdepth);
            }
            IASTExpression pe = cexpr.getPositiveResultExpression();
            Object po = pe == null ? o : Value.evaluate(pe, unknownSigs, unknowns, maxdepth);
            Object neg = Value.evaluate(cexpr.getNegativeResultExpression(), unknownSigs, unknowns, maxdepth);
            return String.valueOf(107) + o.toString() + ',' + po.toString() + ',' + neg.toString();
        }
        if (e instanceof IASTIdExpression) {
            IBinding b = ((IASTIdExpression)e).getName().resolvePreBinding();
            return Value.evaluateBinding(b, unknownSigs, unknowns, maxdepth);
        }
        if (e instanceof IASTLiteralExpression) {
            IASTLiteralExpression litEx = (IASTLiteralExpression)e;
            switch (litEx.getKind()) {
                case 6: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 0: {
                    try {
                        return ExpressionEvaluator.getNumber(litEx.getValue());
                    }
                    catch (ExpressionEvaluator.EvalException evalException) {
                        throw UNKNOWN_EX;
                    }
                }
                case 2: {
                    try {
                        char[] image = litEx.getValue();
                        if (image.length > 1 && image[0] == 'L') {
                            return ExpressionEvaluator.getChar(image, 2);
                        }
                        return ExpressionEvaluator.getChar(image, 1);
                    }
                    catch (ExpressionEvaluator.EvalException evalException) {
                        throw UNKNOWN_EX;
                    }
                }
            }
        }
        throw UNKNOWN_EX;
    }

    private static Object evaluateBinding(IBinding b, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns, int maxdepth) throws UnknownValueException {
        if (b instanceof IType) {
            throw UNKNOWN_EX;
        }
        if (b instanceof ICPPTemplateNonTypeParameter) {
            return Value.createTemplateParamExpression(((ICPPTemplateNonTypeParameter)b).getParameterID());
        }
        if (b instanceof ICPPUnknownBinding) {
            return Value.createReference((ICPPUnknownBinding)b, unknownSigs, unknowns);
        }
        IValue value = null;
        if (b instanceof IInternalVariable) {
            value = ((IInternalVariable)b).getInitialValue(maxdepth - 1);
        } else if (b instanceof IVariable) {
            value = ((IVariable)b).getInitialValue();
        } else if (b instanceof IEnumerator) {
            value = ((IEnumerator)b).getValue();
        }
        if (value != null) {
            return Value.evaluateValue(value, unknownSigs, unknowns);
        }
        throw UNKNOWN_EX;
    }

    private static Object createReference(ICPPUnknownBinding unknown, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns) {
        String sig = Value.getSignatureForUnknown(unknown);
        Integer idx = unknownSigs.get(sig);
        if (idx == null) {
            idx = unknownSigs.size();
            unknownSigs.put(sig, idx);
            unknowns.add(unknown);
        }
        return String.valueOf('&') + idx.toString();
    }

    private static Object evaluateValue(IValue cv, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns) throws UnknownValueException {
        if (cv == UNKNOWN) {
            throw UNKNOWN_EX;
        }
        Long lv = cv.numericalValue();
        if (lv != null) {
            return lv;
        }
        IBinding[] oldUnknowns = cv.getUnknownBindings();
        char[] expr = cv.getInternalExpression();
        if (oldUnknowns.length == 0) {
            return new String(expr);
        }
        StringBuilder buf = new StringBuilder(expr.length);
        boolean skipToSeparator = false;
        int i = 0;
        while (i < expr.length) {
            char c = expr[i];
            switch (c) {
                case '&': {
                    int idx = Value.parseNonNegative(expr, i + 1);
                    if (idx >= oldUnknowns.length) {
                        throw UNKNOWN_EX;
                    }
                    IBinding old = oldUnknowns[idx];
                    if (!(old instanceof ICPPUnknownBinding)) {
                        throw UNKNOWN_EX;
                    }
                    buf.append(Value.createReference((ICPPUnknownBinding)old, unknownSigs, unknowns));
                    skipToSeparator = true;
                    break;
                }
                case ',': {
                    skipToSeparator = false;
                    buf.append(c);
                    break;
                }
                default: {
                    if (skipToSeparator) break;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static Object evaluateUnaryExpression(IASTUnaryExpression ue, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns, int maxdepth) throws UnknownValueException {
        int unaryOp = ue.getOperator();
        if (unaryOp == 5 || unaryOp == 4) {
            throw UNKNOWN_EX;
        }
        Object value = Value.evaluate(ue.getOperand(), unknownSigs, unknowns, maxdepth);
        return Value.combineUnary(unaryOp, value);
    }

    private static Object combineUnary(int unaryOp, Object value) throws UnknownValueException {
        switch (unaryOp) {
            case 2: 
            case 11: {
                return value;
            }
        }
        if (value instanceof Long) {
            long v = (Long)value;
            switch (unaryOp) {
                case 0: 
                case 9: {
                    return ++v;
                }
                case 1: 
                case 10: {
                    return --v;
                }
                case 3: {
                    return -v;
                }
                case 6: {
                    return v ^ 0xFFFFFFFFFFFFFFFFL;
                }
                case 7: {
                    return v == 0L ? 1 : 0;
                }
            }
            throw UNKNOWN_EX;
        }
        switch (unaryOp) {
            case 0: 
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return String.valueOf(36 + unaryOp + 44) + value.toString();
            }
        }
        throw UNKNOWN_EX;
    }

    private static Object evaluateBinaryExpression(IASTBinaryExpression be, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns, int maxdepth) throws UnknownValueException {
        Object o1 = Value.evaluate(be.getOperand1(), unknownSigs, unknowns, maxdepth);
        Object o2 = Value.evaluate(be.getOperand2(), unknownSigs, unknowns, maxdepth);
        int op = be.getOperator();
        return Value.combineBinary(op, o1, o2);
    }

    private static Object combineBinary(int op, Object o1, Object o2) throws UnknownValueException {
        if (o1 instanceof Long && o2 instanceof Long) {
            long v1 = (Long)o1;
            long v2 = (Long)o2;
            switch (op) {
                case 1: {
                    return v1 * v2;
                }
                case 2: {
                    if (v2 == 0L) {
                        throw UNKNOWN_EX;
                    }
                    return v1 / v2;
                }
                case 3: {
                    if (v2 == 0L) {
                        throw UNKNOWN_EX;
                    }
                    return v1 % v2;
                }
                case 4: {
                    return v1 + v2;
                }
                case 5: {
                    return v1 - v2;
                }
                case 6: {
                    return v1 << (int)v2;
                }
                case 7: {
                    return v1 >> (int)v2;
                }
                case 8: {
                    return v1 < v2 ? 1 : 0;
                }
                case 9: {
                    return v1 > v2 ? 1 : 0;
                }
                case 10: {
                    return v1 <= v2 ? 1 : 0;
                }
                case 11: {
                    return v1 >= v2 ? 1 : 0;
                }
                case 12: {
                    return v1 & v2;
                }
                case 13: {
                    return v1 ^ v2;
                }
                case 14: {
                    return v1 | v2;
                }
                case 15: {
                    return v1 != 0L && v2 != 0L ? 1 : 0;
                }
                case 16: {
                    return v1 != 0L || v2 != 0L ? 1 : 0;
                }
                case 28: {
                    return v1 == v2 ? 1 : 0;
                }
                case 29: {
                    return v1 != v2 ? 1 : 0;
                }
                case 32: {
                    return Math.max(v1, v2);
                }
                case 33: {
                    return Math.min(v1, v2);
                }
            }
            throw UNKNOWN_EX;
        }
        switch (op) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 32: 
            case 33: {
                break;
            }
            case 28: {
                if (!o1.equals(o2)) break;
                return 1;
            }
            case 29: {
                if (!o1.equals(o2)) break;
                return 0;
            }
            default: {
                throw UNKNOWN_EX;
            }
        }
        return String.valueOf(64 + op + 44) + o1.toString() + ',' + o2.toString();
    }

    public static IValue reevaluate(IValue val, IBinding[] resolvedUnknowns, ICPPTemplateParameterMap map, int maxdepth) {
        try {
            HashMap<String, Integer> unknownSigs = new HashMap<String, Integer>();
            ArrayList<ICPPUnknownBinding> unknown = new ArrayList<ICPPUnknownBinding>();
            Reevaluation reeval = new Reevaluation(val.getInternalExpression(), unknownSigs, unknown, resolvedUnknowns, map);
            Object obj = Value.reevaluate(reeval, maxdepth);
            if (reeval.pos != reeval.fExpression.length) {
                return UNKNOWN;
            }
            if (obj instanceof Long) {
                return Value.create((Long)obj);
            }
            ICPPUnknownBinding[] ua = unknown.isEmpty() ? ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY : unknown.toArray(new ICPPUnknownBinding[unknown.size()]);
            return new Value(((String)obj).toCharArray(), ua);
        }
        catch (UnknownValueException unknownValueException) {
            return UNKNOWN;
        }
    }

    private static Object reevaluate(Reevaluation reeval, int maxdepth) throws UnknownValueException {
        if (maxdepth < 0) {
            throw UNKNOWN_EX;
        }
        int idx = reeval.pos;
        char[] buf = reeval.fExpression;
        int length = buf.length;
        if (idx >= length) {
            throw UNKNOWN_EX;
        }
        char c = buf[idx];
        switch (c) {
            case '@': {
                int op = Value.parseNonNegative(buf, idx + 1);
                reeval.nextSeperator();
                Object o1 = Value.reevaluate(reeval, maxdepth);
                Object o2 = Value.reevaluate(reeval, maxdepth);
                return Value.combineBinary(op, o1, o2);
            }
            case '$': {
                int op = Value.parseNonNegative(buf, idx + 1);
                reeval.nextSeperator();
                Object o1 = Value.reevaluate(reeval, maxdepth);
                return Value.combineUnary(op, o1);
            }
            case '?': {
                reeval.nextSeperator();
                Object cond = Value.reevaluate(reeval, maxdepth);
                Object po = Value.reevaluate(reeval, maxdepth);
                Object neg = Value.reevaluate(reeval, maxdepth);
                if (cond instanceof Long) {
                    Long v = (Long)cond;
                    if (v == 0L) {
                        return neg;
                    }
                    return po;
                }
                return String.valueOf(107) + cond.toString() + ',' + po.toString() + ',' + neg.toString();
            }
            case '&': {
                int num = Value.parseNonNegative(buf, idx + 1);
                IBinding[] resolvedUnknowns = reeval.fResolvedUnknown;
                if (num >= resolvedUnknowns.length) {
                    throw UNKNOWN_EX;
                }
                reeval.nextSeperator();
                return Value.evaluateBinding(resolvedUnknowns[num], reeval.fUnknownSigs, reeval.fUnknowns, maxdepth);
            }
            case '#': {
                int num = Value.parseHex(buf, idx + 1);
                reeval.nextSeperator();
                ICPPTemplateArgument arg = reeval.fMap.getArgument(num);
                if (arg != null) {
                    IValue val = arg.getNonTypeValue();
                    if (val == null) {
                        throw UNKNOWN_EX;
                    }
                    return Value.evaluateValue(val, reeval.fUnknownSigs, reeval.fUnknowns);
                }
                return Value.createTemplateParamExpression(num);
            }
        }
        reeval.nextSeperator();
        return Value.parseLong(buf, idx);
    }

    private static int parseNonNegative(char[] value, int offset) throws UnknownValueException {
        int len = value.length;
        int result = 0;
        boolean ok = false;
        while (offset < len) {
            int digit = value[offset] - 48;
            if (digit < 0 || digit > 9) break;
            if ((long)result > 0xCCCCCCCL) {
                return -1;
            }
            result = result * 10 + digit;
            ok = true;
            ++offset;
        }
        if (!ok) {
            throw UNKNOWN_EX;
        }
        return result;
    }

    private static int parseHex(char[] value, int offset) throws UnknownValueException {
        int result = 0;
        boolean ok = false;
        int len = value.length;
        while (offset < len) {
            int digit = value[offset] - 48;
            if (!(digit >= 0 && digit <= 9 || (digit -= 39) >= 10 && digit <= 15) && ((digit += 32) < 10 || digit > 15)) break;
            if ((result & 0xF0000000) != 0) {
                throw UNKNOWN_EX;
            }
            result = (result << 4) + digit;
            ok = true;
            ++offset;
        }
        if (!ok) {
            throw UNKNOWN_EX;
        }
        return result;
    }

    private static long parseLong(char[] value, int offset) throws UnknownValueException {
        int len = value.length;
        boolean negative = false;
        long result = 0L;
        boolean ok = false;
        if (offset < len && value[offset] == '-') {
            negative = true;
            ++offset;
        }
        while (offset < len) {
            int digit = value[offset] - 48;
            if (digit < 0 || digit > 9) break;
            if (result > 0xCCCCCCCCCCCCCCCL) {
                throw UNKNOWN_EX;
            }
            result = result * 10L + (long)digit;
            ok = true;
            ++offset;
        }
        if (!ok) {
            throw UNKNOWN_EX;
        }
        return negative ? -result : result;
    }

    /*
     * Unable to fully structure code
     */
    private static Long parseLong(char[] value) {
        len = value.length;
        negative = false;
        result = 0L;
        i = 0;
        if (len > 0 && value[0] == '-') {
            negative = true;
            ++i;
        }
        if (i != len) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (result > 0xCCCCCCCCCCCCCCCL) {
                return null;
            }
            digit = value[i] - 48;
            if (digit < 0 || digit > 9) {
                return null;
            }
            result = result * 10L + (long)digit;
            ++i;
lbl17:
            // 2 sources

            ** while (i < len)
        }
lbl18:
        // 1 sources

        return negative != false ? -result : result;
    }

    private static String getSignatureForUnknown(ICPPUnknownBinding binding) {
        try {
            IBinding owner = binding.getOwner();
            if (owner instanceof IType) {
                return String.valueOf(ASTTypeUtil.getType((IType)((Object)owner), true)) + SCOPE_OP + binding.getName();
            }
        }
        catch (DOMException dOMException) {}
        return binding.getName();
    }

    private static char[] toCharArray(long value) {
        StringBuilder buf = new StringBuilder();
        buf.append(value);
        return Value.extractChars(buf);
    }

    private static char[] extractChars(StringBuilder buf) {
        int len = buf.length();
        char[] result = new char[len];
        buf.getChars(0, len, result, 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Reevaluation {
        public final char[] fExpression;
        public int pos = 0;
        public final Map<String, Integer> fUnknownSigs;
        public final List<ICPPUnknownBinding> fUnknowns;
        public final IBinding[] fResolvedUnknown;
        public final ICPPTemplateParameterMap fMap;

        public Reevaluation(char[] expr, Map<String, Integer> unknownSigs, List<ICPPUnknownBinding> unknowns, IBinding[] resolvedUnknowns, ICPPTemplateParameterMap map) {
            this.fExpression = expr;
            this.fUnknownSigs = unknownSigs;
            this.fUnknowns = unknowns;
            this.fResolvedUnknown = resolvedUnknowns;
            this.fMap = map;
        }

        public void nextSeperator() throws UnknownValueException {
            char[] expression = this.fExpression;
            int len = expression.length;
            int idx = this.pos;
            while (idx < len) {
                if (expression[idx++] == ',') break;
            }
            this.pos = idx;
        }
    }

    private static class UnknownValueException
    extends Exception {
        private UnknownValueException() {
        }
    }
}

