/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.core.runtime.CoreException;

public class Conversions {
    private static final int IS_LONG = 1;
    private static final int IS_UNSIGNED = 8;

    public static Cost checkImplicitConversionSequence(IASTExpression sourceExp, IType source, IType target, UDCMode udc, boolean isImpliedObject) throws DOMException {
        int depth;
        if (isImpliedObject) {
            udc = UDCMode.noUDC;
        }
        target = SemanticUtil.getNestedType(target, 1);
        source = SemanticUtil.getNestedType(source, 1);
        if (target instanceof ICPPReferenceType) {
            boolean cv1isConst;
            Cost cost;
            boolean lvalue;
            IType cv1T1 = SemanticUtil.getNestedType(target, 3);
            boolean bl = lvalue = sourceExp == null || !CPPVisitor.isRValue(sourceExp);
            if (source instanceof ICPPReferenceType) {
                source = SemanticUtil.getNestedType(source, 3);
            }
            IType T2 = SemanticUtil.getNestedType(source, 15);
            if (lvalue && (cost = Conversions.isReferenceCompatible(cv1T1, source, isImpliedObject)) != null) {
                if (cost.getInheritanceDistance() > 0) {
                    cost.setRank(Cost.Rank.CONVERSION);
                }
                return cost;
            }
            if (T2 instanceof ICPPClassType && udc != UDCMode.noUDC) {
                ICPPMethod[] fcns = SemanticUtil.getConversionOperators((ICPPClassType)T2);
                Cost operatorCost = null;
                boolean ambiguousConversionOperator = false;
                if (fcns.length > 0 && !(fcns[0] instanceof IProblemBinding)) {
                    ICPPMethod[] iCPPMethodArray = fcns;
                    int n = fcns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int cmp;
                        IType cvT2;
                        Cost cost2;
                        ICPPMethod op = iCPPMethodArray[n2];
                        IType newSource = op.getType().getReturnType();
                        if (newSource instanceof ICPPReferenceType && (cost2 = Conversions.isReferenceCompatible(cv1T1, cvT2 = SemanticUtil.getNestedType(newSource, 3), false)) != null && (cmp = cost2.compareTo(operatorCost)) <= 0) {
                            ambiguousConversionOperator = cmp == 0;
                            operatorCost = cost2;
                            operatorCost.setUserDefinedConversion(op);
                        }
                        ++n2;
                    }
                }
                if (operatorCost != null && !ambiguousConversionOperator) {
                    if (isImpliedObject) {
                        operatorCost.setInheritanceDistance(0);
                    }
                    return operatorCost;
                }
            }
            boolean bl2 = cv1isConst = Conversions.getCVQualifier(cv1T1) == 1;
            if (cv1isConst) {
                Cost cost2;
                if (!lvalue && T2 instanceof ICPPClassType && (cost2 = Conversions.isReferenceCompatible(cv1T1, source, isImpliedObject)) != null) {
                    return cost2;
                }
                if (!isImpliedObject) {
                    boolean illformed;
                    IType T1 = SemanticUtil.getNestedType(cv1T1, 15);
                    boolean bl3 = illformed = Conversions.isReferenceRelated(T1, T2) >= 0 && Conversions.compareQualifications(cv1T1, source) < 0;
                    if (!illformed) {
                        return Conversions.nonReferenceConversion(source, cv1T1, udc, isImpliedObject);
                    }
                }
            }
            return new Cost(source, cv1T1, Cost.Rank.NO_MATCH);
        }
        source = SemanticUtil.getNestedType(source, 15);
        target = SemanticUtil.getNestedType(target, 15);
        if (source instanceof ICPPClassType && target instanceof ICPPClassType && (depth = Conversions.calculateInheritanceDepth(10, source, target)) > -1) {
            if (depth == 0) {
                return new Cost(source, target, Cost.Rank.IDENTITY);
            }
            Cost cost = new Cost(source, target, Cost.Rank.CONVERSION);
            cost.setInheritanceDistance(depth);
            return cost;
        }
        return Conversions.nonReferenceConversion(source, target, udc, isImpliedObject);
    }

    private static Cost nonReferenceConversion(IType source, IType target, UDCMode udc, boolean isImpliedObject) throws DOMException {
        Cost cost = Conversions.checkStandardConversionSequence(source, target, isImpliedObject);
        if (cost.getRank() != Cost.Rank.NO_MATCH || udc == UDCMode.noUDC) {
            return cost;
        }
        Cost temp = Conversions.checkUserDefinedConversionSequence(source, target, udc == UDCMode.deferUDC);
        if (temp != null) {
            cost = temp;
        }
        return cost;
    }

    private static final int compareQualifications(IType t1, IType t2) throws DOMException {
        int cv2;
        int cv1 = Conversions.getCVQualifier(t1);
        if (cv1 == (cv2 = Conversions.getCVQualifier(t2))) {
            return 0;
        }
        int diffs = cv1 ^ cv2;
        if (diffs == 3 && cv1 != 3 && cv2 != 3) {
            return -1;
        }
        return cv1 - cv2;
    }

    private static int getCVQualifier(IType t) {
        if (t instanceof IQualifierType) {
            int result = 0;
            IQualifierType qt = (IQualifierType)t;
            if (qt.isConst()) {
                result = 1;
            }
            if (qt.isVolatile()) {
                result |= 2;
            }
            return result;
        }
        if (t instanceof IPointerType) {
            IPointerType pt = (IPointerType)t;
            int result = 0;
            if (pt.isConst()) {
                result = 1;
            }
            if (pt.isVolatile()) {
                result |= 2;
            }
            return result;
        }
        return 0;
    }

    private static final int isReferenceRelated(IType cv1Target, IType cv2Source) throws DOMException {
        IType t = SemanticUtil.getNestedType(cv1Target, 3);
        IType s = SemanticUtil.getNestedType(cv2Source, 3);
        if (t instanceof IPointerType && s instanceof IPointerType) {
            t = SemanticUtil.getNestedType(((IPointerType)t).getType(), 3);
            s = SemanticUtil.getNestedType(((IPointerType)s).getType(), 3);
        } else {
            if (t instanceof IQualifierType) {
                t = SemanticUtil.getNestedType(((IQualifierType)t).getType(), 3);
            }
            if (s instanceof IQualifierType) {
                s = SemanticUtil.getNestedType(((IQualifierType)s).getType(), 3);
            }
            if (t instanceof ICPPClassType && s instanceof ICPPClassType) {
                return Conversions.calculateInheritanceDepth(10, s, t);
            }
        }
        if (t == s || t != null && s != null && t.isSameType(s)) {
            return 0;
        }
        return -1;
    }

    private static final Cost isReferenceCompatible(IType cv1Target, IType cv2Source, boolean isImpliedObject) throws DOMException {
        int inheritanceDist = Conversions.isReferenceRelated(cv1Target, cv2Source);
        if (inheritanceDist < 0) {
            return null;
        }
        int cmp = Conversions.compareQualifications(cv1Target, cv2Source);
        if (cmp < 0) {
            return null;
        }
        if (isImpliedObject) {
            inheritanceDist = 0;
        }
        Cost cost = new Cost(cv2Source, cv1Target, Cost.Rank.IDENTITY);
        cost.setQualificationAdjustment(cmp);
        cost.setInheritanceDistance(inheritanceDist);
        return cost;
    }

    protected static final Cost checkStandardConversionSequence(IType source, IType target, boolean isImplicitThis) throws DOMException {
        Cost cost = new Cost(source, target, Cost.Rank.IDENTITY);
        if (Conversions.lvalue_to_rvalue(cost)) {
            return cost;
        }
        if (Conversions.promotion(cost)) {
            return cost;
        }
        if (Conversions.conversion(cost, isImplicitThis)) {
            return cost;
        }
        if (Conversions.qualificationConversion(cost)) {
            return cost;
        }
        cost.setRank(Cost.Rank.NO_MATCH);
        return cost;
    }

    static final Cost checkUserDefinedConversionSequence(IType source, IType target, boolean deferUDC) throws DOMException {
        Cost constructorCost = null;
        Cost operatorCost = null;
        IType s = SemanticUtil.getNestedType(source, 7);
        IType t = SemanticUtil.getNestedType(target, 7);
        if (!(s instanceof ICPPClassType) && !(t instanceof ICPPClassType)) {
            return null;
        }
        if (deferUDC) {
            Cost c = new Cost(s, t, Cost.Rank.USER_DEFINED_CONVERSION);
            c.setDeferredUDC(true);
            return c;
        }
        if (t instanceof ICPPClassType) {
            ICPPConstructor[] ctors = ((ICPPClassType)t).getConstructors();
            int j = 0;
            IFunction[] convertingCtors = new ICPPConstructor[ctors.length];
            int i = 0;
            while (i < ctors.length) {
                ICPPConstructor ctor = ctors[i];
                if (!(ctor instanceof IProblemBinding) && !ctor.isExplicit()) {
                    convertingCtors[j++] = ctor;
                }
                ++i;
            }
            if (j > 0) {
                LookupData data = new LookupData();
                data.setFunctionArgumentTypes(new IType[]{source});
                IBinding binding = CPPSemantics.resolveFunction(data, convertingCtors, false);
                if (binding instanceof ICPPConstructor && !(binding instanceof IProblemBinding)) {
                    constructorCost = Conversions.checkStandardConversionSequence(t, target, false);
                    if (constructorCost.getRank() == Cost.Rank.NO_MATCH) {
                        constructorCost = null;
                    } else {
                        constructorCost.setUserDefinedConversion((ICPPConstructor)binding);
                    }
                }
            }
        }
        boolean ambiguousConversionOperator = false;
        if (s instanceof ICPPClassType) {
            IFunction[] ops = SemanticUtil.getConversionOperators((ICPPClassType)s);
            CPPTemplates.instantiateConversionTemplates(ops, target);
            IFunction[] iFunctionArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                int cmp;
                Cost cost;
                IFunction op = iFunctionArray[n2];
                if (op != null && !(op instanceof IProblemBinding) && (cost = Conversions.checkStandardConversionSequence(op.getType().getReturnType(), target, false)).getRank() != Cost.Rank.NO_MATCH && (cmp = cost.compareTo(operatorCost)) <= 0) {
                    cost.setUserDefinedConversion((ICPPMethod)op);
                    operatorCost = cost;
                    ambiguousConversionOperator = cmp == 0;
                }
                ++n2;
            }
        }
        if (constructorCost != null) {
            if (operatorCost != null && !ambiguousConversionOperator) {
                constructorCost.setAmbiguousUDC(true);
            }
            return constructorCost;
        }
        if (operatorCost != null) {
            operatorCost.setAmbiguousUDC(ambiguousConversionOperator);
            return operatorCost;
        }
        return null;
    }

    private static final int calculateInheritanceDepth(int maxdepth, IType type, IType ancestorToFind) throws DOMException {
        if (type == ancestorToFind || type.isSameType(ancestorToFind)) {
            return 0;
        }
        if (maxdepth > 0 && type instanceof ICPPClassType && ancestorToFind instanceof ICPPClassType) {
            ICPPClassType clazz = (ICPPClassType)type;
            if (clazz instanceof ICPPDeferredClassInstance) {
                clazz = (ICPPClassType)((ICPPDeferredClassInstance)clazz).getSpecializedBinding();
            }
            ICPPBase[] iCPPBaseArray = clazz.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof IType) {
                    int n3;
                    IType tbase = (IType)((Object)base);
                    if (tbase.isSameType(ancestorToFind) || ancestorToFind instanceof ICPPSpecialization && ((IType)((Object)((ICPPSpecialization)((Object)ancestorToFind)).getSpecializedBinding())).isSameType(tbase)) {
                        return 1;
                    }
                    if ((tbase = SemanticUtil.getNestedType(tbase, 1)) instanceof ICPPClassType && (n3 = Conversions.calculateInheritanceDepth(maxdepth - 1, tbase, ancestorToFind)) > 0) {
                        return n3 + 1;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean lvalue_to_rvalue(Cost cost) throws DOMException {
        IType unqualifiedSource;
        IType unqualifiedTarget;
        IType targetPtrTgt;
        boolean isConverted = false;
        IType target = SemanticUtil.getNestedType(cost.target, 3);
        IType source = SemanticUtil.getNestedType(cost.source, 1);
        IType srcRValue = SemanticUtil.getNestedType(source, 3);
        if (source instanceof ICPPReferenceType && !(srcRValue instanceof IFunctionType) && !(srcRValue instanceof IArrayType)) {
            IType unqualifiedSrcRValue = SemanticUtil.getNestedType(srcRValue, 15);
            if (unqualifiedSrcRValue instanceof ICPPClassType) {
                if (!Conversions.isCompleteType(unqualifiedSrcRValue)) {
                    cost.setRank(Cost.Rank.NO_MATCH);
                    return true;
                }
                source = srcRValue;
            } else {
                source = unqualifiedSrcRValue;
            }
            cost.setRank(Cost.Rank.LVALUE_TRANSFORMATION);
            isConverted = true;
        }
        if (!isConverted && srcRValue instanceof IArrayType) {
            IASTLiteralExpression lit;
            IASTExpression val;
            IType tmp;
            IType targetPtrTgt2;
            IArrayType arrayType = (IArrayType)srcRValue;
            if (target instanceof IPointerType && (!((targetPtrTgt2 = SemanticUtil.getNestedType(((IPointerType)target).getType(), 1)) instanceof IQualifierType) || !((IQualifierType)targetPtrTgt2).isConst()) && (tmp = arrayType.getType()) instanceof IQualifierType && ((IQualifierType)tmp).isConst() && (tmp = ((IQualifierType)tmp).getType()) instanceof CPPBasicType && (val = ((CPPBasicType)tmp).getCreatedFromExpression()) instanceof IASTLiteralExpression && (lit = (IASTLiteralExpression)val).getKind() == 3) {
                source = new CPPPointerType(tmp, false, false);
                cost.setQualificationAdjustment(Conversions.getCVQualifier(targetPtrTgt2) | 1);
                cost.setRank(Cost.Rank.LVALUE_TRANSFORMATION);
                isConverted = true;
            }
            if (!isConverted && (target instanceof IPointerType || target instanceof IBasicType)) {
                source = new CPPPointerType(SemanticUtil.getNestedType(arrayType.getType(), 1));
                cost.setRank(Cost.Rank.LVALUE_TRANSFORMATION);
                isConverted = true;
            }
        }
        if (!isConverted && target instanceof IPointerType && (targetPtrTgt = SemanticUtil.getNestedType(((IPointerType)target).getType(), 1)) instanceof IFunctionType && srcRValue instanceof IFunctionType) {
            source = new CPPPointerType(source);
            cost.setRank(Cost.Rank.LVALUE_TRANSFORMATION);
            isConverted = true;
        }
        if (!((unqualifiedTarget = SemanticUtil.getNestedType(target, 15)) instanceof ICPPClassType) && !((unqualifiedSource = SemanticUtil.getNestedType(source, 15)) instanceof ICPPClassType)) {
            source = unqualifiedSource;
            target = unqualifiedTarget;
        }
        if (source != null && target != null) {
            cost.source = source;
            cost.target = target;
            return source.isSameType(target);
        }
        cost.setRank(Cost.Rank.NO_MATCH);
        return true;
    }

    private static final boolean qualificationConversion(Cost cost) throws DOMException {
        int cmp;
        IType s = cost.source;
        IType t = cost.target;
        boolean constInEveryCV2k = true;
        boolean firstPointer = true;
        int adjustments = 0;
        while (true) {
            s = SemanticUtil.getNestedType(s, 3);
            t = SemanticUtil.getNestedType(t, 3);
            if (!(s instanceof IPointerType) || !(t instanceof IPointerType)) break;
            adjustments <<= 2;
            cmp = Conversions.compareQualifications(t, s);
            if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
                return false;
            }
            boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
            boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
            if (sIsPtrToMember != tIsPtrToMember) {
                return false;
            }
            if (sIsPtrToMember) {
                IType sMemberOf = ((ICPPPointerToMemberType)s).getMemberOfClass();
                IType tMemberOf = ((ICPPPointerToMemberType)t).getMemberOfClass();
                if (sMemberOf == null || tMemberOf == null || !sMemberOf.isSameType(tMemberOf)) {
                    return false;
                }
            }
            IPointerType tPtr = (IPointerType)t;
            IPointerType sPtr = (IPointerType)s;
            constInEveryCV2k &= firstPointer || tPtr.isConst();
            s = sPtr.getType();
            t = tPtr.getType();
            firstPointer = false;
            adjustments |= cmp;
        }
        if (s instanceof IQualifierType || t instanceof IQualifierType) {
            adjustments <<= 2;
            cmp = Conversions.compareQualifications(t, s);
            if (cmp < 0 || cmp > 0 && !constInEveryCV2k) {
                return false;
            }
            adjustments |= cmp;
            s = SemanticUtil.getNestedType(s, 7);
            t = SemanticUtil.getNestedType(t, 7);
        }
        if (adjustments > 0) {
            cost.setQualificationAdjustment(adjustments);
        }
        return s != null && t != null && s.isSameType(t);
    }

    private static final boolean promotion(Cost cost) throws DOMException {
        boolean canPromote;
        block11: {
            int tType;
            IType trg;
            IType src;
            block12: {
                int sType;
                block13: {
                    src = cost.source;
                    trg = cost.target;
                    canPromote = false;
                    if (!(trg instanceof IBasicType)) break block11;
                    IBasicType basicTgt = (IBasicType)trg;
                    tType = basicTgt.getType();
                    if (!(src instanceof IBasicType)) break block12;
                    IBasicType basicSrc = (IBasicType)src;
                    sType = basicSrc.getType();
                    if (tType != 3) break block13;
                    switch (sType) {
                        case 3: {
                            if (basicSrc.isShort()) {
                                canPromote = true;
                                break;
                            }
                            break block11;
                        }
                        case 0: 
                        case 2: 
                        case 6: 
                        case 7: {
                            canPromote = true;
                        }
                    }
                    break block11;
                }
                if (tType == 5 && sType == 4) {
                    canPromote = true;
                }
                break block11;
            }
            if (src instanceof IEnumeration && (tType == 3 || tType == 0)) {
                if (trg instanceof ICPPBasicType) {
                    int qualifiers = Conversions.getEnumIntType((IEnumeration)src);
                    if (qualifiers == ((ICPPBasicType)trg).getQualifierBits()) {
                        canPromote = true;
                    }
                } else {
                    canPromote = true;
                }
            }
        }
        if (canPromote) {
            cost.setRank(Cost.Rank.PROMOTION);
            return true;
        }
        return false;
    }

    private static final boolean conversion(Cost cost, boolean forImplicitThis) throws DOMException {
        IType s = cost.source;
        IType t = cost.target;
        if (t instanceof IBasicType) {
            if (s instanceof IBasicType || s instanceof IEnumeration) {
                cost.setRank(Cost.Rank.CONVERSION);
                return true;
            }
            int tgtType = ((IBasicType)t).getType();
            if (tgtType == 6 && s instanceof IPointerType) {
                cost.setRank(Cost.Rank.CONVERSION_PTR_BOOL);
                return true;
            }
        }
        if (t instanceof IPointerType) {
            IPointerType tgtPtr = (IPointerType)t;
            if (s instanceof CPPBasicType) {
                Long val;
                IASTExpression exp = ((CPPBasicType)s).getCreatedFromExpression();
                if (exp != null && (val = Value.create(exp, 25).numericalValue()) != null && val == 0L) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    return true;
                }
                return false;
            }
            if (s instanceof IPointerType) {
                IPointerType srcPtr = (IPointerType)s;
                IType tgtPtrTgt = SemanticUtil.getNestedType(tgtPtr.getType(), 7);
                if (tgtPtrTgt instanceof IBasicType && ((IBasicType)tgtPtrTgt).getType() == 1) {
                    cost.setRank(Cost.Rank.CONVERSION);
                    cost.setInheritanceDistance(Short.MAX_VALUE);
                    int cv = Conversions.getCVQualifier(srcPtr.getType());
                    cost.source = new CPPPointerType(SemanticUtil.addQualifiers(CPPSemantics.VOID_TYPE, (cv & 1) != 0, (cv & 2) != 0));
                    return false;
                }
                boolean tIsPtrToMember = t instanceof ICPPPointerToMemberType;
                boolean sIsPtrToMember = s instanceof ICPPPointerToMemberType;
                if (!tIsPtrToMember && !sIsPtrToMember) {
                    IType srcPtrTgt = SemanticUtil.getNestedType(srcPtr.getType(), 7);
                    if (tgtPtrTgt instanceof ICPPClassType && srcPtrTgt instanceof ICPPClassType) {
                        int depth = Conversions.calculateInheritanceDepth(10, srcPtrTgt, tgtPtrTgt);
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            int cv;
                            if (!forImplicitThis) {
                                cost.setRank(Cost.Rank.CONVERSION);
                                cost.setInheritanceDistance(depth);
                            }
                            cost.source = new CPPPointerType(SemanticUtil.addQualifiers(tgtPtrTgt, ((cv = Conversions.getCVQualifier(srcPtr.getType())) & 1) != 0, (cv & 2) != 0));
                        }
                        return false;
                    }
                } else if (tIsPtrToMember && sIsPtrToMember) {
                    ICPPPointerToMemberType spm = (ICPPPointerToMemberType)s;
                    ICPPPointerToMemberType tpm = (ICPPPointerToMemberType)t;
                    IType st = spm.getType();
                    IType tt = tpm.getType();
                    if (st != null && tt != null && st.isSameType(tt)) {
                        int depth = Conversions.calculateInheritanceDepth(10, tpm.getMemberOfClass(), spm.getMemberOfClass());
                        if (depth == -1) {
                            cost.setRank(Cost.Rank.NO_MATCH);
                            return true;
                        }
                        if (depth > 0) {
                            cost.setRank(Cost.Rank.CONVERSION);
                            cost.setInheritanceDistance(depth);
                            cost.source = new CPPPointerToMemberType(spm.getType(), tpm.getMemberOfClass(), spm.isConst(), spm.isVolatile());
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private static final boolean isCompleteType(IType type) {
        if ((type = SemanticUtil.getUltimateType(type, false)) instanceof ICPPTemplateInstance) {
            return true;
        }
        if (type instanceof ICPPClassType) {
            if (type instanceof IIndexFragmentBinding) {
                try {
                    return ((IIndexFragmentBinding)((Object)type)).hasDefinition();
                }
                catch (CoreException e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
            try {
                return ((ICPPClassType)type).getCompositeScope() != null;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return true;
    }

    private static int getEnumIntType(IEnumeration enumeration) {
        long minValue = 0L;
        long maxValue = 0L;
        try {
            IEnumerator[] enumerators;
            IEnumerator[] iEnumeratorArray = enumerators = enumeration.getEnumerators();
            int n = enumerators.length;
            int n2 = 0;
            while (n2 < n) {
                Long val;
                IEnumerator enumerator = iEnumeratorArray[n2];
                IValue value = enumerator.getValue();
                if (value != null && (val = value.numericalValue()) != null) {
                    long v = val;
                    if (minValue > v) {
                        minValue = v;
                    }
                    if (maxValue < v) {
                        maxValue = v;
                    }
                }
                ++n2;
            }
        }
        catch (DOMException dOMException) {
            return 0;
        }
        if (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE) {
            return 0;
        }
        if (minValue >= 0L && maxValue <= 0xFFFFFFFFL) {
            return 8;
        }
        if (minValue >= Long.MIN_VALUE && maxValue <= Long.MAX_VALUE) {
            return 1;
        }
        return 9;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UDCMode {
        allowUDC,
        noUDC,
        deferUDC;

    }
}

