/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public abstract class ASTAmbiguousNode
extends ASTNode {
    public abstract IASTNode[] getNodes();

    public final boolean accept(ASTVisitor visitor) {
        return !visitor.shouldVisitAmbiguousNodes || visitor.visit(this) != 2;
    }

    protected void beforeResolution() {
    }

    protected void afterResolution(ASTVisitor resolver, IASTNode best) {
    }

    public IASTNode resolveAmbiguity(ASTVisitor resolver) {
        this.beforeResolution();
        IASTAmbiguityParent owner = (IASTAmbiguityParent)((Object)this.getParent());
        IASTNode nodeToReplace = this;
        IASTNode[] alternatives = this.getNodes();
        IASTNode bestAlternative = null;
        int minIssues = Integer.MAX_VALUE;
        IASTNode[] iASTNodeArray = alternatives;
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode alternative = iASTNodeArray[n2];
            owner.replace(nodeToReplace, alternative);
            nodeToReplace = alternative;
            alternative.accept(resolver);
            NameCollector nameCollector = new NameCollector();
            alternative.accept(nameCollector);
            IASTName[] names = nameCollector.getNames();
            int issues = 0;
            IASTName[] iASTNameArray = names;
            int n3 = names.length;
            int n4 = 0;
            while (n4 < n3) {
                block7: {
                    IASTName name = iASTNameArray[n4];
                    try {
                        IASTNode parent;
                        if (name.getPropertyInParent() == IASTDeclarator.DECLARATOR_NAME && (parent = name.getParent()) instanceof IASTDeclarator && (parent = ASTQueries.findOutermostDeclarator((IASTDeclarator)parent)).getPropertyInParent() == IASTParameterDeclaration.DECLARATOR) break block7;
                        IBinding b = name.resolvePreBinding();
                        if (b instanceof IProblemBinding) {
                            ++issues;
                        }
                    }
                    catch (Exception exception) {
                        ++issues;
                    }
                    if (issues == minIssues) break;
                }
                ++n4;
            }
            if (issues < minIssues) {
                minIssues = issues;
                bestAlternative = alternative;
                if (issues == 0) break;
            }
            ++n2;
        }
        if (nodeToReplace != bestAlternative) {
            owner.replace(nodeToReplace, bestAlternative);
        }
        this.afterResolution(resolver, bestAlternative);
        return bestAlternative;
    }

    public static class NameCollector
    extends ASTVisitor {
        private IASTName[] names = new IASTName[2];
        private int namesPos = -1;

        public NameCollector() {
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            if (name != null) {
                ++this.namesPos;
                this.names = (IASTName[])ArrayUtil.append(IASTName.class, this.names, name);
            }
            return 3;
        }

        public IASTName[] getNames() {
            this.names = (IASTName[])ArrayUtil.removeNullsAfter(IASTName.class, this.names, this.namesPos);
            return this.names;
        }
    }
}

