/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;

class FunctionStyleMacro
extends ObjectStyleMacro {
    public static final int NO_VAARGS = 0;
    public static final int VAARGS = 1;
    public static final int NAMED_VAARGS = 2;
    private final char[][] fParamList;
    private final int fHasVarArgs;
    private char[] fSignature;

    public FunctionStyleMacro(char[] name, char[][] paramList, int hasVarArgs, char[] expansion) {
        super(name, expansion);
        this.fParamList = paramList;
        this.fHasVarArgs = hasVarArgs;
    }

    public FunctionStyleMacro(char[] name, char[][] paramList, int hasVarArgs, int expansionFileOffset, int endFileOffset, TokenList expansion, char[] source) {
        super(name, expansionFileOffset, endFileOffset, expansion, source);
        this.fParamList = paramList;
        this.fHasVarArgs = hasVarArgs;
    }

    public char[][] getParameterList() {
        int length = this.fParamList.length;
        if (this.fHasVarArgs == 0 || length == 0) {
            return this.fParamList;
        }
        char[][] result = new char[length][];
        System.arraycopy(this.fParamList, 0, result, 0, length - 1);
        if (this.fHasVarArgs == 1) {
            result[length - 1] = Keywords.cpELLIPSIS;
        } else {
            char[] param = this.fParamList[length - 1];
            int plen = param.length;
            int elen = Keywords.cpELLIPSIS.length;
            char[] rp = new char[plen + elen];
            System.arraycopy(param, 0, rp, 0, plen);
            System.arraycopy(Keywords.cpELLIPSIS, 0, rp, plen, elen);
            result[length - 1] = rp;
        }
        return result;
    }

    public char[][] getParameterPlaceholderList() {
        return this.fParamList;
    }

    public char[] getSignature() {
        if (this.fSignature != null) {
            return this.fSignature;
        }
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        result.append('(');
        int lastIdx = this.fParamList.length - 1;
        if (lastIdx >= 0) {
            int i = 0;
            while (i < lastIdx) {
                result.append(this.fParamList[i]);
                result.append(',');
                ++i;
            }
            switch (this.fHasVarArgs) {
                case 1: {
                    result.append(Keywords.cpELLIPSIS);
                    break;
                }
                case 2: {
                    result.append(this.fParamList[lastIdx]);
                    result.append(Keywords.cpELLIPSIS);
                    break;
                }
                default: {
                    result.append(this.fParamList[lastIdx]);
                }
            }
        }
        result.append(')');
        int len = result.length();
        char[] sig = new char[len];
        result.getChars(0, len, sig, 0);
        this.fSignature = sig;
        return sig;
    }

    int hasVarArgs() {
        return this.fHasVarArgs;
    }

    public boolean isFunctionStyle() {
        return true;
    }
}

