/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.analysis.types.TypeProcessor;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedType
extends Type {
    private String name;

    public DerivedType(String name) {
        this.name = name.toLowerCase();
    }

    @Override
    public String toString() {
        return "type(" + this.name + ")";
    }

    @Override
    public <T> T processUsing(TypeProcessor<T> p) {
        return p.ifDerivedType(this.name, this);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DerivedType && ((DerivedType)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static String getStaticThreeLetterTypeSerializationCode() {
        return "dtv";
    }

    @Override
    public String getThreeLetterTypeSerializationCode() {
        return "dtv";
    }

    @Override
    void finishWriteTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.name, out);
    }

    public static Type finishReadFrom(InputStream in) throws IOException {
        String name = (String)PhotranVPGSerializer.deserialize(in);
        return new DerivedType(name);
    }
}

