/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.photran.internal.core.lexer.ASTTokenFactory;
import org.eclipse.photran.internal.core.lexer.FixedFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.LexerPhase3;
import org.eclipse.photran.internal.core.lexer.TokenFactory;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.PreprocessingFreeFormLexerPhase1;

public abstract class SourceForm {
    public static final SourceForm UNPREPROCESSED_FREE_FORM = new SourceForm(){

        public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
            return new LexerPhase3((ILexer)new FreeFormLexerPhase2((ILexer)new FreeFormLexerPhase1(in, file, filename, (TokenFactory)ASTTokenFactory.getInstance(), accumulateWhitetext)));
        }
    };
    public static final SourceForm FIXED_FORM = new SourceForm(){

        public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
            return new LexerPhase3((ILexer)new FixedFormLexerPhase2(in, file, filename, (TokenFactory)ASTTokenFactory.getInstance()));
        }
    };
    public static final SourceForm AUTO_DETECT_SOURCE_FORM = UNPREPROCESSED_FREE_FORM;
    public static final String SOURCE_FORM_EXTENSION_POINT_ID = "org.eclipse.photran.core.vpg.sourceform";

    protected SourceForm() {
    }

    public abstract IAccumulatingLexer createLexer(InputStream var1, IFile var2, String var3, boolean var4) throws IOException;

    public static SourceForm preprocessedFreeForm(final IncludeLoaderCallback callback) {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(SOURCE_FORM_EXTENSION_POINT_ID);
        if (configs.length > 0) {
            int index = SourceForm.findPreferredSourceForm(configs);
            try {
                return (SourceForm)configs[index].createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return new SourceForm(){

            public IAccumulatingLexer createLexer(InputStream in, IFile file, String filename, boolean accumulateWhitetext) throws IOException {
                return new LexerPhase3((ILexer)new FreeFormLexerPhase2((ILexer)new PreprocessingFreeFormLexerPhase1(in, file, filename, callback, accumulateWhitetext)));
            }
        };
    }

    private static int findPreferredSourceForm(IConfigurationElement[] configs) {
        return 0;
    }
}

