/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring.infrastructure;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.refactoring.infrastructure.AbstractFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.refactorings.IEditorRefactoring;

public abstract class SingleFileFortranRefactoring
extends AbstractFortranRefactoring
implements IEditorRefactoring {
    protected IFile fileInEditor = null;
    protected ITextSelection selectedRegionInEditor = null;
    protected IFortranAST astOfFileInEditor = null;
    protected final boolean inFixedFormEditor = false;

    public void initialize(IFile file, ITextSelection selection) {
        assert (file != null && file.isAccessible());
        assert (selection != null);
        this.vpg = PhotranVPG.getInstance();
        this.fileInEditor = file;
        this.selectedRegionInEditor = selection;
    }

    public void initialize(IFile file) {
        assert (file != null && file.isAccessible());
        this.vpg = PhotranVPG.getInstance();
        this.fileInEditor = file;
    }

    protected RefactoringStatus getAbstractSyntaxTree(RefactoringStatus status) {
        if (this.fileInEditor != null) {
            this.astOfFileInEditor = this.vpg.acquireTransientAST(this.fileInEditor);
            this.logVPGErrors(status);
            if (this.astOfFileInEditor == null) {
                status.addFatalError("The file in the editor cannot be parsed.");
                return status;
            }
        }
        return status;
    }

    protected void ensureProjectHasRefactoringEnabled(RefactoringStatus status) throws AbstractFortranRefactoring.PreconditionFailure {
        if (!PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(this.fileInEditor)) {
            this.fail("Please enable analysis and refactoring in the project properties.");
        }
    }
}

