/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteProcessBuilder
implements IRemoteProcessBuilder {
    private List<String> commandArgs;
    private IRemoteConnection remoteConnection;
    private IFileStore remoteDir = null;
    private boolean redirectErrorStream = false;

    public AbstractRemoteProcessBuilder(IRemoteConnection conn, List<String> command) {
        this.remoteConnection = conn;
        this.commandArgs = command;
    }

    public AbstractRemoteProcessBuilder(IRemoteConnection conn, String ... command) {
        this(conn, Arrays.asList(command));
    }

    @Override
    public IRemoteConnection connection() {
        return this.remoteConnection;
    }

    @Override
    public IRemoteProcessBuilder connection(IRemoteConnection conn) {
        this.remoteConnection = conn;
        return this;
    }

    @Override
    public List<String> command() {
        return this.commandArgs;
    }

    @Override
    public IRemoteProcessBuilder command(List<String> command) {
        this.commandArgs = command;
        return this;
    }

    @Override
    public IRemoteProcessBuilder command(String ... command) {
        this.commandArgs = Arrays.asList(command);
        return this;
    }

    @Override
    public IFileStore directory() {
        return this.remoteDir;
    }

    @Override
    public IRemoteProcessBuilder directory(IFileStore directory) {
        this.remoteDir = directory;
        return this;
    }

    @Override
    public abstract Map<String, String> environment();

    @Override
    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    @Override
    public IRemoteProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    @Override
    public abstract IRemoteProcess start() throws IOException;
}

