/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.internal.core.LocalProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProcessBuilder
extends AbstractRemoteProcessBuilder {
    private ProcessFactory localProcessBuilder;
    private Map<String, String> remoteEnv = new HashMap<String, String>();

    public LocalProcessBuilder(IRemoteConnection conn, List<String> command) {
        super(conn, command);
        this.remoteEnv.putAll(System.getenv());
        this.localProcessBuilder = ProcessFactory.getFactory();
    }

    public LocalProcessBuilder(IRemoteConnection conn, String ... command) {
        this(conn, Arrays.asList(command));
    }

    @Override
    public Map<String, String> environment() {
        return this.remoteEnv;
    }

    @Override
    public IRemoteProcess start() throws IOException {
        Process localProc;
        String[] commandArray = this.command().toArray(new String[0]);
        String[] environmentArray = new String[this.environment().size()];
        int index = 0;
        for (Map.Entry<String, String> entry : this.environment().entrySet()) {
            environmentArray[index++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        if (this.directory() != null) {
            try {
                localProc = this.localProcessBuilder.exec(commandArray, environmentArray, this.directory().toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            localProc = this.localProcessBuilder.exec(commandArray, environmentArray);
        }
        return new LocalProcess(localProc, this.redirectErrorStream());
    }
}

