/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.photran.internal.ui.editor.AbstractFortranEditor;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.FortranEditorTasks;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorASTTask;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class OpenDeclaration
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        AbstractFortranEditor editor = this.getFortranEditor();
        Shell shell = editor.getShell();
        if (PhotranVPG.getInstance().doesProjectHaveRefactoringEnabled(editor.getIFile())) {
            TextSelection selection = (TextSelection)editor.getSelection();
            IWorkbenchPage page = editor.getEditorSite().getPage();
            FortranEditorTasks tasks = FortranEditorTasks.instance(editor);
            tasks.addASTTask(new OpenDeclarationASTTask(editor, selection, shell, page));
            tasks.getRunner().runTasks(false);
        } else {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please enable analysis and refactoring in the project properties.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpenDeclarationASTTask
    implements IFortranEditorASTTask {
        private AbstractFortranEditor editor;
        private TextSelection selection;
        private Shell shell;
        private IWorkbenchPage page;

        public OpenDeclarationASTTask(AbstractFortranEditor editor, TextSelection selection, Shell shell, IWorkbenchPage page) {
            this.editor = editor;
            this.selection = selection;
            this.shell = shell;
            this.page = page;
        }

        @Override
        public boolean handle(ASTExecutableProgramNode ast, TokenList tokenList, DefinitionMap<Definition> defMap) {
            if (defMap == null) {
                return true;
            }
            final Definition def = defMap.lookup(this.selection, tokenList);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (def == null) {
                        MessageDialog.openError((Shell)OpenDeclarationASTTask.this.shell, (String)"Error", (String)"Unable to locate declaration");
                    } else {
                        OpenDeclarationASTTask.this.openEditorOn(def);
                    }
                }
            });
            return false;
        }

        private void openEditorOn(Definition def) {
            if (def == null) {
                return;
            }
            try {
                IMarker marker = def.createMarker();
                if (marker == null) {
                    return;
                }
                if (marker == null) {
                    MessageDialog.openError((Shell)this.shell, (String)"Error", (String)"Unable to create marker");
                } else {
                    IDE.openEditor((IWorkbenchPage)this.page, (IMarker)marker, (boolean)true);
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                MessageDialog.openError((Shell)this.shell, (String)"Error", (String)message);
            }
        }
    }
}

