/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.eclipse.ptp.remotetools.core.IRemoteFileEnumeration;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;
import org.eclipse.ptp.remotetools.internal.ssh.RemoteFileEnumeration;

public class RemoteFileRecursiveEnumeration
implements IRemoteFileEnumeration {
    Stack<String> directories;
    RemoteFileEnumeration currentItems;
    FileTools fileTools;
    LinkedList<Exception> currentExceptions = new LinkedList();
    IRemoteItem nextRemoteItem;

    public RemoteFileRecursiveEnumeration(FileTools fileTools, String root) throws RemoteOperationException, RemoteConnectionException, CancelException {
        this.fileTools = fileTools;
        this.directories = new Stack();
        this.directories.add(root);
        this.prefetchNextRemoteItem();
    }

    private void prefetchNextRemoteItem() {
        if (this.directories == null) {
            this.nextRemoteItem = null;
            return;
        }
        this.nextRemoteItem = null;
        while (this.currentItems == null || !this.currentItems.hasMoreElements()) {
            if (this.directories.empty()) {
                return;
            }
            String root = this.directories.pop();
            try {
                this.currentItems = new RemoteFileEnumeration(this.fileTools, root);
            }
            catch (CancelException e) {
                this.currentExceptions.clear();
                this.currentExceptions.addLast(e);
                return;
            }
            catch (RemoteConnectionException e) {
                this.currentExceptions.clear();
                this.currentExceptions.addLast(e);
                return;
            }
            catch (RemoteOperationException e) {
                this.currentExceptions.addLast(e);
            }
        }
        IRemoteItem item = this.currentItems.nextElementAsItem();
        if (item.isDirectory()) {
            this.directories.add(item.getPath());
        }
        this.nextRemoteItem = item;
    }

    public boolean hasMoreElements() {
        return this.nextRemoteItem != null;
    }

    public Exception nextException() {
        if (this.currentExceptions.size() == 0) {
            return null;
        }
        return this.currentExceptions.removeFirst();
    }

    public boolean hasMoreExceptions() {
        return this.currentExceptions.size() > 0;
    }

    public IRemoteItem nextElementAsItem() {
        if (this.nextRemoteItem == null) {
            throw new NoSuchElementException();
        }
        IRemoteItem returnItem = this.nextRemoteItem;
        this.prefetchNextRemoteItem();
        return returnItem;
    }

    public Object nextElement() {
        return this.nextElementAsItem();
    }
}

