/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.util.List;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remote.rse.core.RSEAdapterCorePlugin;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.remote.rse.core.RSEFileManager;
import org.eclipse.ptp.remote.rse.core.RSEProcessBuilder;
import org.eclipse.ptp.remote.rse.core.messages.Messages;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEServices
implements IRemoteServices {
    private ISystemRegistry registry = null;
    private IRemoteConnectionManager connMgr = null;
    private final IRemoteServicesDescriptor fDescriptor;

    public RSEServices(IRemoteServicesDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public String getId() {
        return this.fDescriptor.getId();
    }

    public String getName() {
        return this.fDescriptor.getName();
    }

    public String getScheme() {
        return this.fDescriptor.getScheme();
    }

    public IRemoteConnectionManager getConnectionManager() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.connMgr == null) {
            this.connMgr = new RSEConnectionManager(this.registry);
        }
        return this.connMgr;
    }

    public String getDirectorySeparator(IRemoteConnection conn) {
        if (!(conn instanceof RSEConnection)) {
            return null;
        }
        RSEConnection rseConnection = (RSEConnection)conn;
        IRSESystemType systemType = rseConnection.getHost().getSystemType();
        if (systemType.isWindows()) {
            return "\\";
        }
        return "/";
    }

    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        if (!this.isInitialized()) {
            return null;
        }
        if (!(conn instanceof RSEConnection)) {
            return null;
        }
        return new RSEFileManager((RSEConnection)conn);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        if (!this.isInitialized()) {
            return null;
        }
        return new RSEProcessBuilder(conn, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        if (!this.isInitialized()) {
            return null;
        }
        return new RSEProcessBuilder(conn, command);
    }

    public void initialize() {
        if (this.registry == null) {
            try {
                RSECorePlugin.waitForInitCompletion();
            }
            catch (InterruptedException e) {
                RSEAdapterCorePlugin.log(e);
            }
            if (RSECorePlugin.isTheSystemRegistryActive()) {
                this.registry = RSECorePlugin.getTheSystemRegistry();
            } else {
                RSEAdapterCorePlugin.log(Messages.RSEServices_0);
            }
        }
    }

    public boolean isInitialized() {
        this.initialize();
        return this.registry != null;
    }
}

