/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.ICallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.RemoteCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.includebrowser.RemoteIncludeBrowserService;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.model.IModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.model.RemoteModelBuilderService;
import org.eclipse.ptp.internal.rdt.core.navigation.INavigationService;
import org.eclipse.ptp.internal.rdt.core.navigation.RemoteNavigationService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.RemoteTypeHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.contentassist.RemoteContentAssistService;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchService;
import org.eclipse.ptp.rdt.core.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.rdt.ui.subsystems.RemoteCIndexSubsystem2;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.services.core.ServiceProvider;

public class RemoteCIndexServiceProvider2
extends ServiceProvider
implements IIndexServiceProvider2 {
    protected boolean fIsConfigured;
    protected IIndexLifecycleService fIndexLifecycleService;
    protected INavigationService fNavigationService;
    protected ICallHierarchyService fCallHierarchyService;
    protected ITypeHierarchyService fTypeHierarchyService;
    protected IIncludeBrowserService fIncludeBrowserService;
    protected IModelBuilderService fModelBuilderService;
    protected RemoteSearchService fSearchService;
    protected IContentAssistService fContentAssistService;
    protected RemoteCIndexSubsystem2 fSubsystem = null;
    protected String indexLocation;
    public static final String ID = "org.eclipse.ptp.rdt.ui.RemoteCIndexServiceProvider2";
    public static final String NAME = Messages.RemoteCIndexServiceProvider_0;
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.CIndexingService";
    private static final String SERVICE_ID_KEY = "service-name";
    private static final String CONNECTION_NAME_KEY = "connection-name";
    private static final String INDEX_LOCATION_KEY = "index-location";
    private static final String DSTORE_LOCATION_KEY = "dstore-location";
    private static final String DSTORE_COMMAND_KEY = "dstore-command";
    private static final String DSTORE_ENV_KEY = "dstore-env";

    public synchronized ICallHierarchyService getCallHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fCallHierarchyService == null) {
            this.fCallHierarchyService = new RemoteCallHierarchyService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fCallHierarchyService;
    }

    public String getConnectionName() {
        return this.getString(CONNECTION_NAME_KEY, null);
    }

    public IContentAssistService getContentAssistService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fContentAssistService == null) {
            this.fContentAssistService = new RemoteContentAssistService(this.fSubsystem);
        }
        return this.fContentAssistService;
    }

    public String getDStoreEnv() {
        this.initialize();
        return this.getString(DSTORE_ENV_KEY, "");
    }

    public String getDStoreCommand() {
        this.initialize();
        return this.getString(DSTORE_COMMAND_KEY, "");
    }

    public String getDStoreLocation() {
        this.initialize();
        return this.getString(DSTORE_LOCATION_KEY, "");
    }

    public synchronized IIncludeBrowserService getIncludeBrowserService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIncludeBrowserService == null) {
            this.fIncludeBrowserService = new RemoteIncludeBrowserService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fIncludeBrowserService;
    }

    public synchronized IIndexLifecycleService getIndexLifeCycleService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fIndexLifecycleService == null) {
            this.fIndexLifecycleService = new RemoteIndexLifecycleService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fIndexLifecycleService;
    }

    public String getIndexLocation() {
        this.initialize();
        return this.getString(INDEX_LOCATION_KEY, "");
    }

    public synchronized IModelBuilderService getModelBuilderService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fModelBuilderService == null) {
            this.fModelBuilderService = new RemoteModelBuilderService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fModelBuilderService;
    }

    public synchronized INavigationService getNavigationService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fNavigationService == null) {
            this.fNavigationService = new RemoteNavigationService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fNavigationService;
    }

    public IRemoteConnection getRemoteConnection() {
        if (!this.isConfigured()) {
            return null;
        }
        return this.getRemoteServices().getConnectionManager().getConnection(this.getConnectionName());
    }

    public IRemoteServices getRemoteServices() {
        if (!this.isConfigured()) {
            return null;
        }
        return PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getServiceId());
    }

    public ISearchService getSearchService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fSearchService == null) {
            this.fSearchService = new RemoteSearchService(this.fSubsystem);
        }
        return this.fSearchService;
    }

    public String getServiceId() {
        return this.getString(SERVICE_ID_KEY, null);
    }

    public synchronized ITypeHierarchyService getTypeHierarchyService() {
        if (!this.isConfigured()) {
            return null;
        }
        if (this.fTypeHierarchyService == null) {
            this.fTypeHierarchyService = new RemoteTypeHierarchyService((ICIndexSubsystem)this.fSubsystem);
        }
        return this.fTypeHierarchyService;
    }

    public boolean isConfigured() {
        this.initialize();
        return this.fIsConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this.fIsConfigured = isConfigured;
    }

    public void setConnection(IRemoteServices services, IRemoteConnection connection) {
        this.setConnection(services, connection, true);
    }

    public void setConnectionName(String connectionName) {
        this.putString(CONNECTION_NAME_KEY, connectionName);
    }

    public void setDStoreEnv(String env) {
        this.putString(DSTORE_ENV_KEY, env);
    }

    public void setDStoreCommand(String command) {
        this.putString(DSTORE_COMMAND_KEY, command);
    }

    public void setDStoreLocation(String path) {
        this.putString(DSTORE_LOCATION_KEY, path);
    }

    public void setIndexLocation(String path) {
        this.putString(INDEX_LOCATION_KEY, path);
    }

    public void setServiceId(String serviceId) {
        this.putString(SERVICE_ID_KEY, serviceId);
    }

    public String toString() {
        return "RemoteCIndexServiceProvider2(" + this.getIndexLocation() + ")";
    }

    private void initialize() {
        IRemoteServices services;
        if (this.fSubsystem == null && this.getServiceId() != null && (services = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.getServiceId())) != null && this.getConnectionName() != null) {
            IRemoteConnection connection = services.getConnectionManager().getConnection(this.getConnectionName());
            this.setConnection(services, connection, false);
        }
    }

    private void setConnection(IRemoteServices services, IRemoteConnection connection, boolean reset) {
        this.setServiceId(services.getId());
        this.setConnectionName(connection.getName());
        if (reset) {
            Path workingDir = new Path(services.getFileManager(connection).getWorkingDirectory());
            this.setIndexLocation(workingDir.append(".eclipsesettings").toString());
            this.setDStoreLocation(workingDir.toString());
        }
        if (this.fSubsystem != null) {
            this.fSubsystem.dispose();
        }
        this.fSubsystem = new RemoteCIndexSubsystem2(this);
        this.setConfigured(true);
    }
}

