/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core.proxy;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.debug.client.AbstractProxyDebugClient;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugBreakpointAfterCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugCLICommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugConditionBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugDataReadMemoryCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugDataWriteMemoryCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugDeleteBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugDeletePartialExpressionCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugDisableBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugEnableBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugEvaluateExpressionCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugEvaluatePartialExpressionCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugGetTypeCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugGoCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugInterruptCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListArgumentsCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListGlobalVariablesCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListInfoThreadsCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListLocalVariablesCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListSignalsCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugListStackframesCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSetCurrentStackframeCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSetFunctionBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSetLineBreakpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSetThreadSelectCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSetWatchpointCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugSignalInfoCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugStackInfoDepthCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugStartSessionCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugStepCommand;
import org.eclipse.ptp.proxy.debug.command.ProxyDebugTerminateCommand;

public class ProxyDebugClient
extends AbstractProxyDebugClient {
    public static final int STEP_INTO = 0;
    public static final int STEP_OVER = 1;
    public static final int STEP_FINISH = 2;

    public static BitList decodeBitSet(String str) {
        String[] parts = str.split(":");
        int len = Integer.parseInt(parts[0], 16);
        return new BitList(len, parts[1]);
    }

    public static String encodeBitSet(BitList set) {
        String lenStr = Integer.toHexString(set.size());
        return String.valueOf(lenStr) + ":" + set.toString();
    }

    public void debugBreakpointAfter(BitList procs, int bpid, int icount) throws IOException {
        ProxyDebugBreakpointAfterCommand cmd = new ProxyDebugBreakpointAfterCommand(ProxyDebugClient.encodeBitSet(procs), bpid, icount);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugCLIHandle(BitList procs, String arg) throws IOException {
        ProxyDebugCLICommand cmd = new ProxyDebugCLICommand(ProxyDebugClient.encodeBitSet(procs), arg);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugConditionBreakpoint(BitList procs, int bpid, String expr) throws IOException {
        ProxyDebugConditionBreakpointCommand cmd = new ProxyDebugConditionBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid, expr);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugDeleteBreakpoint(BitList procs, int bpid) throws IOException {
        ProxyDebugDeleteBreakpointCommand cmd = new ProxyDebugDeleteBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugDeletePartialExpression(BitList procs, String name) throws IOException {
        ProxyDebugDeletePartialExpressionCommand cmd = new ProxyDebugDeletePartialExpressionCommand(ProxyDebugClient.encodeBitSet(procs), name);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugDisableBreakpoint(BitList procs, int bpid) throws IOException {
        ProxyDebugDisableBreakpointCommand cmd = new ProxyDebugDisableBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugEnableBreakpoint(BitList procs, int bpid) throws IOException {
        ProxyDebugEnableBreakpointCommand cmd = new ProxyDebugEnableBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugEvaluateExpression(BitList procs, String expr) throws IOException {
        ProxyDebugEvaluateExpressionCommand cmd = new ProxyDebugEvaluateExpressionCommand(ProxyDebugClient.encodeBitSet(procs), expr);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugEvaluatePartialExpression(BitList procs, String name, String exprId, boolean listChildren, boolean express) throws IOException {
        ProxyDebugEvaluatePartialExpressionCommand cmd = new ProxyDebugEvaluatePartialExpressionCommand(ProxyDebugClient.encodeBitSet(procs), name, exprId, listChildren, express);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugGetType(BitList procs, String expr) throws IOException {
        ProxyDebugGetTypeCommand cmd = new ProxyDebugGetTypeCommand(ProxyDebugClient.encodeBitSet(procs), expr);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugGo(BitList procs) throws IOException {
        ProxyDebugGoCommand cmd = new ProxyDebugGoCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugInterrupt(BitList procs) throws IOException {
        ProxyDebugInterruptCommand cmd = new ProxyDebugInterruptCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListArguments(BitList procs, int low, int high) throws IOException {
        ProxyDebugListArgumentsCommand cmd = new ProxyDebugListArgumentsCommand(ProxyDebugClient.encodeBitSet(procs), low, high);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListGlobalVariables(BitList procs) throws IOException {
        ProxyDebugListGlobalVariablesCommand cmd = new ProxyDebugListGlobalVariablesCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListInfoThreads(BitList procs) throws IOException {
        ProxyDebugListInfoThreadsCommand cmd = new ProxyDebugListInfoThreadsCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListLocalVariables(BitList procs) throws IOException {
        ProxyDebugListLocalVariablesCommand cmd = new ProxyDebugListLocalVariablesCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListSignals(BitList procs, String name) throws IOException {
        ProxyDebugListSignalsCommand cmd = new ProxyDebugListSignalsCommand(ProxyDebugClient.encodeBitSet(procs), name);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugListStackframes(BitList procs, int low, int high) throws IOException {
        ProxyDebugListStackframesCommand cmd = new ProxyDebugListStackframesCommand(ProxyDebugClient.encodeBitSet(procs), low, high);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSetCurrentStackframe(BitList procs, int level) throws IOException {
        ProxyDebugSetCurrentStackframeCommand cmd = new ProxyDebugSetCurrentStackframeCommand(ProxyDebugClient.encodeBitSet(procs), level);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSetFuncBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, String func, String expression, int ignoreCount, int tid) throws IOException {
        ProxyDebugSetFunctionBreakpointCommand cmd = new ProxyDebugSetFunctionBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid, isTemporary, isHardware, file, func, expression, ignoreCount, tid);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSetLineBreakpoint(BitList procs, int bpid, boolean isTemporary, boolean isHardware, String file, int line, String expression, int ignoreCount, int tid) throws IOException {
        ProxyDebugSetLineBreakpointCommand cmd = new ProxyDebugSetLineBreakpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid, isTemporary, isHardware, file, line, expression, ignoreCount, tid);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSetThreadSelect(BitList procs, int threadNum) throws IOException {
        ProxyDebugSetThreadSelectCommand cmd = new ProxyDebugSetThreadSelectCommand(ProxyDebugClient.encodeBitSet(procs), threadNum);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSetWatchpoint(BitList procs, int bpid, String expression, boolean isAccess, boolean isRead, String condition, int ignoreCount) throws IOException {
        ProxyDebugSetWatchpointCommand cmd = new ProxyDebugSetWatchpointCommand(ProxyDebugClient.encodeBitSet(procs), bpid, expression, isAccess, isRead, condition, ignoreCount);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugSignalInfo(BitList procs, String arg) throws IOException {
        ProxyDebugSignalInfoCommand cmd = new ProxyDebugSignalInfoCommand(ProxyDebugClient.encodeBitSet(procs), arg);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugStackInfoDepth(BitList procs) throws IOException {
        ProxyDebugStackInfoDepthCommand cmd = new ProxyDebugStackInfoDepthCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugStartSession(String prog, String path, String dir, String[] args) throws IOException {
        ProxyDebugStartSessionCommand cmd = new ProxyDebugStartSessionCommand(prog, path, dir, args);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugStep(BitList procs, int count, int type) throws IOException {
        ProxyDebugStepCommand cmd = new ProxyDebugStepCommand(ProxyDebugClient.encodeBitSet(procs), count, type);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void debugTerminate(BitList procs) throws IOException {
        ProxyDebugTerminateCommand cmd = new ProxyDebugTerminateCommand(ProxyDebugClient.encodeBitSet(procs));
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void setDataReadMemoryCommand(BitList procs, long offset, String address, String format, int wordSize, int rows, int cols, Character asChar) throws IOException {
        ProxyDebugDataReadMemoryCommand cmd = new ProxyDebugDataReadMemoryCommand(ProxyDebugClient.encodeBitSet(procs), offset, address, format, wordSize, rows, cols, asChar);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    public void setDataWriteMemoryCommand(BitList procs, long offset, String address, String format, int wordSize, String value) throws IOException {
        ProxyDebugDataWriteMemoryCommand cmd = new ProxyDebugDataWriteMemoryCommand(ProxyDebugClient.encodeBitSet(procs), offset, address, format, wordSize, value);
        this.sendCommand((IProxyCommand)cmd);
        cmd.completed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitConnect(IProgressMonitor monitor) throws IOException {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "debug: waiting for connect");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.waitLock.lock();
        try {
            if (this.state != AbstractProxyDebugClient.DebugProxyState.CONNECTING) return true;
            while (this.state == AbstractProxyDebugClient.DebugProxyState.CONNECTING && !this.timeout && !monitor.isCanceled()) {
                this.waiting = true;
                try {
                    this.waitCondition.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    monitor.setCanceled(true);
                }
            }
            if (this.timeout) {
                throw new IOException("Timeout waiting for debugger to connect");
            }
            if (monitor.isCanceled()) {
                return false;
            }
            if (this.state == AbstractProxyDebugClient.DebugProxyState.CONNECTED) return true;
            return false;
        }
        finally {
            this.waitLock.unlock();
            monitor.done();
        }
    }
}

