/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.etfw.toolopts.ToolMaker;
import org.eclipse.ptp.etfw.toolopts.ToolPane;
import org.eclipse.ptp.etfw.ui.AbstractToolConfigurationTab;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.etfw";
    private static Activator plugin;
    private static ExternalToolProcess[] tools;
    private static ArrayList<File> workflowList;
    private static ArrayList<AbstractToolConfigurationTab> perfConfTabs;
    private static ArrayList<AbstractToolDataManager> perfConfManagers;

    static {
        tools = null;
        workflowList = null;
        perfConfTabs = null;
        perfConfManagers = null;
    }

    public static ExternalToolProcess[] getTools() {
        return tools;
    }

    public static ExternalToolProcess getTool(String toolName) {
        int i = 0;
        while (i < tools.length) {
            if (Activator.tools[i].toolName.equals(toolName)) {
                return tools[i];
            }
            ++i;
        }
        return null;
    }

    public static ExternalToolProcess getTool(int dex) {
        if (dex < tools.length) {
            return tools[dex];
        }
        return null;
    }

    private static void insertPanes(ToolPane[] panes, List<ToolPane> paneList) {
        if (panes != null && panes.length > 0) {
            int k = 0;
            while (k < panes.length) {
                if (!panes[k].virtual) {
                    paneList.add(panes[k]);
                }
                ++k;
            }
        }
    }

    private static void insertPanes(List<ToolPane> panes, List<ToolPane> paneList) {
        if (panes != null && panes.size() > 0) {
            int k = 0;
            while (k < panes.size()) {
                if (!panes.get((int)k).virtual) {
                    paneList.add(panes.get(k));
                }
                ++k;
            }
        }
    }

    public static ToolPane[] getToolPanes() {
        ArrayList<ToolPane> paneList = new ArrayList<ToolPane>();
        ToolPane[] panes = null;
        if (tools.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < tools.length) {
            int j = 0;
            while (j < Activator.tools[i].externalTools.size()) {
                int k;
                ExternalTool t = (ExternalTool)Activator.tools[i].externalTools.get(j);
                if (t instanceof BuildTool) {
                    BuildTool bt = (BuildTool)t;
                    Activator.insertPanes(bt.getAllCompilerPanes(), paneList);
                } else if (t instanceof ExecTool) {
                    ExecTool et = (ExecTool)t;
                    k = 0;
                    while (k < et.execUtils.length) {
                        Activator.insertPanes(et.execUtils[k].toolPanes, paneList);
                        ++k;
                    }
                } else if (t instanceof PostProcTool) {
                    PostProcTool pt = (PostProcTool)t;
                    k = 0;
                    while (k < pt.analysisCommands.length) {
                        Activator.insertPanes(pt.analysisCommands[k].toolPanes, paneList);
                        ++k;
                    }
                }
                if (t.global != null) {
                    Activator.insertPanes(t.global.toolPanes, paneList);
                }
                ++j;
            }
            ++i;
        }
        panes = new ToolPane[paneList.size()];
        paneList.toArray(panes);
        return panes;
    }

    private ArrayList<File> getInternalXMLWorkflows() {
        if (workflowList != null) {
            return workflowList;
        }
        workflowList = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.workflows");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    String plugspace = ext.getNamespaceIdentifier();
                    String aGetter = ce.getAttribute("XMLFile");
                    workflowList.add(new File(new URI(FileLocator.toFileURL((URL)Platform.getBundle((String)plugspace).getEntry(aGetter)).toString().replaceAll(" ", "%20"))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return workflowList;
    }

    public void refreshTools() {
        File toolxml;
        String epath;
        this.getInternalXMLWorkflows();
        ArrayList<ExternalToolProcess> theTools = new ArrayList<ExternalToolProcess>();
        String fiList = this.getPreferenceStore().getString("tool_def_xml_location");
        String[] fiLocs = fiList.split(",,,");
        ArrayList<File> files = new ArrayList<File>();
        File fi = null;
        int i = 0;
        while (i < fiLocs.length) {
            fi = new File(fiLocs[i]);
            if (fi.canRead() && fi.isFile()) {
                files.add(fi);
            }
            ++i;
        }
        if (files.size() == 0 && (epath = BuildLaunchUtils.checkToolEnvPath("eclipse")) != null && (toolxml = new File(epath)).canRead() && toolxml.exists() && (toolxml = new File(String.valueOf(toolxml.getPath()) + File.separator + "tool.xml")).canRead() && toolxml.isFile()) {
            files.add(toolxml);
            this.getPreferenceStore().setValue("tool_def_xml_location", toolxml.getPath());
        }
        i = 0;
        while (i < workflowList.size()) {
            tools = ToolMaker.makeTools((File)workflowList.get(i));
            if (tools != null) {
                int j = 0;
                while (j < tools.length) {
                    theTools.add(tools[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < files.size()) {
            try {
                tools = ToolMaker.makeTools((File)((File)files.get(i)));
            }
            catch (Exception e) {
                tools = null;
                e.printStackTrace();
                System.out.println("Problem reading " + ((File)files.get(i)).toString());
            }
            if (tools != null) {
                int j = 0;
                while (j < tools.length) {
                    theTools.add(tools[j]);
                    ++j;
                }
            }
            tools = null;
            ++i;
        }
        tools = theTools.toArray(new ExternalToolProcess[theTools.size()]);
        i = 0;
        while (i < tools.length) {
            BuildLaunchUtils.verifyEnvToolPath(tools[i]);
            ++i;
        }
    }

    public static ArrayList<AbstractToolConfigurationTab> getPerfTabs() {
        if (perfConfTabs != null) {
            return perfConfTabs;
        }
        perfConfTabs = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.configurationTabs");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractToolConfigurationTab aGetter = (AbstractToolConfigurationTab)((Object)ce.createExecutableExtension("class"));
                    perfConfTabs.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return perfConfTabs;
    }

    private ArrayList<AbstractToolDataManager> getPerfConfManagers() {
        if (perfConfManagers != null) {
            return perfConfManagers;
        }
        perfConfManagers = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.dataManagers");
        IExtension[] extensions = extensionPoint.getExtensions();
        int iext = 0;
        while (iext < extensions.length) {
            IExtension ext = extensions[iext];
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement ce = elements[i];
                try {
                    AbstractToolDataManager aGetter = (AbstractToolDataManager)ce.createExecutableExtension("class");
                    perfConfManagers.add(aGetter);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            ++iext;
        }
        return perfConfManagers;
    }

    public static AbstractToolDataManager getPerfDataManager(String name) {
        if (name == null) {
            return null;
        }
        AbstractToolDataManager check2 = null;
        for (AbstractToolDataManager check2 : perfConfManagers) {
            if (!check2.getName().equals(name)) continue;
            return check2;
        }
        return null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.refreshTools();
        Activator.getPerfTabs();
        this.getPerfConfManagers();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

