/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.slurm.ui.rmLaunchConfiguration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.slurm.core.SLURMJobAttributes;
import org.eclipse.ptp.rm.slurm.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLURMRMLaunchConfigurationDynamicTab
extends AbstractRMLaunchConfigurationDynamicTab {
    private Text numProcsText;
    private String numProcsString = "1";
    private static final String NUMBER_OF_PROCESSES_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_0;
    private Text TimeLimitText;
    private String timeLimitString = "2";
    private static final String JOB_TIME_LIMIT_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_1;
    private String partationRequestedString = "3";
    private static final String JOB_PARTATION_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_2;
    private String jobTypeComboString = "mpi";
    private static final String JOB_TYPE_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_3;
    private String jobIoString = Messages.SLURMRMLaunchConfigurationDynamicTab_4;
    private static final String JOB_IO_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_5;
    private String jobVerboseModString = Messages.SLURMRMLaunchConfigurationDynamicTab_6;
    private static final String JOB_VERBOSE_MODE_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_7;
    private String jobNodeListString = "node0,node1";
    private static final String JOB_NODE_LIST_LABEL = Messages.SLURMRMLaunchConfigurationDynamicTab_8;
    private static final String ATTR_PREFIX = "org.eclipse.ptp.rm.slurm.ui.launchAttributes";
    private static final String ATTR_NUMPROCS = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.numProcs";
    private static final String ATTR_NUMNODES = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.numNodes";
    private static final String ATTR_TIMELIMIT = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.timeLimit";
    private static final String ATTR_JOBPARTATION = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.jobpartation";
    private static final String ATTR_JOBTYPE = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.jobtype";
    private static final String ATTR_JOBIO = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.jobio";
    private static final String ATTR_JOBVERBOSEMODE = "org.eclipse.ptp.rm.slurm.ui.launchAttributes.jobverbosemode";
    private static final RMLaunchValidation success = new RMLaunchValidation(true, "");
    private Composite control;

    public SLURMRMLaunchConfigurationDynamicTab(IResourceManager rm) {
    }

    public RMLaunchValidation canSave(Control control, IResourceManager rm, IPQueue queue) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            new IntegerAttribute(numProcsAttrDef, this.numProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
            new IntegerAttribute(jobTimeLimitAttrDef, this.timeLimitString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        return new RMLaunchValidation(true, "");
    }

    public void createControl(Composite parent, IResourceManager rm, IPQueue queue) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(this.control, 2048);
        GridLayout launchConfigLayout = new GridLayout(2, true);
        launchConfigLayout.marginHeight = 0;
        launchConfigLayout.marginWidth = 0;
        launchConfigLayout.numColumns = 2;
        comp.setLayout((Layout)launchConfigLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label numberOfProcessesnLabel = new Label(comp, 0);
        numberOfProcessesnLabel.setText(NUMBER_OF_PROCESSES_LABEL);
        GridData gd_numberOfProcessesnLabel = new GridData(4, 4, true, false, 1, 1);
        gd_numberOfProcessesnLabel.minimumWidth = numberOfProcessesnLabel.computeSize((int)-1, (int)-1).x;
        numberOfProcessesnLabel.setLayoutData((Object)gd_numberOfProcessesnLabel);
        this.numProcsText = new Text(comp, 2112);
        this.numProcsText.setTextLimit(10);
        this.numProcsText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_9);
        gd = new GridData(4, 4, true, false, 1, 1);
        gd.minimumWidth = this.numProcsText.computeSize((int)-1, (int)-1).x;
        this.numProcsText.setLayoutData((Object)gd);
        this.numProcsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.numProcsString = SLURMRMLaunchConfigurationDynamicTab.this.numProcsText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
        Label timeLimitLabel = new Label(comp, 0);
        timeLimitLabel.setText(JOB_TIME_LIMIT_LABEL);
        this.TimeLimitText = new Text(comp, 2112);
        this.TimeLimitText.setTextLimit(10);
        this.TimeLimitText.setToolTipText(Messages.SLURMRMLaunchConfigurationDynamicTab_10);
        GridData gd_timeLimitText = new GridData(4, 0x1000000, true, false);
        this.TimeLimitText.setLayoutData((Object)gd_timeLimitText);
        this.TimeLimitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SLURMRMLaunchConfigurationDynamicTab.this.timeLimitString = SLURMRMLaunchConfigurationDynamicTab.this.TimeLimitText.getText();
                SLURMRMLaunchConfigurationDynamicTab.this.fireContentsChanged();
            }
        });
    }

    public IAttribute<?, ?, ?>[] getAttributes(IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration, String mode) throws CoreException {
        int numProcs = configuration.getAttribute(ATTR_NUMPROCS, -1);
        IntegerAttribute iattr = null;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            iattr = new IntegerAttribute(numProcsAttrDef, Integer.valueOf(numProcs));
        }
        catch (IllegalValueException illegalValueException) {
            return new IAttribute[0];
        }
        int jobTimeLimit = configuration.getAttribute(ATTR_TIMELIMIT, -1);
        IntegerAttribute iattr2 = null;
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
            iattr2 = new IntegerAttribute(jobTimeLimitAttrDef, Integer.valueOf(jobTimeLimit));
        }
        catch (IllegalValueException illegalValueException) {
            return new IAttribute[2];
        }
        return new IAttribute[]{iattr, iattr2};
    }

    public Control getControl() {
        return this.control;
    }

    public RMLaunchValidation initializeFrom(Control control, IResourceManager rm, IPQueue queue, ILaunchConfiguration configuration) {
        int jobTimeLimit;
        int numProcs;
        try {
            numProcs = configuration.getAttribute(ATTR_NUMPROCS, 1);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
                this.numProcsText.setText(numProcsAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        this.numProcsText.setText(Integer.toString(numProcs));
        try {
            jobTimeLimit = configuration.getAttribute(ATTR_TIMELIMIT, 1);
        }
        catch (CoreException e) {
            try {
                IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
                this.TimeLimitText.setText(jobTimeLimitAttrDef.create().getValueAsString());
            }
            catch (IllegalValueException e1) {
                return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage() + " : " + e1.getMessage());
            }
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        this.TimeLimitText.setText(Integer.toString(jobTimeLimit));
        return success;
    }

    public RMLaunchValidation isValid(ILaunchConfiguration configuration, IResourceManager rm, IPQueue queue) {
        IntegerAttribute iattr;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            iattr = new IntegerAttribute(numProcsAttrDef, this.numProcsString);
            if (iattr.getValue() < 1) {
                return new RMLaunchValidation(false, Messages.SLURMConfigurationWizardPage_numProcsInvalid);
            }
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
            iattr = new IntegerAttribute(jobTimeLimitAttrDef, this.timeLimitString);
            if (iattr.getValue() < 1) {
                return new RMLaunchValidation(false, Messages.SLURMConfigurationWizardPage_timeLimitInvalid);
            }
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        IntegerAttribute iattr = null;
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            iattr = new IntegerAttribute(numProcsAttrDef, this.numProcsString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        configuration.setAttribute(ATTR_NUMPROCS, iattr.getValue().intValue());
        IntegerAttribute iattr2 = null;
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
            iattr2 = new IntegerAttribute(jobTimeLimitAttrDef, this.timeLimitString);
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        configuration.setAttribute(ATTR_TIMELIMIT, iattr2.getValue().intValue());
        return new RMLaunchValidation(true, "");
    }

    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration, IResourceManager rm, IPQueue queue) {
        try {
            IntegerAttributeDefinition numProcsAttrDef = this.getNumProcsAttrDef(rm, queue);
            configuration.setAttribute(ATTR_NUMPROCS, numProcsAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(NUMBER_OF_PROCESSES_LABEL) + e.getMessage());
        }
        try {
            IntegerAttributeDefinition jobTimeLimitAttrDef = this.getJobTimeLimitAttrDef(rm, queue);
            configuration.setAttribute(ATTR_TIMELIMIT, jobTimeLimitAttrDef.create().getValue().intValue());
        }
        catch (IllegalValueException e) {
            return new RMLaunchValidation(false, String.valueOf(JOB_TIME_LIMIT_LABEL) + e.getMessage());
        }
        return success;
    }

    private IntegerAttributeDefinition getNumProcsAttrDef(IResourceManager rm, IPQueue queue) {
        return JobAttributes.getNumberOfProcessesAttributeDefinition();
    }

    private IntegerAttributeDefinition getJobNumNodesAttrDef(IResourceManager rm, IPQueue queue) {
        return SLURMJobAttributes.getJobNumberOfNodesAttributeDefinition();
    }

    private IntegerAttributeDefinition getJobTimeLimitAttrDef(IResourceManager rm, IPQueue queue) {
        return SLURMJobAttributes.getJobTimelimitAttributeDefinition();
    }
}

