/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.awt.geom.IllegalPathStateException;
import java.text.StringCharacterIterator;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;

public class PathTools
implements IRemotePathTools {
    private static final String rootPath = "/";
    ExecutionManager executionManager;

    public PathTools(ExecutionManager manager) {
        this.executionManager = manager;
    }

    public String rootPath() {
        return new String(rootPath);
    }

    public boolean isRoot(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        return path.equals(rootPath);
    }

    public boolean isAbsolute(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        return path.startsWith(rootPath);
    }

    public boolean isRelative(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        return !path.startsWith(rootPath);
    }

    public boolean isLeave(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        return !this.isRoot(path) && !path.endsWith(rootPath);
    }

    public String leave(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        if (this.isRoot(path)) {
            return this.rootPath();
        }
        if (this.isLeave(path)) {
            return path.substring(0, path.length() - 1);
        }
        return new String(path);
    }

    public String canonicalize(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        if (this.isRoot(path)) {
            return this.rootPath();
        }
        String[] segments = this.split(path);
        boolean absolute = this.isAbsolute(path);
        boolean leave = this.isLeave(path);
        return this.canonicalize(segments, absolute, leave);
    }

    private String canonicalize(String[] segments, boolean absolute, boolean leave) {
        int lastPosition = 0;
        int currentPosition = 0;
        int currentSize = segments.length;
        while (currentPosition < segments.length) {
            String segment = segments[currentPosition];
            if (segment.equals(".") || segment.equals("")) {
                ++currentPosition;
                continue;
            }
            if (segment.equals("..")) {
                if (lastPosition == 0) {
                    if (absolute) {
                        ++currentPosition;
                        continue;
                    }
                    if (currentPosition > lastPosition) {
                        segments[lastPosition] = segments[currentPosition];
                    }
                    ++lastPosition;
                    ++currentPosition;
                    continue;
                }
                String segment2 = segments[lastPosition - 1];
                if (segment2.equals("..")) {
                    if (currentPosition > lastPosition) {
                        segments[lastPosition] = segments[currentPosition];
                    }
                    ++lastPosition;
                    ++currentPosition;
                    continue;
                }
                --lastPosition;
                ++currentPosition;
                continue;
            }
            if (currentPosition > lastPosition) {
                segments[lastPosition] = segments[currentPosition];
            }
            ++lastPosition;
            ++currentPosition;
        }
        currentSize = lastPosition;
        return this.unsplit(segments, 0, currentSize - 1, absolute, leave);
    }

    public String join(String base, String path) {
        if (base == null) {
            throw new IllegalPathStateException();
        }
        if (path == null) {
            throw new IllegalPathStateException();
        }
        if (this.isAbsolute(path)) {
            return this.canonicalize(path);
        }
        String[] s1 = this.split(base);
        String[] s2 = this.split(path);
        String[] s = new String[s1.length + s2.length];
        System.arraycopy(s1, 0, s, 0, s1.length);
        System.arraycopy(s2, 0, s, s1.length, s2.length);
        boolean absolute = this.isAbsolute(base);
        boolean leave = this.isLeave(path);
        return this.canonicalize(s, absolute, leave);
    }

    public String parent(String path) {
        if (path == null) {
            throw new IllegalPathStateException();
        }
        if (this.isRoot(path)) {
            return this.rootPath();
        }
        return this.join(path, "..");
    }

    private String[] split(String path) {
        if (this.isRoot(path)) {
            return new String[0];
        }
        int start = 0;
        int end = path.length();
        if (this.isAbsolute(path)) {
            ++start;
        }
        if (!this.isLeave(path)) {
            --end;
        }
        return path.substring(start, end).split(rootPath);
    }

    private String unsplit(String[] segments, int start, int end, boolean absolute, boolean leave) {
        String result = null;
        int segmentCount = end - start + 1;
        if (segmentCount <= 0) {
            if (absolute) {
                return rootPath;
            }
            return "";
        }
        result = absolute ? rootPath : "";
        int i = start;
        while (i <= end) {
            if (i != start) {
                result = String.valueOf(result) + rootPath;
            }
            result = String.valueOf(result) + segments[i];
            ++i;
        }
        if (!leave && segmentCount > 0) {
            result = String.valueOf(result) + rootPath;
        }
        return result;
    }

    public String quote(String path, boolean full) {
        StringBuffer buffer = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(path);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '\n': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    if (full) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    break;
                }
                case ' ': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            c = iter.next();
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        PathTools tools = new PathTools(null);
        System.out.println(tools.rootPath());
        System.out.println();
        System.out.println(tools.isRoot(rootPath));
        System.out.println(tools.isRoot("/a"));
        System.out.println(tools.isRoot("/a/"));
        System.out.println(tools.isRoot("a"));
        System.out.println();
        System.out.println(tools.isAbsolute(rootPath));
        System.out.println(tools.isAbsolute("/a"));
        System.out.println(tools.isAbsolute("/a/"));
        System.out.println(tools.isAbsolute("a"));
        System.out.println();
        System.out.println(tools.isRelative(rootPath));
        System.out.println(tools.isRelative("/a"));
        System.out.println(tools.isRelative("/a/"));
        System.out.println(tools.isRelative("a"));
        System.out.println();
        System.out.println(tools.isLeave(rootPath));
        System.out.println(tools.isLeave("/a"));
        System.out.println(tools.isLeave("/a/"));
        System.out.println(tools.isLeave("a"));
        System.out.println();
        System.out.println(tools.parent(rootPath));
        System.out.println(tools.parent("/a"));
        System.out.println(tools.parent("/a/b"));
        System.out.println(tools.parent("/a/"));
        System.out.println(tools.parent("/a/."));
        System.out.println(tools.parent("/a/.."));
        System.out.println(tools.parent("/a//"));
        System.out.println(tools.parent("/a/b/"));
        System.out.println(tools.parent("/a/b/."));
        System.out.println(tools.parent("/a/b/.."));
        System.out.println(tools.parent("/a/b//"));
        System.out.println(tools.parent("/.."));
        System.out.println(tools.parent("/."));
        System.out.println();
        System.out.println(tools.parent(""));
        System.out.println(tools.parent("a"));
        System.out.println(tools.parent("a/b"));
        System.out.println(tools.parent(Messages.PathTools_47));
        System.out.println(tools.parent("a/."));
        System.out.println(tools.parent("a/.."));
        System.out.println(tools.parent("a//"));
        System.out.println(tools.parent("a/b/"));
        System.out.println(tools.parent("a/b/."));
        System.out.println(tools.parent("a/b/.."));
        System.out.println(tools.parent("a/b//"));
        System.out.println(tools.parent(".."));
        System.out.println(tools.parent("."));
        System.out.println();
        System.out.println(tools.join("b", "a"));
        System.out.println(tools.join("b", "/a"));
        System.out.println(tools.join("b", ".."));
        System.out.println(tools.join("b", "."));
        System.out.println(tools.join("b", ""));
        System.out.println(tools.join("b", rootPath));
        System.out.println(tools.join("b/", "a"));
        System.out.println(tools.join("b/", "/a"));
        System.out.println(tools.join("b/", ".."));
        System.out.println(tools.join("b/", "."));
        System.out.println(tools.join("b/", ""));
        System.out.println(tools.join("b/", rootPath));
        System.out.println(tools.join(".", "a"));
        System.out.println(tools.join(".", "/a"));
        System.out.println(tools.join(".", ".."));
        System.out.println(tools.join(".", "."));
        System.out.println(tools.join(".", ""));
        System.out.println(tools.join(".", rootPath));
        System.out.println(tools.join("..", "a"));
        System.out.println(tools.join("..", "/a"));
        System.out.println(tools.join("..", ".."));
        System.out.println(tools.join("..", "."));
        System.out.println(tools.join("..", ""));
        System.out.println(tools.join("..", rootPath));
        System.out.println(tools.join("", "a"));
        System.out.println(tools.join("", "/a"));
        System.out.println(tools.join("", ".."));
        System.out.println(tools.join("", "."));
        System.out.println(tools.join("", ""));
        System.out.println(tools.join("", rootPath));
    }
}

