/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.preferences;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExternalToolPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IToolLaunchConfigurationConstants {
    protected List XMLLocs = null;
    protected Button browseXMLButton = null;
    protected Button removeItemButton = null;
    protected WidgetListener listener = new WidgetListener();

    public ExternalToolPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createTauConf(composite);
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    private void createTauConf(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText("External Tool Configuration");
        Composite xmlcom = new Composite((Composite)aGroup, 0);
        xmlcom.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        xmlcom.setLayoutData((Object)this.spanGridData(768, 5));
        Label tauarchComment = new Label(xmlcom, 64);
        tauarchComment.setText("Tool Definition File:");
        this.XMLLocs = new List(xmlcom, 2560);
        this.XMLLocs.setLayoutData((Object)new GridData(768));
        this.browseXMLButton = new Button(xmlcom, 8);
        this.browseXMLButton.setText("Add");
        this.browseXMLButton.addSelectionListener((SelectionListener)this.listener);
        this.removeItemButton = new Button(xmlcom, 8);
        this.removeItemButton.setText("Remove");
        this.removeItemButton.addSelectionListener((SelectionListener)this.listener);
    }

    protected void handleRemoveItem() {
        this.XMLLocs.remove(this.XMLLocs.getSelectionIndices());
    }

    protected void handleXMLBrowseButtonSelected() {
        File test;
        FileDialog dialog = new FileDialog(this.getShell());
        File path = null;
        String correctPath = null;
        int maxXDex = this.XMLLocs.getItemCount() - 1;
        if (maxXDex >= 0) {
            correctPath = this.getFieldContent(this.XMLLocs.getItem(maxXDex));
        }
        if (correctPath != null && (path = new File(correctPath)).exists()) {
            dialog.setFilterPath(path.isFile() ? correctPath : path.getParent());
        }
        dialog.setText("Select tool definition xml file");
        String out = this.getFieldContent(dialog.open());
        if (out != null && (test = new File(out)).canRead() && test.isFile()) {
            this.XMLLocs.add(out);
        }
    }

    private void loadSaved() {
        String[] files;
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        String fiList = preferences.getString("tool_def_xml_location");
        String[] stringArray = files = fiList.split(",,,");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.XMLLocs.add(s);
            ++n2;
        }
    }

    public boolean performOk() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        String fiList = "";
        int i = 0;
        while (i < this.XMLLocs.getItemCount()) {
            fiList = String.valueOf(fiList) + this.XMLLocs.getItem(i);
            if (i < this.XMLLocs.getItemCount() - 1) {
                fiList = String.valueOf(fiList) + ",,,";
            }
            ++i;
        }
        preferences.setValue("tool_def_xml_location", fiList);
        Activator.getDefault().refreshTools();
        return true;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    public void init(IWorkbench workbench) {
    }

    protected void defaultSetting() {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text == null) {
            return null;
        }
        if (text.trim().length() == 0 || text.equals("")) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ExternalToolPreferencePage.this.browseXMLButton) {
                ExternalToolPreferencePage.this.handleXMLBrowseButtonSelected();
            }
            if (source == ExternalToolPreferencePage.this.removeItemButton) {
                ExternalToolPreferencePage.this.handleRemoveItem();
            }
            ExternalToolPreferencePage.this.updatePreferencePage();
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            ExternalToolPreferencePage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                ExternalToolPreferencePage.this.updatePreferencePage();
            }
        }
    }
}

