/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg;

import java.util.HashMap;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.Intrinsics;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTBlockDataNameNode;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTGenericNameNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTProgramStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefinitionMap<T> {
    private HashMap<String, T> definitions = new HashMap();

    public DefinitionMap(IFortranAST ast) {
        this(ast.getRoot());
    }

    public DefinitionMap(ASTExecutableProgramNode ast) {
        if (PhotranVPGBuilder.isEmpty((ASTExecutableProgramNode)ast)) {
            return;
        }
        try {
            ast.accept((Parser.IASTVisitor)new Parser.GenericASTVisitor(){

                public void visitASTNode(Parser.IASTNode node) {
                    if (ScopingNode.isScopingNode((Parser.IASTNode)node)) {
                        for (Definition def : ((ScopingNode)node).getAllDefinitions()) {
                            if (def == null) continue;
                            String name = def.getCanonicalizedName();
                            String qualifiedName = DefinitionMap.qualify(name, (ScopingNode)node);
                            DefinitionMap.this.definitions.put(qualifiedName, DefinitionMap.this.map(qualifiedName, def));
                        }
                    }
                    this.traverseChildren(node);
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public DefinitionMap(DefinitionMap<Definition> other) {
        for (String key : other.definitions.keySet()) {
            this.definitions.put(key, this.map(key, (Definition)other.definitions.get(key)));
        }
    }

    protected abstract T map(String var1, Definition var2);

    public T lookup(TextSelection selection, TokenList tokenList) {
        return this.lookup(DefinitionMap.findTokenEnclosing(selection, tokenList));
    }

    public static Token findTokenEnclosing(TextSelection sel, TokenList tokenList) {
        return DefinitionMap.findTokenEnclosing(sel.getOffset(), tokenList);
    }

    public static Token findTokenEnclosing(int offset, TokenList tokenList) {
        int i = 0;
        int size = tokenList.size();
        while (i < size) {
            if (tokenList.get(i).containsFileOffset(offset)) {
                return tokenList.get(i);
            }
            ++i;
        }
        return null;
    }

    public T lookup(Token token) {
        if (token == null || token.getTerminal() != Terminal.T_IDENT) {
            return null;
        }
        String qualifiedName = DefinitionMap.qualify(PhotranVPG.canonicalizeIdentifier((String)token.getText()), token.getEnclosingScope());
        while (!this.definitions.containsKey(qualifiedName)) {
            int index = qualifiedName.indexOf(58);
            if (index < 0) {
                Definition intrinsic = Intrinsics.resolveIntrinsic((Token)token);
                if (intrinsic != null) {
                    return this.map(intrinsic.getCanonicalizedName(), intrinsic);
                }
                return null;
            }
            qualifiedName = qualifiedName.substring(index + 1);
        }
        return this.definitions.get(qualifiedName);
    }

    public static String qualify(String canonicalizedName, ScopingNode initialScope) {
        StringBuilder result = new StringBuilder();
        DefinitionMap.getQualifier(initialScope, result);
        result.append(canonicalizedName);
        return result.toString();
    }

    private static void getQualifier(ScopingNode initialScope, StringBuilder result) {
        ScopingNode scope = initialScope;
        while (scope != null && !(scope instanceof ASTExecutableProgramNode)) {
            result.append(DefinitionMap.getQualifierElement(scope));
            scope = scope.getEnclosingScope();
        }
    }

    public static String getQualifier(ScopingNode scope) {
        StringBuilder result = new StringBuilder();
        DefinitionMap.getQualifier(scope, result);
        return result.toString();
    }

    private static String getQualifierElement(ScopingNode node) {
        class GetScopeVisitor
        extends Parser.ASTVisitor {
            private String name = "";

            GetScopeVisitor() {
            }

            public void visitASTMainProgramNode(ASTMainProgramNode node) {
                ASTProgramStmtNode ps = node.getProgramStmt();
                if (ps != null && ps.getProgramName() != null) {
                    this.name = ps.getProgramName().getProgramName().getText();
                }
            }

            public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
                this.name = node.getFunctionStmt().getFunctionName().getFunctionName().getText();
            }

            public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
                this.name = node.getSubroutineStmt().getSubroutineName().getSubroutineName().getText();
            }

            public void visitASTModuleNode(ASTModuleNode node) {
                this.name = node.getModuleStmt().getModuleName().getModuleName().getText();
            }

            public void visitASTBlockDataSubprogramNode(ASTBlockDataSubprogramNode node) {
                ASTBlockDataNameNode name = node.getBlockDataStmt().getBlockDataName();
                if (name != null) {
                    this.name = name.getBlockDataName().getText();
                }
            }

            public void visitASTDerivedTypeDefNode(ASTDerivedTypeDefNode node) {
                this.name = node.getDerivedTypeStmt().getTypeName().getText();
            }

            public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
                ASTGenericNameNode nm = node.getInterfaceStmt().getGenericName();
                if (nm != null) {
                    this.name = nm.getGenericName().getText();
                }
            }
        }
        GetScopeVisitor visitor = new GetScopeVisitor();
        node.accept((Parser.IASTVisitor)visitor);
        return String.valueOf(node.getClass().getName()) + "/" + visitor.name.toLowerCase() + ":";
    }
}

