/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;

public class LocalFileManager
implements IRemoteFileManager {
    private IPath fWorkingDir = null;

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = this.getWorkingDirectoryPath().append((IPath)path);
        }
        return EFS.getLocalFileSystem().getStore((IPath)path);
    }

    public String getWorkingDirectory() {
        return this.getWorkingDirectoryPath().toString();
    }

    public void setWorkingDirectory(String pathStr) {
        Path path = new Path(pathStr);
        if (path.isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public String toPath(URI uri) {
        return URIUtil.toPath((URI)uri).toString();
    }

    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }

    public URI toURI(String path) {
        return URIUtil.toURI((String)path);
    }

    private IPath getWorkingDirectoryPath() {
        if (this.fWorkingDir == null) {
            String home = System.getProperty("user.home");
            this.fWorkingDir = home != null ? new Path(home) : new Path(".");
        }
        return this.fWorkingDir;
    }
}

