/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.util;

public class BitList {
    private byte[] bits;
    private int nBits;
    private int nBytes;
    private int hash = 0;

    public static String showBitList(BitList b) {
        if (b == null) {
            return "{null}";
        }
        int[] array = b.toArray();
        if (array.length == 0) {
            return "{}";
        }
        String msg = "{";
        int preTask = array[0];
        msg = String.valueOf(msg) + preTask;
        boolean isContinue = false;
        int i = 1;
        while (i < array.length) {
            if (preTask == array[i] - 1) {
                preTask = array[i];
                isContinue = true;
                if (i == array.length - 1) {
                    msg = String.valueOf(msg) + "-" + array[i];
                    break;
                }
            } else {
                if (isContinue) {
                    msg = String.valueOf(msg) + "-" + preTask;
                }
                msg = String.valueOf(msg) + "," + array[i];
                isContinue = false;
                preTask = array[i];
            }
            ++i;
        }
        return String.valueOf(msg) + "}";
    }

    public BitList(int nbits) {
        this.init(nbits);
    }

    public BitList(int nbits, String str) {
        this.init(nbits);
        this.fromString(str);
    }

    private BitList(int nbits, byte[] bits) {
        this.init(nbits);
        int i = 0;
        while (i < this.nBytes) {
            this.bits[i] = bits[i];
            ++i;
        }
    }

    public void and(BitList s) {
        int i = 0;
        while (i < this.nBytes) {
            if (i >= s.nBytes) {
                this.bits[i] = 0;
            } else {
                int n = i;
                this.bits[n] = (byte)(this.bits[n] & s.bits[i]);
            }
            ++i;
        }
    }

    public void andNot(BitList s) {
        int i = 0;
        while (i < this.nBytes) {
            if (i < s.nBytes) {
                int n = i;
                this.bits[n] = (byte)(this.bits[n] & ~s.bits[i]);
            }
            ++i;
        }
    }

    public int cardinality() {
        int n = 0;
        int i = 0;
        while (i < this.nBytes) {
            n += this.countBits(this.bits[i]);
            ++i;
        }
        return n;
    }

    public void clear(int index) throws IndexOutOfBoundsException {
        int b;
        if (index >= this.nBits || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = b = this.bytePos(index);
        this.bits[n] = (byte)(this.bits[n] & ~((byte)(1 << this.bitInByte(index))));
    }

    public void clear(int[] indices) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < indices.length) {
            this.clear(indices[i]);
            ++i;
        }
    }

    public Object clone() {
        return this.copy();
    }

    public BitList copy() {
        return new BitList(this.nBits, this.bits);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BitList) {
            BitList anotherBitList = (BitList)obj;
            if (this.nBits != anotherBitList.nBits || this.nBytes != anotherBitList.nBytes) {
                return false;
            }
            int i = 0;
            while (i < this.nBytes) {
                if (this.bits[i] != anotherBitList.bits[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean get(int index) throws IndexOutOfBoundsException {
        byte mask;
        if (index >= this.nBits || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int b = this.bytePos(index);
        return (this.bits[b] & (mask = (byte)(1 << this.bitInByte(index)))) == mask;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int i = 0;
            while (i < this.nBytes) {
                h = 31 * h + this.bits[i];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }

    public boolean intersects(BitList s) {
        int i = 0;
        while (i < this.nBytes) {
            if (i >= s.nBytes) break;
            if ((this.bits[i] & s.bits[i]) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEmpty() {
        boolean res = true;
        int i = 0;
        while (i < this.nBytes) {
            if (this.bits[i] != 0) {
                res = false;
            }
            ++i;
        }
        return res;
    }

    public int nextSetBit(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.nBits) {
            return -1;
        }
        int i = index;
        int start = this.bitInByte(index);
        int p = this.bytePos(index);
        while (p < this.nBytes) {
            byte val = this.bits[p];
            if (val != 0) {
                int b = start;
                while (b < 8) {
                    byte mask = (byte)(1 << b);
                    if ((val & mask) == mask) {
                        return i;
                    }
                    ++b;
                    ++i;
                }
            } else {
                i += 8;
            }
            start = 0;
            ++p;
        }
        return -1;
    }

    public void or(BitList s) {
        int i = 0;
        while (i < this.nBytes) {
            if (i >= s.nBytes) break;
            int n = i;
            this.bits[n] = (byte)(this.bits[n] | s.bits[i]);
            ++i;
        }
    }

    public void set(int index) throws IndexOutOfBoundsException {
        int b;
        if (index >= this.nBits || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = b = this.bytePos(index);
        this.bits[n] = (byte)(this.bits[n] | (byte)(1 << this.bitInByte(index)));
    }

    public void set(int from, int to) {
        if (from >= this.nBits || from < 0 || to > this.nBits || from >= to) {
            throw new IndexOutOfBoundsException();
        }
        int last = to - 1;
        if (from == last) {
            this.set(from);
            return;
        }
        int p1 = this.bytePos(from);
        int p2 = this.bytePos(last);
        int b1 = this.bitInByte(from);
        int b2 = this.bitInByte(last);
        if (p1 == p2) {
            byte mask = (byte)(255 >> 7 - b2);
            this.bits[p1] = (byte)(mask & 255 << b1);
            return;
        }
        byte hiMask = (byte)(255 >> 7 - b2);
        byte lowMask = (byte)(255 << b1);
        int p = p1 + 1;
        while (p < p2) {
            this.bits[p] = -1;
            ++p;
        }
        int n = p1;
        this.bits[n] = (byte)(this.bits[n] | lowMask);
        int n2 = p2;
        this.bits[n2] = (byte)(this.bits[n2] | hiMask);
    }

    public void set(int[] indices) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < indices.length) {
            this.set(indices[i]);
            ++i;
        }
    }

    public int size() {
        return this.nBits;
    }

    public int[] toArray() {
        int[] retValue = new int[this.cardinality()];
        int i = this.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            retValue[j] = i;
            i = this.nextSetBit(i + 1);
            ++j;
        }
        return retValue;
    }

    public String toString() {
        String res = "";
        if (this.nBits == 0) {
            res = "0";
        } else {
            int i = this.nBytes - 1;
            while (i >= 0) {
                res = String.valueOf(res) + Integer.toHexString(this.bits[i] >> 4 & 0xF);
                res = String.valueOf(res) + Integer.toHexString(this.bits[i] & 0xF);
                --i;
            }
        }
        return res;
    }

    private int bitInByte(int idx) {
        return idx - (this.bytePos(idx) << 3);
    }

    private int bytePos(int idx) {
        return idx >> 3;
    }

    private int countBits(byte b) {
        int n = 0;
        while (b != 0) {
            ++n;
            b = (byte)(b & b - 1);
        }
        return n;
    }

    private byte fromHex(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        return 0;
    }

    private void fromString(String str) {
        if (this.nBytes == 0) {
            return;
        }
        byte[] strBits = str.getBytes();
        int last = strBits.length - this.nBytes * 2;
        if (last < 0) {
            last = 0;
        }
        byte mask = (byte)(255 >> 7 - this.bitInByte(this.nBits - 1));
        int i = strBits.length - 1;
        int b = 0;
        while (i >= last) {
            byte c = this.fromHex(strBits[i]);
            if (i - 1 >= 0) {
                c = (byte)(c | this.fromHex(strBits[i - 1]) << 4);
            }
            this.bits[b] = c;
            i -= 2;
            ++b;
        }
        int n = this.nBytes - 1;
        this.bits[n] = (byte)(this.bits[n] & mask);
    }

    private void init(int nbits) throws NegativeArraySizeException {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        if (nbits == 0) {
            this.nBits = 0;
            this.nBytes = 0;
        } else {
            this.nBits = nbits;
            this.nBytes = (nbits - 1 >> 3) + 1;
            this.bits = new byte[this.nBytes];
        }
    }
}

