/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.events.IProcessChangeEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IJobListener;
import org.eclipse.ptp.core.elements.listeners.IProcessListener;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.JobChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.NewProcessEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveProcessEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PJob
extends Parent
implements IPJobControl,
IProcessListener {
    private final ListenerList elementListeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();
    private final Map<String, IPProcessControl> indexMap = Collections.synchronizedMap(new HashMap());
    private ILaunchConfiguration configuration;

    public PJob(String id, IPQueueControl queue, IAttribute<?, ?, ?>[] attrs) {
        super(id, queue, 13, attrs);
        BooleanAttribute debugFlag;
        IAttribute jobState = (EnumeratedAttribute)this.getAttribute(JobAttributes.getStateAttributeDefinition());
        if (jobState == null) {
            jobState = JobAttributes.getStateAttributeDefinition().create();
            this.addAttribute(jobState);
        }
        if ((debugFlag = (BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition())) == null) {
            debugFlag = JobAttributes.getDebugFlagAttributeDefinition().create();
            this.addAttribute(debugFlag);
        }
    }

    @Override
    public void addChildListener(IJobChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IJobListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addProcessAttributes(Collection<IPProcessControl> processControls, IAttribute<?, ?, ?>[] attrs) {
        ArrayList<IPProcess> processes = new ArrayList<IPProcess>(processControls.size());
        for (IPProcessControl process : processControls) {
            process.addAttributes(attrs);
            processes.add(process);
        }
        this.fireChangedProcesses(processes);
    }

    @Override
    public void addProcesses(Collection<IPProcessControl> processControls) {
        ArrayList<IPProcess> processes = new ArrayList<IPProcess>(processControls.size());
        for (IPProcessControl process : processControls) {
            this.addChild(process);
            String idx = process.getProcessIndex();
            if (idx != null) {
                this.indexMap.put(idx, process);
            }
            processes.add(process);
            process.addElementListener(this);
        }
        this.fireNewProcesses(processes);
    }

    @Override
    public synchronized ILaunchConfiguration getLaunchConfiguration() {
        return this.configuration;
    }

    @Override
    public IPProcess getProcessById(String id) {
        IPElementControl element = this.findChild(id);
        if (element != null) {
            return (IPProcessControl)element;
        }
        return null;
    }

    @Override
    public IPProcess getProcessByIndex(int index) {
        return this.indexMap.get(String.valueOf(index));
    }

    @Override
    public IPProcess getProcessByIndex(String index) {
        return this.indexMap.get(index);
    }

    @Override
    public Collection<IPProcessControl> getProcessControls() {
        IPElementControl[] children = this.getChildren();
        ArrayList<IPProcessControl> processes = new ArrayList<IPProcessControl>(children.length);
        IPElementControl[] iPElementControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElementControl element = iPElementControlArray[n2];
            processes.add((IPProcessControl)element);
            ++n2;
        }
        return processes;
    }

    @Override
    public IPProcess[] getProcesses() {
        return this.getProcessControls().toArray(new IPProcess[this.getProcessControls().size()]);
    }

    @Override
    public IPQueue getQueue() {
        return this.getQueueControl();
    }

    @Override
    public IPQueueControl getQueueControl() {
        return (IPQueueControl)this.getParent();
    }

    @Override
    public JobAttributes.State getState() {
        return (JobAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(JobAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void handleEvent(IProcessChangeEvent e) {
        if (!this.childListeners.isEmpty()) {
            ArrayList<IPProcess> procs = new ArrayList<IPProcess>();
            procs.add(e.getSource());
            this.fireChangedProcesses(procs);
        }
    }

    @Override
    public boolean isDebug() {
        return ((BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition())).getValue();
    }

    @Override
    public void removeChildListener(IJobChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IJobListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeProcesses(Collection<IPProcessControl> processControls) {
        ArrayList<IPProcess> processes = new ArrayList<IPProcess>(processControls.size());
        for (IPProcessControl process : processControls) {
            this.removeChild(process);
            process.clearOutput();
            String idx = process.getProcessIndex();
            if (idx != null) {
                this.indexMap.remove(idx);
            }
            processes.add(process);
        }
        this.fireRemoveProcesses(processes);
    }

    @Override
    public void setDebug() {
        BooleanAttribute debug = (BooleanAttribute)this.getAttribute(JobAttributes.getDebugFlagAttributeDefinition());
        debug.setValue(true);
    }

    @Override
    public synchronized void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.configuration = configuration;
    }

    private void fireChangedJob(AttributeManager attrs) {
        JobChangeEvent e = new JobChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedProcesses(Collection<IPProcess> processes) {
        ChangedProcessEvent e = new ChangedProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewProcesses(Collection<IPProcess> processes) {
        NewProcessEvent e = new NewProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveProcesses(Collection<IPProcess> processes) {
        RemoveProcessEvent e = new RemoveProcessEvent(this, processes);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IJobChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attribs) {
        this.fireChangedJob(attribs);
    }
}

