/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingCollector
extends Parser.ASTVisitor {
    protected PhotranVPGBuilder vpg = (PhotranVPGBuilder)PhotranVPG.getInstance();

    protected void markSubprogramExport(IFile file, Token subprogramName) {
        this.vpg.markFileAsExportingSubprogram(file, subprogramName.getText());
    }

    protected void markSubprogramImport(IFile file, Token subprogramName) {
        this.vpg.markFileAsImportingSubprogram(file, subprogramName.getText());
    }

    protected void markModuleExport(IFile file, Token moduleName) {
        this.vpg.markFileAsExportingModule(file, moduleName.getText());
    }

    protected void setScopeDefaultVisibilityToPrivate(ScopingNode scope) {
        this.vpg.setDefaultScopeVisibilityToPrivate(scope);
    }

    protected void setDefinition(Token ident, Definition def) {
        this.vpg.setDefinitionFor(ident.getTokenRef(), def);
    }

    Definition addDefinition(Token token, Definition.Classification classification, Type type) {
        if (token == null) {
            return null;
        }
        try {
            Definition.Visibility visibility = token.getEnclosingScope().isDefaultVisibilityPrivate() ? Definition.Visibility.PRIVATE : Definition.Visibility.PUBLIC;
            Definition definition = new Definition(token.getText(), token.getTokenRef(), classification, type);
            this.vpg.setDefinitionFor(token.getTokenRef(), definition);
            this.vpg.markScope(token.getTokenRef(), token.getEnclosingScope());
            this.vpg.markDefinitionVisibilityInScope(token.getTokenRef(), token.getEnclosingScope(), visibility);
            return definition;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    Definition addDefinition(Token token, Definition.Classification classification) {
        return this.addDefinition(token, classification, Type.VOID);
    }

    void importDefinition(Definition definitionToImport, ScopingNode importIntoScope) {
        try {
            this.vpg.markScope(definitionToImport.getTokenRef(), importIntoScope);
            if (importIntoScope.isDefaultVisibilityPrivate()) {
                this.vpg.markDefinitionVisibilityInScope(definitionToImport.getTokenRef(), importIntoScope, Definition.Visibility.PRIVATE);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    List<PhotranTokenRef> bind(Token identifier) {
        List<PhotranTokenRef> result = identifier.manuallyResolveBinding();
        for (PhotranTokenRef def : result) {
            this.bind(identifier, def);
        }
        return result;
    }

    List<PhotranTokenRef> bindNoImplicits(Token identifier) {
        List<PhotranTokenRef> result = identifier.manuallyResolveBindingNoImplicits();
        for (PhotranTokenRef def : result) {
            this.bind(identifier, def);
        }
        return result;
    }

    List<PhotranTokenRef> bindAsParam(Token identifier) {
        List<PhotranTokenRef> result = this.bind(identifier);
        for (PhotranTokenRef def : result) {
            Definition d = this.vpg.getDefinitionFor(def);
            d.markAsSubprogramArgument();
            this.vpg.setDefinitionFor(def, d);
        }
        return result;
    }

    void bind(Token identifier, PhotranTokenRef toDefinition) {
        try {
            this.vpg.markBinding(identifier.getTokenRef(), toDefinition);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    void bindRenamedEntity(Token identifier, PhotranTokenRef toDefinition) {
        if (identifier == null) {
            return;
        }
        try {
            this.vpg.markRenamedBinding(identifier.getTokenRef(), toDefinition);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    void dontbind(Token identifier) {
    }
}

