/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import org.eclipse.photran.internal.core.analysis.dependence.VariableReference;

public final class Dependence {
    final VariableReference from;
    final VariableReference to;
    public final Type type;

    Dependence(VariableReference from, VariableReference to) {
        this.from = from;
        this.to = to;
        this.type = Type.of(this);
    }

    public boolean equals(Object o) {
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Dependence that = (Dependence)o;
        return this.from.equals(that.from) && this.to.equals(that.to) && this.type.equals((Object)that.type);
    }

    public int hashCode() {
        return this.from.hashCode() + 13 * this.to.hashCode() + 19 * this.type.hashCode();
    }

    public String toString() {
        return (Object)((Object)this.type) + " from " + this.from + " to " + this.to;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FLOW_DEPENDENCE("Flow dependence"),
        ANTI_DEPENDENCE("Anti-dependence"),
        OUTPUT_DEPENDENCE("Output dependence");

        private String description;

        private Type(String description) {
            this.description = description;
        }

        public static Type of(Dependence d) {
            if (d.from.isWrite && d.to.isWrite) {
                return OUTPUT_DEPENDENCE;
            }
            if (d.from.isRead() && d.to.isWrite) {
                return ANTI_DEPENDENCE;
            }
            return FLOW_DEPENDENCE;
        }

        public String toString() {
            return this.description;
        }
    }
}

