/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RSEFileManager
implements IRemoteFileManager {
    private IPath fWorkingDir = null;
    private final RSEConnection fConnection;

    public RSEFileManager(RSEConnection conn) {
        this.fConnection = conn;
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = this.fWorkingDir.append((IPath)path);
        }
        return this.fConnection.getFileSystem().getStore(this.toURI((IPath)path));
    }

    public String getWorkingDirectory() {
        if (this.fWorkingDir == null) {
            IFileServiceSubSystem fileService = this.getFileServiceSubSystem(this.fConnection.getHost());
            this.fWorkingDir = fileService != null ? new Path(fileService.getFileService().getUserHome().getAbsolutePath()) : new Path("/");
        }
        return this.fWorkingDir.toString();
    }

    public void setWorkingDirectory(String pathStr) {
        Path path = new Path(pathStr);
        if (path.isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        String authority = this.fConnection.getHost().getHostName();
        try {
            authority = URLEncoder.encode(authority, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        try {
            return new URI("rse", authority, path.makeAbsolute().toPortableString(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }

    private IFileServiceSubSystem getFileServiceSubSystem(IHost host) {
        IRemoteFileSubSystem[] fileSubsystems;
        IRemoteFileSubSystem[] iRemoteFileSubSystemArray = fileSubsystems = RemoteFileUtility.getFileSubSystems((IHost)host);
        int n = fileSubsystems.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFileSubSystem subsystem = iRemoteFileSubSystemArray[n2];
            if (subsystem instanceof IFileServiceSubSystem && subsystem.isConnected()) {
                return (IFileServiceSubSystem)subsystem;
            }
            ++n2;
        }
        return null;
    }
}

