/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEvaluatePartialExpressionRequest;

public abstract class AbstractEvaluatePartialExpressionRequest
extends AbstractEventResultRequest
implements IPDIEvaluatePartialExpressionRequest {
    private String expr;
    private String exprId;
    private boolean listChildren = false;
    private boolean express = false;

    public AbstractEvaluatePartialExpressionRequest(BitList tasks, String expr, String exprId) {
        this(tasks, expr, exprId, false, exprId != null);
    }

    public AbstractEvaluatePartialExpressionRequest(BitList tasks, String expr, String exprId, boolean listChildren) {
        this(tasks, expr, exprId, listChildren, false);
    }

    public AbstractEvaluatePartialExpressionRequest(BitList tasks, String expr, String exprId, boolean listChildren, boolean express) {
        super(tasks);
        this.expr = expr;
        this.exprId = exprId;
        this.listChildren = listChildren;
        this.express = express;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.evaluatePartialExpression(this.tasks, this.expr, this.exprId, this.listChildren, this.express);
    }

    public String getName() {
        return "Partial expression evaluation";
    }

    public IAIF getPartialAIF(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (IAIF)returnValues[1];
        }
        throw new PDIException(qTasks, NLS.bind((String)"No result found for expression \"{0}\"", (Object)this.expr));
    }

    public String getId(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            return (String)returnValues[0];
        }
        throw new PDIException(qTasks, NLS.bind((String)"Expression ID {0} not found", (Object)this.exprId));
    }

    public String toString() {
        return String.valueOf(this.getName()) + " for tasks " + BitList.showBitList((BitList)this.getTasks()) + ", exp: " + this.expr + ", id: " + this.exprId + ", is list children: " + this.listChildren + ", is express: " + this.express;
    }
}

