/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPVariable
extends PlatformObject
implements ICPPVariable,
ICPPInternalBinding,
IInternalVariable {
    private IASTName[] declarations = null;
    private IASTName definition = null;
    private IType type = null;

    public CPPVariable(IASTName name) {
        boolean isDef;
        boolean bl = isDef = name == null ? false : name.isDefinition();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        if (isDef) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        if (name != null) {
            name.setBinding(this);
        } else assert (this instanceof CPPBuiltinVariable);
    }

    private IASTDeclarator findDeclarator(IASTName name) {
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTQualifiedName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        IASTDeclarator dtor = (IASTDeclarator)node;
        while (dtor.getParent() instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)dtor.getParent();
        }
        return dtor;
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (name.isDefinition()) {
            this.definition = name;
        } else {
            this.declarations = this.declarations == null ? new IASTName[]{name} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name));
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public IType getType() {
        if (this.type == null) {
            IASTName n = null;
            if (this.definition != null) {
                n = this.definition;
            } else if (this.declarations != null && this.declarations.length > 0) {
                n = this.declarations[0];
            }
            if (n != null) {
                while (n.getParent() instanceof IASTName) {
                    n = (IASTName)n.getParent();
                }
                IASTNode node = n.getParent();
                if (node instanceof IASTDeclarator) {
                    this.type = CPPVisitor.createType((IASTDeclarator)node);
                }
            }
        }
        return this.type;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public char[] getNameCharArray() {
        if (this.declarations != null) {
            return this.declarations[0].getSimpleID();
        }
        return this.definition.getSimpleID();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.definition != null ? this.definition : this.declarations[0]);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            IASTDeclSpecifier declSpec;
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTSimpleDeclaration) || (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public IBinding getOwner() throws DOMException {
        IASTName node = this.definition != null ? this.definition : this.declarations[0];
        return CPPVisitor.findNameOwner(node, !this.hasStorageClass(2));
    }

    public String toString() {
        return this.getName();
    }

    public IValue getInitialValue() {
        return this.getInitialValue(25);
    }

    public IValue getInitialValue(int maxDepth) {
        IValue val;
        if (this.definition != null && (val = this.getInitialValue(this.definition, maxDepth)) != null) {
            return val;
        }
        if (this.declarations != null) {
            IASTName[] iASTNameArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName decl = iASTNameArray[n2];
                if (decl == null) break;
                IValue val2 = this.getInitialValue(decl, maxDepth);
                if (val2 != null) {
                    return val2;
                }
                ++n2;
            }
        }
        return null;
    }

    private IValue getInitialValue(IASTName name, int maxDepth) {
        IASTDeclarator dtor = this.findDeclarator(name);
        if (dtor != null) {
            IASTExpression expr;
            IType type;
            IASTInitializer init = dtor.getInitializer();
            if (init instanceof IASTInitializerExpression) {
                IASTExpression expr2 = ((IASTInitializerExpression)init).getExpression();
                if (expr2 != null) {
                    return Value.create(expr2, maxDepth);
                }
            } else if (init instanceof ICPPASTConstructorInitializer && ((type = SemanticUtil.getUltimateTypeUptoPointers(this.getType())) instanceof IPointerType || type instanceof IBasicType) && (expr = ((ICPPASTConstructorInitializer)init).getExpression()) != null) {
                return Value.create(expr, maxDepth);
            }
            if (init != null) {
                return Value.UNKNOWN;
            }
        }
        return null;
    }

    public static class CPPVariableProblem
    extends ProblemBinding
    implements ICPPVariable {
        public CPPVariableProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExternC() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public IValue getInitialValue() {
            return null;
        }
    }
}

