/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

class PDOMCParameter
extends PDOMNamedNode
implements IParameter,
IPDOMBinding {
    private static final int NEXT_PARAM = 12;
    private static final int TYPE = 16;
    protected static final int FLAGS = 20;
    public static final int RECORD_SIZE = 21;

    public PDOMCParameter(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCParameter(PDOMLinkage linkage, PDOMNode parent, IParameter param) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putRecPtr(this.record + 12L, 0L);
        try {
            if (!(param instanceof IProblemBinding)) {
                IType type = param.getType();
                if (type != null) {
                    PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, type);
                    db.putRecPtr(this.record + 16L, typeNode != null ? typeNode.getRecord() : 0L);
                }
                byte flags = this.encodeFlags(param);
                db.putByte(this.record + 20L, flags);
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    protected int getRecordSize() {
        return 21;
    }

    public int getNodeType() {
        return 13;
    }

    public void setNextParameter(PDOMCParameter nextParam) throws CoreException {
        long rec = nextParam != null ? nextParam.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 12L, rec);
    }

    public PDOMCParameter getNextParameter() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 12L);
        return rec != 0L ? new PDOMCParameter((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public IASTInitializer getDefaultValue() {
        return null;
    }

    public IType getType() {
        try {
            ILinkage linkage = this.getLinkage();
            PDOMNode node = ((PDOMLinkage)linkage).getNode(this.getDB().getRecPtr(this.record + 16L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        byte flag = 1;
        return this.hasFlag(flag, true);
    }

    public boolean isExtern() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isRegister() throws DOMException {
        byte flag = 8;
        return this.hasFlag(flag, false);
    }

    public boolean isStatic() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IIndexScope getScope() {
        throw new PDOMNotImplementedError();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new char[0];
        }
    }

    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public String[] getQualifiedName() {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public int getBindingConstant() {
        return this.getNodeType();
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        linkage.deleteType(this.getType(), this.record);
        PDOMCParameter next = this.getNextParameter();
        if (next != null) {
            next.delete(linkage);
        }
        super.delete(linkage);
    }

    public boolean isFileLocal() throws CoreException {
        return false;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    public IValue getInitialValue() {
        return null;
    }

    protected byte encodeFlags(IParameter param) {
        byte flags = 0;
        try {
            flags = (byte)(flags | (param.isAuto() ? 1 : 0) << 0);
            flags = (byte)(flags | (param.isRegister() ? 1 : 0) << 3);
        }
        catch (DOMException dOMException) {}
        return flags;
    }

    protected boolean hasFlag(byte flag, boolean defValue) {
        try {
            byte myflags = this.getDB().getByte(this.record + 20L);
            return (myflags & flag) == flag;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return defValue;
        }
    }
}

