/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.includebrowser;

import java.io.Serializable;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;

public class IndexIncludeValue
implements IIndexIncludeValue,
Serializable {
    private static final long serialVersionUID = -6440736393666515385L;
    private transient IIndexInclude include;
    private transient IIndexFile includedBy;
    private transient IIndexLocationConverter converter;
    private IIndexFileLocation includedByLocation;
    private IIndexFileLocation includesLocation;
    private long includedByTimestamp;
    private String name;
    private String fullName;
    private int nameLength;
    private int nameOffset;
    private boolean isActive;
    private boolean isResolved;
    private boolean isSystemInclude;

    public IndexIncludeValue(IIndexInclude include) throws CoreException {
        this(include, null);
    }

    public IndexIncludeValue(IIndexInclude include, IIndexLocationConverter converter) throws CoreException {
        if (include == null) {
            throw new IllegalArgumentException();
        }
        this.converter = converter;
        this.include = include;
        this.includedBy = include.getIncludedBy();
        if (include.getIncludedByLocation() != null && converter != null) {
            this.includedByLocation = converter.fromInternalFormat(include.getIncludedByLocation().getURI().toString());
        }
        if (include.getIncludesLocation() != null && converter != null) {
            this.includesLocation = converter.fromInternalFormat(include.getIncludesLocation().getURI().toString());
        }
        this.includedByTimestamp = include.getIncludedBy().getTimestamp();
        this.name = include.getName();
        this.fullName = include.getFullName();
        this.nameLength = include.getNameLength();
        this.nameOffset = include.getNameOffset();
        this.isActive = include.isActive();
        this.isResolved = include.isResolved();
        this.isSystemInclude = include.isSystemInclude();
    }

    public IIndexFileLocation getIncludedByLocation() throws CoreException {
        return this.includedByLocation;
    }

    public IIndexFileLocation getIncludesLocation() throws CoreException {
        return this.includesLocation;
    }

    public String getName() throws CoreException {
        return this.name;
    }

    public int getNameLength() throws CoreException {
        return this.nameLength;
    }

    public int getNameOffset() throws CoreException {
        return this.nameOffset;
    }

    public boolean isActive() throws CoreException {
        return this.isActive;
    }

    public boolean isResolved() throws CoreException {
        return this.isResolved;
    }

    public boolean isSystemInclude() throws CoreException {
        return this.isSystemInclude;
    }

    public long getIncludedByTimestamp() {
        return this.includedByTimestamp;
    }

    public IIndexFile getIncludedBy() throws CoreException {
        return this.includedBy;
    }

    public IIndexInclude getIndexInclude() {
        return this.include;
    }

    public IIndexLocationConverter getLocationConverter() {
        return this.converter;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("\nsuper = ").append(super.toString());
        buffer.append("\nincludedByLocation = ").append(this.includedByLocation);
        buffer.append("\nincludesLocation = ").append(this.includesLocation);
        buffer.append("\nname = ").append(this.name);
        buffer.append("\nnameLength = ").append(this.nameLength);
        buffer.append("\nnameOffset = ").append(this.nameOffset);
        buffer.append("\nisActive = ").append(this.isActive);
        buffer.append("\nisResolved = ").append(this.isResolved);
        buffer.append("\nisSystemInclude = ").append(this.isSystemInclude);
        buffer.append("\nincludedByTimestamp = ").append(this.includedByTimestamp);
        return buffer.toString();
    }

    public boolean isResolvedByHeuristics() throws CoreException {
        return false;
    }

    public String getFullName() throws CoreException {
        return this.fullName;
    }
}

