/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPTemplateNonTypeParameter
extends PDOMCPPBinding
implements IPDOMMemberOwner,
ICPPTemplateNonTypeParameter,
IPDOMCPPTemplateParameter {
    private static final int TYPE_OFFSET = 28;
    private static final int PARAMETERID = 32;
    private static final int DEFAULTVAL = 36;
    private int fCachedParamID = -1;
    protected static final int RECORD_SIZE = 49;

    public PDOMCPPTemplateNonTypeParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateNonTypeParameter param) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putInt(this.record + 32L, param.getParameterID());
    }

    public PDOMCPPTemplateNonTypeParameter(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 49;
    }

    public int getNodeType() {
        return 49;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IValue val;
        block3: {
            try {
                Database db = this.getDB();
                long rec = db.getRecPtr(this.record + 36L);
                val = PDOMValue.restore(db, (PDOMLinkage)this.getLinkage(), rec);
                if (val != null) break block3;
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return null;
            }
        }
        return new CPPTemplateArgument(val, this.getType());
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateNonTypeParameter ntp = (ICPPTemplateNonTypeParameter)newBinding;
            this.updateName(newBinding.getNameCharArray());
            Database db = this.getDB();
            IType mytype = this.getType();
            long valueRec = db.getRecPtr(this.record + 36L);
            try {
                IType newType = ntp.getType();
                this.setType(linkage, newType);
                if (mytype != null) {
                    linkage.deleteType(mytype, this.record);
                }
                if (this.setDefaultValue(db, ntp)) {
                    PDOMValue.delete(db, valueRec);
                }
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus((Throwable)e));
            }
        }
    }

    public void forceDelete(PDOMLinkage linkage) throws CoreException {
        this.getDBName().delete();
        IType type = this.getType();
        if (type instanceof PDOMNode) {
            ((PDOMNode)((Object)type)).delete(linkage);
        }
        Database db = this.getDB();
        long valueRec = db.getRecPtr(this.record + 36L);
        PDOMValue.delete(db, valueRec);
    }

    public short getParameterPosition() {
        this.readParamID();
        return (short)this.fCachedParamID;
    }

    public short getTemplateNestingLevel() {
        this.readParamID();
        return (short)(this.fCachedParamID >> 16);
    }

    public int getParameterID() {
        this.readParamID();
        return this.fCachedParamID;
    }

    private void readParamID() {
        if (this.fCachedParamID == -1) {
            try {
                Database db = this.getDB();
                this.fCachedParamID = db.getInt(this.record + 32L);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.fCachedParamID = -2;
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException, DOMException {
        PDOMNode typeNode = linkage.addType(this, newType);
        this.getDB().putRecPtr(this.record + 28L, typeNode != null ? typeNode.getRecord() : 0L);
    }

    public void configure(ICPPTemplateParameter param) {
        try {
            if (param instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nonTypeParm = (ICPPTemplateNonTypeParameter)param;
                this.setType((PDOMLinkage)this.getLinkage(), nonTypeParm.getType());
                Database db = this.getDB();
                this.setDefaultValue(db, nonTypeParm);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    private boolean setDefaultValue(Database db, ICPPTemplateNonTypeParameter nonTypeParm) throws CoreException {
        IValue sval;
        ICPPTemplateArgument val = nonTypeParm.getDefaultValue();
        if (val != null && (sval = val.getNonTypeValue()) != null) {
            long valueRec = PDOMValue.store(db, (PDOMLinkage)this.getLinkage(), sval);
            db.putRecPtr(this.record + 36L, valueRec);
            return true;
        }
        return false;
    }

    public IType getType() {
        try {
            long typeRec = this.getDB().getRecPtr(this.record + 28L);
            return (IType)((Object)((PDOMLinkage)this.getLinkage()).getNode(typeRec));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public IValue getInitialValue() {
        return null;
    }

    public boolean isAuto() {
        return false;
    }

    public boolean isExtern() {
        return false;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public Object clone() {
        this.fail();
        return null;
    }

    @Deprecated
    public IASTExpression getDefault() {
        return null;
    }
}

