/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedMachineEvent;
import org.eclipse.ptp.core.elements.events.IChangedQueueEvent;
import org.eclipse.ptp.core.elements.events.IJobChangeEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewMachineEvent;
import org.eclipse.ptp.core.elements.events.INewQueueEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveMachineEvent;
import org.eclipse.ptp.core.elements.events.IRemoveQueueEvent;
import org.eclipse.ptp.core.elements.events.IResourceManagerChangeEvent;
import org.eclipse.ptp.core.elements.events.IResourceManagerErrorEvent;
import org.eclipse.ptp.core.elements.events.IResourceManagerSubmitJobErrorEvent;
import org.eclipse.ptp.core.elements.listeners.IJobListener;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerListener;
import org.eclipse.ptp.core.events.IChangedResourceManagerEvent;
import org.eclipse.ptp.core.events.INewResourceManagerEvent;
import org.eclipse.ptp.core.events.IRemoveResourceManagerEvent;
import org.eclipse.ptp.core.listeners.IModelManagerChildListener;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.data.ISynchronizationRule;
import org.eclipse.ptp.launch.data.RuleFactory;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.rulesengine.ILaunchProcessCallback;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.ptp.launch.rulesengine.RuleActionFactory;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationFactory;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParallelLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchProcessCallback {
    private int jobCount = 0;
    private final IModelManagerChildListener modelManagerChildListener = new MMChildListener();
    private final IResourceManagerChildListener resourceManagerChildListener = new RMChildListener();
    private final IResourceManagerListener resourceManagerListener = new RMListener();
    private final IQueueChildListener queueChildListener = new QueueChildListener();
    private final IJobListener jobListener = new JobListener();
    protected Map<String, JobSubmission> jobSubmissions = Collections.synchronizedMap(new HashMap());
    private List<ISynchronizationRule> extraSynchronizationRules;

    protected static String getArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", null);
    }

    protected static String getDebuggerExePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
    }

    protected static String getDebuggerID(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_ID", null);
    }

    protected static boolean getDebuggerStopInMainFlag(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.STOP_IN_MAIN", false);
    }

    protected static String getDebuggerWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    protected static String[] getEnvironmentToAppend(ILaunchConfiguration configuration) throws CoreException {
        Map defaultEnv = null;
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, defaultEnv);
        if (configEnv == null) {
            return null;
        }
        if (!configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true)) {
            throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Parallel_launcher_does_not_support));
        }
        ArrayList<String> strings = new ArrayList<String>(configEnv.size());
        for (Map.Entry entry : configEnv.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            strings.add(String.valueOf(key) + "=" + value);
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected static String getExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
    }

    @Deprecated
    protected static String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.APPLICATION_NAME", null);
    }

    protected static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
    }

    protected static String getQueueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.QUEUE_NAME", null);
    }

    protected static String getResourceManagerUniqueName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
    }

    protected static String getWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractParallelLaunchConfigurationDelegate() {
        IModelManager mm;
        IModelManager iModelManager = mm = PTPCorePlugin.getDefault().getModelManager();
        synchronized (iModelManager) {
            IResourceManager[] iResourceManagerArray = mm.getUniverse().getResourceManagers();
            int n = iResourceManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceManager rm = iResourceManagerArray[n2];
                IPQueue[] iPQueueArray = rm.getQueues();
                int n3 = iPQueueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPQueue queue = iPQueueArray[n4];
                    queue.addChildListener(this.queueChildListener);
                    ++n4;
                }
                rm.addChildListener(this.resourceManagerChildListener);
                rm.addElementListener(this.resourceManagerListener);
                ++n2;
            }
            mm.addListener(this.modelManagerChildListener);
        }
    }

    @Override
    public void addSynchronizationRule(ISynchronizationRule rule) {
        this.extraSynchronizationRules.add(rule);
    }

    public boolean getCopyExecutable(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", false);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new PLaunch(configuration, mode, null);
    }

    @Override
    public IRemoteFileManager getLocalFileManager(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServices localServices = PTPRemoteCorePlugin.getDefault().getDefaultServices();
        assert (localServices != null);
        IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
        assert (lconnMgr != null);
        IRemoteConnection lconn = lconnMgr.getConnection(null);
        assert (lconn != null);
        IRemoteFileManager localFileManager = localServices.getFileManager(lconn);
        assert (localFileManager != null);
        return localFileManager;
    }

    @Override
    public IRemoteFileManager getRemoteFileManager(ILaunchConfiguration configuration) throws CoreException {
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        if (rm != null) {
            IRemoteConnection rconn;
            IRemoteConnectionManager rconnMgr;
            IResourceManagerConfiguration conf = rm.getConfiguration();
            IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(conf.getRemoteServicesId());
            if (remoteServices != null && (rconnMgr = remoteServices.getConnectionManager()) != null && (rconn = rconnMgr.getConnection(conf.getConnectionName())) != null && rconn.isOpen()) {
                return remoteServices.getFileManager(rconn);
            }
        }
        return null;
    }

    protected void copyExecutable(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean copyExecutable = this.getCopyExecutable(configuration);
        if (copyExecutable) {
            String remotePath = AbstractParallelLaunchConfigurationDelegate.getExecutablePath(configuration);
            String localPath = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", null);
            if (localPath == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_1));
            }
            this.copyFileToRemoteHost(localPath, remotePath, configuration, monitor);
        }
    }

    protected void copyFileFromRemoteHost(String remotePath, String localPath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRemoteFileManager localFileManager = this.getLocalFileManager(configuration);
        IRemoteFileManager remoteFileManager = this.getRemoteFileManager(configuration);
        if (remoteFileManager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_0));
        }
        IFileStore rres = remoteFileManager.getResource(remotePath);
        if (!rres.fetchInfo(0, monitor).exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Remote_resource_does_not_exist));
        }
        IFileStore lres = localFileManager.getResource(localPath);
        rres.copy(lres, 2, monitor);
    }

    protected void copyFileToRemoteHost(String localPath, String remotePath, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRemoteFileManager localFileManager = this.getLocalFileManager(configuration);
        IRemoteFileManager remoteFileManager = this.getRemoteFileManager(configuration);
        if (remoteFileManager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_0));
        }
        IFileStore lres = localFileManager.getResource(localPath);
        if (!lres.fetchInfo(0, monitor).exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Local_resource_does_not_exist));
        }
        IFileStore rres = remoteFileManager.getResource(remotePath);
        lres.copy(rres, 2, monitor);
    }

    protected abstract void doCleanupLaunch(ILaunchConfiguration var1, String var2, IPLaunch var3);

    protected abstract void doCompleteJobLaunch(ILaunchConfiguration var1, String var2, IPLaunch var3, AttributeManager var4, IPDebugger var5, IPJob var6);

    protected void doPostLaunchSynchronization(ILaunchConfiguration configuration) throws CoreException {
        boolean syncAfter = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_AFTER", false);
        if (!syncAfter) {
            return;
        }
        List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
        RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, this, (IProgressMonitor)new NullProgressMonitor());
        for (Object ruleObj : rulesList) {
            ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
            if (!syncRule.isDownloadRule()) continue;
            IRuleAction action = ruleActFactory.getAction(syncRule);
            action.run();
        }
    }

    protected void doPreLaunchSynchronization(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean syncBefore = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_BEFORE", false);
        if (!syncBefore) {
            return;
        }
        RuleActionFactory ruleActFactory = new RuleActionFactory(configuration, this, monitor);
        List rulesList = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
        for (Object ruleObj : rulesList) {
            ISynchronizationRule syncRule = RuleFactory.createRuleFromString((String)ruleObj);
            if (!syncRule.isUploadRule()) continue;
            IRuleAction action = ruleActFactory.getAction(syncRule);
            action.run();
        }
    }

    protected AttributeManager getAttributeManager(ILaunchConfiguration configuration, String mode) throws CoreException {
        String[] envArr;
        String[] argArr;
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_No_ResourceManager));
        }
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(this.getResourceAttributes(configuration, mode));
        if (attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getQueueIdAttributeDefinition()) == null) {
            IPQueue queue = this.getQueueDefault(rm);
            attrMgr.addAttribute((IAttribute)JobAttributes.getQueueIdAttributeDefinition().create(queue.getID()));
        }
        IPath programPath = this.verifyExecutablePath(configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getExecutableNameAttributeDefinition().create(programPath.lastSegment()));
        String path = programPath.removeLastSegments(1).toString();
        if (path != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(path));
        }
        this.verifyDebuggerPath(configuration);
        Boolean stopInMainFlag = AbstractParallelLaunchConfigurationDelegate.getDebuggerStopInMainFlag(configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerStopInMainFlagAttributeDefinition().create(stopInMainFlag));
        String wd = this.verifyWorkDirectory(configuration);
        if (wd != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(wd));
        }
        if ((argArr = this.getProgramArguments(configuration)) != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])argArr));
        }
        if ((envArr = AbstractParallelLaunchConfigurationDelegate.getEnvironmentToAppend(configuration)) != null) {
            attrMgr.addAttribute((IAttribute)JobAttributes.getEnvironmentAttributeDefinition().create((Comparable[])envArr));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getLaunchedByPTPFlagAttributeDefinition().create(Boolean.valueOf(true)));
        return attrMgr;
    }

    protected IPDebugConfiguration getDebugConfig(ILaunchConfiguration config) throws CoreException {
        return PTPDebugCorePlugin.getDefault().getDebugConfiguration(AbstractParallelLaunchConfigurationDelegate.getDebuggerID(config));
    }

    protected String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArgumentParser ap;
        List args;
        String temp = AbstractParallelLaunchConfigurationDelegate.getArguments(configuration);
        if (temp != null && temp.length() > 0 && (args = (ap = new ArgumentParser(temp)).getTokenList()) != null) {
            return args.toArray(new String[args.size()]);
        }
        return new String[0];
    }

    @Deprecated
    protected IPath getProgramFile(ILaunchConfiguration configuration) throws CoreException {
        IProject project = this.verifyProject(configuration);
        String fileName = AbstractParallelLaunchConfigurationDelegate.getProgramName(configuration);
        if (fileName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_not_specified));
        }
        Path programPath = new Path(fileName);
        if (!programPath.isAbsolute()) {
            programPath = project.getFile((IPath)programPath).getLocation();
        }
        if (!programPath.toFile().exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", 104, Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_does_not_exist, (Throwable)new FileNotFoundException(NLS.bind((String)Messages.AbstractParallelLaunchConfigurationDelegate_Path_not_found, (Object[])new Object[]{programPath.toString()}))));
        }
        return programPath;
    }

    protected IProject getProject(String project) {
        return this.getWorkspaceRoot().getProject(project);
    }

    protected IPQueue getQueueDefault(IResourceManager rm) {
        IPQueue[] queues = rm.getQueues();
        if (queues.length == 0) {
            return null;
        }
        return queues[0];
    }

    protected IAttribute<?, ?, ?>[] getResourceAttributes(ILaunchConfiguration configuration, String mode) throws CoreException {
        IResourceManager rm = this.getResourceManager(configuration);
        AbstractRMLaunchConfigurationFactory rmFactory = PTPLaunchPlugin.getDefault().getRMLaunchConfigurationFactory(rm);
        if (rmFactory == null) {
            return new IAttribute[0];
        }
        IRMLaunchConfigurationDynamicTab rmDynamicTab = rmFactory.create(rm);
        return rmDynamicTab.getAttributes(rm, null, configuration, mode);
    }

    protected IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        String rmUniqueName = AbstractParallelLaunchConfigurationDelegate.getResourceManagerUniqueName(configuration);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return rm;
            }
            ++n2;
        }
        return null;
    }

    protected ISynchronizationRule[] getSynchronizeRules(ILaunchConfiguration configuration) throws CoreException {
        List ruleStrings = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_SYNC_RULES", new ArrayList());
        ArrayList<ISynchronizationRule> result = new ArrayList<ISynchronizationRule>();
        for (Object ruleObj : ruleStrings) {
            String element = (String)ruleObj;
            try {
                ISynchronizationRule rule = RuleFactory.createRuleFromString(element);
                result.add(rule);
            }
            catch (RuntimeException runtimeException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Error_converting_rules));
            }
        }
        return result.toArray(new ISynchronizationRule[result.size()]);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        if (launch.getSourceLocator() == null) {
            IPersistableSourceLocator sourceLocator;
            String id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (id == null) {
                sourceLocator = PTPDebugUIPlugin.createDefaultSourceLocator();
                sourceLocator.initializeDefaults(configuration);
            } else {
                sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (memento == null) {
                    sourceLocator.initializeDefaults(configuration);
                } else {
                    sourceLocator.initializeFromMemento(memento);
                }
            }
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void setSourceLocator(ILaunch launch, ILaunchConfiguration config) throws CoreException {
        this.setDefaultSourceLocator(launch, config);
    }

    protected void submitJob(ILaunchConfiguration configuration, String mode, IPLaunch launch, AttributeManager attrMgr, IPDebugger debugger, IProgressMonitor monitor) throws CoreException {
        IResourceManager rm = this.getResourceManager(configuration);
        if (rm == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_No_ResourceManager));
        }
        JobSubmission jobSub = new JobSubmission(this.jobCount++, configuration, mode, launch, attrMgr, debugger);
        this.jobSubmissions.put(jobSub.getId(), jobSub);
        rm.submitJob(jobSub.getId(), configuration, attrMgr, monitor);
        JobSubStatus status = jobSub.waitFor(monitor);
        if (status == JobSubStatus.ERROR) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", jobSub.getError()));
        }
    }

    @Deprecated
    protected IBinaryParser.IBinaryObject verifyBinary(IProject project, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
        int i = 0;
        while (i < parserRef.length) {
            try {
                IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        FileNotFoundException exception = new FileNotFoundException(Messages.AbstractParallelLaunchConfigurationDelegate_Program_is_not_a_recongnized_executable);
        int code = 107;
        MultiStatus status = new MultiStatus(PTPCorePlugin.getUniqueIdentifier(), code, Messages.AbstractParallelLaunchConfigurationDelegate_Program_is_not_a_recongnized_executable, (Throwable)exception);
        status.add((IStatus)new Status(4, PTPCorePlugin.getUniqueIdentifier(), code, exception == null ? "" : exception.getLocalizedMessage(), (Throwable)exception));
        throw new CoreException((IStatus)status);
    }

    protected void verifyDebuggerPath(ILaunchConfiguration configuration) throws CoreException {
        String dbgPath = AbstractParallelLaunchConfigurationDelegate.getDebuggerExePath(configuration);
        try {
            this.verifyResource(dbgPath, configuration);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Debugger_path_not_found, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    protected IPath verifyExecutablePath(ILaunchConfiguration configuration) throws CoreException {
        if (this.getCopyExecutable(configuration)) {
            return new Path(AbstractParallelLaunchConfigurationDelegate.getExecutablePath(configuration));
        }
        String exePath = AbstractParallelLaunchConfigurationDelegate.getExecutablePath(configuration);
        try {
            return this.verifyResource(exePath, configuration);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Application_file_does_not_exist, (Throwable)new FileNotFoundException(e.getLocalizedMessage())));
        }
    }

    @Deprecated
    protected boolean verifyPath(String path) {
        Path programPath = new Path(path);
        return programPath != null && !programPath.isEmpty() && programPath.toFile().exists();
    }

    protected IProject verifyProject(ILaunchConfiguration configuration) throws CoreException {
        String proName = AbstractParallelLaunchConfigurationDelegate.getProjectName(configuration);
        if (proName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Project_not_specified));
        }
        IProject project = this.getProject(proName);
        if (project == null || !project.exists() || !project.isOpen()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.launch", Messages.AbstractParallelLaunchConfigurationDelegate_Project_does_not_exist_or_is_not_a_project));
        }
        return project;
    }

    protected IPath verifyResource(String path, ILaunchConfiguration configuration) throws CoreException {
        return PTPLaunchPlugin.getDefault().verifyResource(path, configuration);
    }

    protected String verifyWorkDirectory(ILaunchConfiguration configuration) throws CoreException {
        String workPath = AbstractParallelLaunchConfigurationDelegate.getWorkDirectory(configuration);
        IPath path = workPath == null ? this.verifyExecutablePath(configuration).removeLastSegments(1) : this.verifyResource(workPath, configuration);
        return path.toString();
    }

    private final class JobListener
    implements IJobListener {
        private JobListener() {
        }

        public void handleEvent(IJobChangeEvent e) {
            EnumeratedAttribute stateAttr;
            IPJob job = e.getSource();
            AttributeManager attrMgr = e.getAttributes();
            StringAttribute subIdAttr = (StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getSubIdAttributeDefinition());
            if (subIdAttr != null && (stateAttr = (EnumeratedAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition())) != null) {
                JobSubmission jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.get(subIdAttr.getValue());
                if (jobSub != null) {
                    switch ((JobAttributes.State)stateAttr.getValue()) {
                        case RUNNING: {
                            jobSub.setStatus(JobSubStatus.COMPLETED);
                            AbstractParallelLaunchConfigurationDelegate.this.doCompleteJobLaunch(jobSub.getConfiguration(), jobSub.getMode(), jobSub.getLaunch(), jobSub.getAttrMgr(), jobSub.getDebugger(), job);
                            break;
                        }
                        case COMPLETED: {
                            ILaunchConfiguration lconf = jobSub.getConfiguration();
                            try {
                                AbstractParallelLaunchConfigurationDelegate.this.doPostLaunchSynchronization(lconf);
                            }
                            catch (CoreException e1) {
                                PTPLaunchPlugin.log(e1);
                            }
                            AbstractParallelLaunchConfigurationDelegate.this.doCleanupLaunch(jobSub.getConfiguration(), jobSub.getMode(), jobSub.getLaunch());
                            AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.remove(jobSub);
                        }
                    }
                }
                PTPLaunchPlugin.getDefault().notifyJobStateChange(job, (JobAttributes.State)stateAttr.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobSubStatus {
        SUBMITTED,
        COMPLETED,
        ERROR;

    }

    private class JobSubmission {
        private ILaunchConfiguration configuration;
        private String mode;
        private String id;
        private String error = null;
        private IPLaunch launch;
        private AttributeManager attrMgr;
        private IPDebugger debugger;
        private JobSubStatus status = JobSubStatus.SUBMITTED;
        private final ReentrantLock subLock = new ReentrantLock();
        private final Condition subCondition = this.subLock.newCondition();

        public JobSubmission(int count, ILaunchConfiguration configuration, String mode, IPLaunch launch, AttributeManager attrMgr, IPDebugger debugger) {
            this.configuration = configuration;
            this.mode = mode;
            this.launch = launch;
            this.attrMgr = attrMgr;
            this.debugger = debugger;
            this.id = "JOB_" + Long.toString(System.currentTimeMillis()) + Integer.toString(count);
        }

        public AttributeManager getAttrMgr() {
            return this.attrMgr;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.configuration;
        }

        public IPDebugger getDebugger() {
            return this.debugger;
        }

        public String getError() {
            return this.error;
        }

        public String getId() {
            return this.id;
        }

        public IPLaunch getLaunch() {
            return this.launch;
        }

        public String getMode() {
            return this.mode;
        }

        public void setError(String error) {
            this.error = error;
            this.setStatus(JobSubStatus.ERROR);
        }

        public void setStatus(JobSubStatus status) {
            this.subLock.lock();
            try {
                this.status = status;
                this.subCondition.signalAll();
            }
            finally {
                this.subLock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        public JobSubStatus waitFor(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private final class MMChildListener
    implements IModelManagerChildListener {
        private MMChildListener() {
        }

        public void handleEvent(IChangedResourceManagerEvent e) {
        }

        public void handleEvent(INewResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.addChildListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerChildListener);
            rm.addElementListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerListener);
        }

        public void handleEvent(IRemoveResourceManagerEvent e) {
            IResourceManager rm = e.getResourceManager();
            rm.removeChildListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerChildListener);
            rm.removeElementListener(AbstractParallelLaunchConfigurationDelegate.this.resourceManagerListener);
        }
    }

    private final class QueueChildListener
    implements IQueueChildListener {
        private QueueChildListener() {
        }

        public void handleEvent(IChangedJobEvent e) {
        }

        public void handleEvent(INewJobEvent e) {
            for (IPJob job : e.getJobs()) {
                EnumeratedAttribute stateAttr;
                StringAttribute subIdAttr = (StringAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getSubIdAttributeDefinition());
                if (subIdAttr != null && (stateAttr = (EnumeratedAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getStateAttributeDefinition())) != null) {
                    PTPLaunchPlugin.getDefault().notifyJobStateChange(job, (JobAttributes.State)stateAttr.getValue());
                }
                job.addElementListener(AbstractParallelLaunchConfigurationDelegate.this.jobListener);
            }
        }

        public void handleEvent(IRemoveJobEvent e) {
            for (IPJob job : e.getJobs()) {
                job.removeElementListener(AbstractParallelLaunchConfigurationDelegate.this.jobListener);
            }
        }
    }

    private final class RMChildListener
    implements IResourceManagerChildListener {
        private RMChildListener() {
        }

        public void handleEvent(IChangedMachineEvent e) {
        }

        public void handleEvent(IChangedQueueEvent e) {
        }

        public void handleEvent(INewMachineEvent e) {
        }

        public void handleEvent(INewQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.addChildListener(AbstractParallelLaunchConfigurationDelegate.this.queueChildListener);
            }
        }

        public void handleEvent(IRemoveMachineEvent e) {
        }

        public void handleEvent(IRemoveQueueEvent e) {
            for (IPQueue queue : e.getQueues()) {
                queue.removeChildListener(AbstractParallelLaunchConfigurationDelegate.this.queueChildListener);
            }
        }
    }

    private final class RMListener
    implements IResourceManagerListener {
        private RMListener() {
        }

        public void handleEvent(IResourceManagerChangeEvent e) {
        }

        public void handleEvent(IResourceManagerErrorEvent e) {
        }

        public void handleEvent(IResourceManagerSubmitJobErrorEvent e) {
            JobSubmission jobSub = AbstractParallelLaunchConfigurationDelegate.this.jobSubmissions.remove(e.getJobSubmissionId());
            jobSub.setError(e.getMessage());
        }
    }
}

