/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.VisibilityCollector;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAllocatableStmtNode;
import org.eclipse.photran.internal.core.parser.ASTArrayAllocationNode;
import org.eclipse.photran.internal.core.parser.ASTArrayDeclaratorNode;
import org.eclipse.photran.internal.core.parser.ASTAsynchronousStmtNode;
import org.eclipse.photran.internal.core.parser.ASTBindStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockBinding;
import org.eclipse.photran.internal.core.parser.ASTDimensionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTIntentParListNode;
import org.eclipse.photran.internal.core.parser.ASTIntentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTNamedConstantDefNode;
import org.eclipse.photran.internal.core.parser.ASTOptionalParListNode;
import org.eclipse.photran.internal.core.parser.ASTOptionalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTParameterStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPointerStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPointerStmtObjectNode;
import org.eclipse.photran.internal.core.parser.ASTProtectedStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSaveStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSavedEntityNode;
import org.eclipse.photran.internal.core.parser.ASTTargetObjectNode;
import org.eclipse.photran.internal.core.parser.ASTTargetStmtNode;
import org.eclipse.photran.internal.core.parser.ASTValueStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVariableNameNode;
import org.eclipse.photran.internal.core.parser.ASTVolatileStmtNode;
import org.eclipse.photran.internal.core.parser.IBindEntity;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

class SpecificationCollector
extends VisibilityCollector {
    SpecificationCollector() {
    }

    public void visitASTIntentStmtNode(ASTIntentStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTIntentParListNode> list = node.getVariableList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTIntentParListNode)list.get(i)).getVariableName());
            for (PhotranTokenRef tr : bindings) {
                Definition def = this.vpg.getDefinitionFor(tr);
                def.setIntent(node.getIntentSpec());
                this.vpg.setDefinitionFor(tr, def);
            }
            ++i;
        }
    }

    public void visitASTOptionalStmtNode(ASTOptionalStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTOptionalParListNode> list = node.getVariableList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTOptionalParListNode)list.get(i)).getVariableName());
            for (PhotranTokenRef tr : bindings) {
                Definition def = this.vpg.getDefinitionFor(tr);
                def.setOptional();
                this.vpg.setDefinitionFor(tr, def);
            }
            ++i;
        }
    }

    public void visitASTSaveStmtNode(ASTSaveStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTSavedEntityNode> list = node.getVariableList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            Definition def;
            List<PhotranTokenRef> bindings;
            ASTSavedEntityNode entity = (ASTSavedEntityNode)list.get(i);
            if (entity.getVariableName() != null) {
                bindings = this.bind(entity.getVariableName());
                for (PhotranTokenRef tr : bindings) {
                    def = this.vpg.getDefinitionFor(tr);
                    def.setSave();
                    this.vpg.setDefinitionFor(tr, def);
                }
            } else if (entity.getCommonBlockName() != null) {
                bindings = this.bind(entity.getCommonBlockName());
                for (PhotranTokenRef tr : bindings) {
                    def = this.vpg.getDefinitionFor(tr);
                    def.setSave();
                    this.vpg.setDefinitionFor(tr, def);
                }
            }
            ++i;
        }
    }

    public void visitASTDimensionStmtNode(ASTDimensionStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTArrayDeclaratorNode> decls = node.getArrayDeclaratorList();
        int i = 0;
        while (i < decls.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTArrayDeclaratorNode)decls.get(i)).getVariableName());
            try {
                for (PhotranTokenRef tr : bindings) {
                    Definition def = this.vpg.getDefinitionFor(tr);
                    def.setArraySpec(((ASTArrayDeclaratorNode)decls.get(i)).getArraySpec());
                    this.vpg.setDefinitionFor(tr, def);
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            ++i;
        }
    }

    public void visitASTAllocatableStmtNode(ASTAllocatableStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTArrayAllocationNode> list = node.getArrayAllocationList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTArrayAllocationNode)list.get(i)).getArrayName());
            for (PhotranTokenRef tr : bindings) {
                Definition def = this.vpg.getDefinitionFor(tr);
                def.setAllocatable();
                this.vpg.setDefinitionFor(tr, def);
            }
            ++i;
        }
    }

    public void visitASTPointerStmtNode(ASTPointerStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTPointerStmtObjectNode> list = node.getPointerStmtObjectList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTPointerStmtObjectNode)list.get(i)).getPointerName());
            for (PhotranTokenRef tr : bindings) {
                Definition def = this.vpg.getDefinitionFor(tr);
                def.setPointer();
                this.vpg.setDefinitionFor(tr, def);
            }
            ++i;
        }
    }

    public void visitASTTargetStmtNode(ASTTargetStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTTargetObjectNode> list = node.getTargetObjectList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTTargetObjectNode)list.get(i)).getTargetName());
            for (PhotranTokenRef tr : bindings) {
                Definition def = this.vpg.getDefinitionFor(tr);
                def.setTarget();
                this.vpg.setDefinitionFor(tr, def);
            }
            ++i;
        }
    }

    public void visitASTParameterStmtNode(ASTParameterStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<ASTNamedConstantDefNode> list = node.getNamedConstantDefList();
        int i = 0;
        while (i < list.size()) {
            List<PhotranTokenRef> bindings = this.bind(((ASTNamedConstantDefNode)list.get(i)).getNamedConstant());
            try {
                for (PhotranTokenRef tr : bindings) {
                    Definition def = this.vpg.getDefinitionFor(tr);
                    def.setParameter();
                    this.vpg.setDefinitionFor(tr, def);
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            ++i;
        }
    }

    public void visitASTAsynchronousStmtNode(ASTAsynchronousStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<Token> list = node.getObjectList();
        int i = 0;
        while (i < list.size()) {
            this.bind((Token)list.get(i));
            ++i;
        }
    }

    public void visitASTBindStmtNode(ASTBindStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<IBindEntity> list = node.getBindEntityList();
        int i = 0;
        while (i < list.size()) {
            IBindEntity entity = (IBindEntity)list.get(i);
            if (entity instanceof ASTCommonBlockBinding) {
                this.bind(((ASTCommonBlockBinding)entity).getCommonBlockName());
            } else {
                this.bind(((ASTVariableNameNode)entity).getVariableName());
            }
            ++i;
        }
    }

    public void visitASTProtectedStmtNode(ASTProtectedStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<Token> list = node.getEntityNameList();
        int i = 0;
        while (i < list.size()) {
            this.bind((Token)list.get(i));
            ++i;
        }
    }

    public void visitASTValueStmtNode(ASTValueStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<Token> list = node.getEntityNameList();
        int i = 0;
        while (i < list.size()) {
            this.bind((Token)list.get(i));
            ++i;
        }
    }

    public void visitASTVolatileStmtNode(ASTVolatileStmtNode node) {
        super.traverseChildren(node);
        Parser.IASTListNode<Token> list = node.getEntityNameList();
        int i = 0;
        while (i < list.size()) {
            this.bind((Token)list.get(i));
            ++i;
        }
    }
}

