/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.refactoring.infrastructure.AbstractFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SingleFileFortranRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.TokenRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoring
extends SingleFileFortranRefactoring {
    private Definition definitionToRename = null;
    private Collection<PhotranTokenRef> allReferences = null;
    private String oldName = null;
    private String newName = null;
    private boolean shouldBindInterfacesAndExternals = true;

    public String getName() {
        return "Rename";
    }

    public String getOldNameOfIdentifier() {
        assert (this.oldName != null);
        return this.oldName;
    }

    public void setNewNameForIdentifier(String newName) {
        assert (newName != null);
        this.newName = newName;
    }

    public void setShouldBindInterfacesAndExternals(boolean value) {
        this.shouldBindInterfacesAndExternals = value;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws AbstractFortranRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.oldName = this.findEnclosingToken().getText();
        this.definitionToRename = this.findDeclarationToRename();
        this.checkIfDefinitionCanBeRenamed();
    }

    private Token findEnclosingToken() throws AbstractFortranRefactoring.PreconditionFailure {
        Token selectedToken = this.findEnclosingToken(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedToken == null || !this.isIdentifier(selectedToken)) {
            this.fail("Please select an identifier to rename.");
        }
        return selectedToken;
    }

    private Definition findDeclarationToRename() throws AbstractFortranRefactoring.PreconditionFailure {
        List<Definition> declarations = this.findEnclosingToken().resolveBinding();
        if (declarations.size() == 0) {
            this.fail("No declaration was found for " + this.oldName);
        } else if (declarations.size() > 1) {
            this.fail("Multiple declarations were found for " + this.oldName);
        }
        return declarations.get(0);
    }

    private void checkIfDefinitionCanBeRenamed() throws AbstractFortranRefactoring.PreconditionFailure {
        if (this.definitionToRename.isSubprogramArgument()) {
            this.fail("Subprogram arguments cannot be renamed.");
        }
        if (this.definitionToRename.isTypeBoundProcedure() && !this.definitionToRename.isRenamedTypeBoundProcedure()) {
            this.fail("Type-bound procedures cannot be renamed.");
        }
        if (!(this.definitionToRename.isLocalVariable() || this.definitionToRename.isSubprogram() || this.definitionToRename.isExternal() || this.definitionToRename.isInterface() || this.definitionToRename.isDerivedType() || this.definitionToRename.isModuleEntityBeforeRename() || this.definitionToRename.isRenamedModuleEntity() || this.definitionToRename.isMainProgram() || this.definitionToRename.isNamelist() || this.definitionToRename.isCommon() || this.definitionToRename.isBlockData())) {
            this.fail("The " + this.definitionToRename.describeClassification() + " " + this.oldName + " cannot be renamed.  " + "Only local variables, subprograms and interfaces, derived types, main programs, namelists, " + "common blocks, and block data subprograms can be renamed.  Derived type components and subprogram " + "arguments cannot be renamed.");
        }
        if (this.definitionToRename.isIntrinsic()) {
            this.fail(String.valueOf(this.oldName) + " cannot be renamed: It is an intrinsic procedure.");
        }
        if (this.isPreprocessed(this.definitionToRename.getTokenRef().findToken())) {
            this.fail(String.valueOf(this.oldName) + " cannot be renamed: It is declared in an INCLUDE file.");
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws AbstractFortranRefactoring.PreconditionFailure {
        assert (this.definitionToRename != null);
        assert (this.newName != null);
        assert (this.allReferences == null);
        if (this.newName.equals(this.oldName)) {
            this.fail("The new name (" + this.newName + ") is exactly the same as the old name!");
        }
        if (!this.isValidIdentifier(this.newName)) {
            this.fail(String.valueOf(this.newName) + " is not a valid identifier");
        }
        this.allReferences = this.definitionToRename.findAllReferences(this.shouldBindInterfacesAndExternals);
        this.removeFixedFormReferences(status);
        this.checkIfReferencesCanBeRenamed(pm);
        this.checkForConflictingBindings(pm, (AbstractFortranRefactoring.IConflictingBindingCallback)new ConflictingBindingErrorHandler(status), this.definitionToRename, this.allReferences, this.newName);
    }

    private void removeFixedFormReferences(RefactoringStatus status) {
        HashSet<IFile> fixedFormFiles = new HashSet<IFile>();
        HashSet<IFile> freeFormFiles = new HashSet<IFile>();
        HashSet<PhotranTokenRef> referencesToRemove = new HashSet<PhotranTokenRef>();
        for (PhotranTokenRef reference : this.allReferences) {
            IFile file = reference.getFile();
            if (fixedFormFiles.contains(file)) {
                referencesToRemove.add(reference);
                continue;
            }
            if (freeFormFiles.contains(file)) continue;
            if (PhotranVPG.hasFixedFormContentType(file)) {
                fixedFormFiles.add(file);
                status.addError("The fixed form file " + file.getName() + " will not be refactored.");
                referencesToRemove.add(reference);
                continue;
            }
            freeFormFiles.add(file);
        }
        this.allReferences.removeAll(referencesToRemove);
    }

    private void checkIfReferencesCanBeRenamed(IProgressMonitor pm) throws AbstractFortranRefactoring.PreconditionFailure {
        for (PhotranTokenRef ref : this.allReferences) {
            pm.subTask("Checking if references in " + ref.getFilename() + " can be renamed");
            Token reference = ref.findToken();
            if (reference.resolveBinding().size() > 1) {
                this.fail(String.valueOf(this.oldName) + " cannot be renamed: " + this.describeToken(reference) + " is an ambiguous reference " + " (it refers to " + this.oldName + " but may refer to another entity as well).");
            }
            if (!this.isPreprocessed(reference)) continue;
            this.fail(String.valueOf(this.oldName) + " cannot be renamed: It would require modifying an INCLUDE file " + " (" + this.describeToken(reference) + ").");
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.definitionToRename != null);
        assert (this.allReferences != null);
        assert (this.newName != null);
        Set<IFile> filesToChange = this.determineFilesToChange();
        pm.beginTask("Renaming", filesToChange.size());
        try {
            for (IFile file : filesToChange) {
                this.makeChangesTo(file, pm);
            }
        }
        finally {
            this.vpg.releaseAllASTs();
            pm.done();
        }
    }

    private Set<IFile> determineFilesToChange() {
        HashSet<IFile> files = new HashSet<IFile>(this.allReferences.size() + 2);
        files.add(this.fileInEditor);
        files.add(this.definitionToRename.getTokenRef().getFile());
        for (PhotranTokenRef ref : this.allReferences) {
            files.add(ref.getFile());
        }
        return files;
    }

    private void makeChangesTo(IFile file, IProgressMonitor pm) throws Error {
        try {
            pm.subTask("Modifying " + file.getName());
            pm.worked(1);
            this.vpg.acquirePermanentAST(file);
            if (this.definitionToRename.getTokenRef().getFile().equals((Object)file)) {
                this.definitionToRename.getTokenRef().findToken().setText(this.newName);
            }
            for (PhotranTokenRef ref : this.allReferences) {
                if (!ref.getFile().equals((Object)file)) continue;
                ref.findToken().setText(this.newName);
            }
            this.addChangeFromModifiedAST(file, pm);
            this.vpg.releaseAST(file);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConflictingBindingErrorHandler
    implements AbstractFortranRefactoring.IConflictingBindingCallback {
        private final RefactoringStatus status;

        private ConflictingBindingErrorHandler(RefactoringStatus status) {
            this.status = status;
        }

        @Override
        public void addConflictError(List<AbstractFortranRefactoring.Conflict> conflictingDef) {
            AbstractFortranRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" conflicts with " + RenameRefactoring.this.vpg.getDefinitionFor(conflict.tokenRef);
            RefactoringStatusContext context = RenameRefactoring.this.createContext((TokenRef<Token>)conflict.tokenRef);
            this.status.addError(msg, context);
        }

        @Override
        public void addConflictWarning(List<AbstractFortranRefactoring.Conflict> conflictingDef) {
            AbstractFortranRefactoring.Conflict conflict = conflictingDef.get(0);
            String msg = "The name \"" + conflict.name + "\" might conflict with the name of an invoked subprogram";
            RefactoringStatusContext context = RenameRefactoring.this.createContext((TokenRef<Token>)conflict.tokenRef);
            this.status.addWarning(msg, context);
        }

        @Override
        public void addReferenceWillChangeError(String newName, Token reference) {
            this.status.addError("Changing the name to \"" + newName + "\"" + " would change the meaning of \"" + reference.getText() + "\" on line " + reference.getLine() + " in " + reference.getTokenRef().getFilename(), RenameRefactoring.this.createContext(reference));
        }
    }
}

