/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPICH2HostMap {
    List<Host> hosts = new ArrayList<Host>();
    Map<String, Host> hostNameToHost = new HashMap<String, Host>();
    public boolean hasErrors = false;

    protected void addHost(Host host) {
        this.hosts.add(host);
        this.hostNameToHost.put(host.getName(), host);
    }

    public Host[] getHosts() {
        return this.hosts.toArray(new Host[this.hosts.size()]);
    }

    public Iterator<Host> getHostIterator() {
        return this.hosts.listIterator();
    }

    public Host getHostByName(String name) {
        return this.hostNameToHost.get(name);
    }

    public void addHost(String name, String address, String port) {
        Host host = new Host(name, address, port);
        this.addHost(host);
    }

    public int count() {
        return this.hosts.size();
    }

    public boolean hasParseErrors() {
        return this.hasErrors;
    }

    public static class Host {
        public static final int NO_ERRORS = 0;
        public static final int ERR_NUM_SLOTS = 2;
        public static final int ERR_MAX_NUM_SLOTS = 4;
        public static final int ERR_UNKNOWN_ATTR = 8;
        private String name = null;
        private String addr = null;
        private String port = null;
        private int numProcessors = 0;
        private int maxNumProcessors = 0;
        private int errors = 0;

        public Host(String hostname, String address, String port) {
            this.name = hostname;
            this.addr = address;
            this.port = port;
        }

        public int getNumProcessors() {
            return this.numProcessors;
        }

        public int getMaxNumProcessors() {
            return this.maxNumProcessors;
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.addr;
        }

        public String getPort() {
            return this.port;
        }

        public int getErrors() {
            return this.errors;
        }

        public void setNumProcessors(int numProcessors) {
            this.numProcessors = numProcessors;
        }

        public void setMaxNumProcessors(int maxNumProcessors) {
            this.maxNumProcessors = maxNumProcessors;
        }

        public void addErrors(int errors) {
            this.errors |= errors;
        }
    }
}

